#include "multicastsocket.h"

#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "exception.h"

extern bool isServer;

MulticastSocket::MulticastSocket() {
	retransmit = false;

}


MulticastSocket::~MulticastSocket(){}



bool MulticastSocket::init(const char* localAddr, const char* multicastAddr, short port){

	ip_mreq mreq;

	if (isServer){

		if (inet_aton(localAddr,&discPacket.addr) <= 0){
			throw new Exception(this,"Bad address format");
			return false;
		}
	}


	if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) <= 0) {
		throw new Exception(this);
		return false;
	}

	char one = 1;

	setsockopt(fd, SOL_SOCKET, SO_BROADCAST,&one, sizeof(one));

	sin_len = sizeof(serverSockAddr);

	serverSockAddr.sin_family = AF_INET;
	serverSockAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	serverSockAddr.sin_port = htons(port);

	bzero(&sendSockAddr,sizeof(sendSockAddr));
	sendSockAddr.sin_family = AF_INET;
	sendSockAddr.sin_port = htons(port);
	inet_aton(multicastAddr,&sendSockAddr.sin_addr);

	if (bind(fd,(sockaddr*)&serverSockAddr,sizeof(serverSockAddr)) < 0) {
		throw new Exception(this);
		return false;
	}

	if (inet_aton(multicastAddr,&mreq.imr_multiaddr) == 0) {
		throw new Exception(this,"Bad address format");
		return false;
	}

	mreq.imr_interface.s_addr = INADDR_ANY;
	if (setsockopt(fd,SOL_IP,IP_ADD_MEMBERSHIP,&mreq, sizeof(mreq)) != 0) {
		throw new Exception(this);
		return false;
	}

	return true;

}






