#include "nodeclient.h"

#include "hexutil.h"
#include "softwaregatewayclients.h"
#include "connectionmanager.h"

extern bool isServer;

NodeClient::NodeClient(){}

NodeClient::~NodeClient(){
}


void NodeClient::performService(ConnectionManager* conn){

	if (!recieveSize(RADIO_PACKET_LENGTH))
		return;


	if (isServer){

		SoftwareGatewayCommandClient* node = conn->getSoftwareGatewayCommandClient();
		HexUtil::printHexString("From Client Node",buffer,recieved);
		if (node != 0){
			node->sendMsg(buffer,node->RADIO_COMMAND);

		}

	}
	else {
		ClientSocket* node = conn->getSerialClient();
		if (node != 0){
			HexUtil::printHexString("From Gateway Node",buffer,recieved);
			node->send(buffer,recieved);
		}
	}


}
