#ifndef _SERIAL_CLIENTS_H
#define _SERIAL_CLIENTS_H

#include <termios.h>

#include "clientsocket.h"
#include "hexutil.h"



class SerialClient : public ClientSocket {

public:
	SerialClient();
	~SerialClient();

	virtual const char* getName(){return "Serial client";}
	virtual void performService(ConnectionManager* conn);
private:
	virtual bool recieveMsg();

};


class AsciiHexSerialClient : public SerialClient{

public:

	AsciiHexSerialClient();
	~AsciiHexSerialClient();

	virtual const char* getName(){return "ASCII-hex serial client";}

	virtual void send(unsigned char *data, int length);

private:
	HexUtil hexUtil;
	virtual bool recieveMsg();


};







class SerialPort : public SerialClient {

public:
	SerialPort(char* commName);
	~SerialPort();

	static const char uart_frame_vals[3];

	virtual void recieve(unsigned char *buffer, int bufferSize);
	virtual void send(unsigned char *data, int length);

private:

	static const char* comPorts[][2];
	termios origtio;
	const char *filenameForCommPort(char *commName);



};








#endif
