#include "serversocket.h"
#include <strings.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <unistd.h>

#include "exception.h"
#include "appclients.h"
#include "nodeclient.h"




ServerSocket::ServerSocket(){}


bool ServerSocket::bindAndListen(short port){
  	sockaddr_in serverSockAddr;

	fd = socket(AF_INET,SOCK_STREAM,0);

	if (fd == SOCKET_ERROR){
		throw new Exception(this);
		return false;
	}

	serverSockAddr.sin_addr.s_addr = INADDR_ANY;
	serverSockAddr.sin_port = htons(port);
	serverSockAddr.sin_family = AF_INET;

	int reuse_opt = 1;

	if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &reuse_opt, sizeof(reuse_opt)) == SOCKET_ERROR) {
		throw new Exception(this);
		return false;
	}


	if (bind(fd,(struct sockaddr*)&serverSockAddr, sizeof(sockaddr_in))  == SOCKET_ERROR) {
		throw new Exception(this);
		return false;
	}


	if (listen(fd,32) == SOCKET_ERROR){
		throw new Exception(this);
		return false;
	}

	return true;
}

ServerSocket::~ServerSocket(){
	close(fd);
}


void ServerSocket::performService(ConnectionManager* conn){
	printf("Accept New Client\n");
	sockaddr_in client;
	int nAddressSize = sizeof(sockaddr_in);
	int newClientSock = accept(fd, (struct sockaddr*)&client, (socklen_t *)&nAddressSize);
	ClientSocket* cSocket = acceptNewClient();
	cSocket->setFileDescriptor(newClientSock);
	conn->addIOStream(cSocket);
}

AsciiHexAppServer::AsciiHexAppServer(){}

AsciiHexAppServer::~AsciiHexAppServer(){}

NodeServer::NodeServer(){}

NodeServer::~NodeServer(){}



ClientSocket* AsciiHexAppServer::acceptNewClient(){
	return new AsciiHexAppClient();
}

ClientSocket* NodeServer::acceptNewClient(){
	return new NodeClient();
}





