#ifndef _SERVERSOCKET_H
#define _SERVERSOCKET_H

#include "clientsocket.h"
#include "connectionmanager.h"


class ServerSocket : public ioStream {

public:
	ServerSocket();
	virtual ~ServerSocket();
	bool bindAndListen(short port);
	virtual ClientSocket* acceptNewClient() = 0;
	virtual void performService(ConnectionManager* conn);
	virtual const char* getName() = 0;


};


class NodeServer : public ServerSocket {

public:
	NodeServer();
	~NodeServer();
	virtual ClientSocket* acceptNewClient();

	virtual const char* getName(){return "Node server";}

};


class AsciiHexAppServer : public ServerSocket {

public:
	AsciiHexAppServer();
	~AsciiHexAppServer();
	virtual ClientSocket* acceptNewClient();
	virtual const char* getName(){return "ASCII-hex application server";}

};

#endif

