#ifndef _SOFTWARE_GATEWAY_CLIENTS_H
#define _SOFTWARE_GATEWAY_CLIENTS_H

#include "clientsocket.h"
#include "packet.h"

class SoftwareGatewayEventClient : public ClientSocket {

public:
	SoftwareGatewayEventClient();
	~SoftwareGatewayEventClient();

	virtual void performService(ConnectionManager* conn);
	virtual const char* getName(){return "Software gateway event client";}

	const short UART_EVENT;
	const short RADIO_EVENT;

};

class SoftwareGatewayCommandClient : public ClientSocket {

public:
	SoftwareGatewayCommandClient();
	~SoftwareGatewayCommandClient();

	virtual void performService(ConnectionManager* conn){}
	virtual const char* getName(){return "Software gateway command client";}

	virtual void sendMsg(unsigned char* data, const short command);

	const short UART_COMMAND;
	const short RADIO_COMMAND;

private:

	void bufferToSimMsg(unsigned char* buffer, short command);
	SimMsg simMsg;

};


#endif

