/*                                                                      tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *
 */
/*                                                                      tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*                                                                      tab:4
 * Copyright (c) 2003 Intel Corporation
 * All rights reserved Contributions to the above software program by Intel
 * Corporation is program is licensed subject to the BSD License, available at
 * http://www.opensource.org/licenses/bsd-license.html
 *
 */
/*
 * Authors:     Mark Yarvis, York Liu, Nandu Kushalnagar
 *
 */
/*
 * Warning!  Don't use this module with NeighborQualityList.  The quality
 * scale is different from NeighborBiDirQualityList and 
 * NeigthborOutboundQualityList.
 */
configuration DSDV_QualityMetric {
   provides {
      interface StdControl;
      interface RouteUpdate;
      interface RouteLookup;
      interface Settings[uint8_t id];
      interface Router;
   }
#if ENERGY_METRIC
   uses {
      interface SphereSettings;
   }
#endif
   uses {
      interface Leds;
      event void triggerRouteAdvertisement();
   }
}
implementation {
   components DSDV_QualityMetricM,
              SingleHopManager,
#if ENERGY_METRIC
              EnergyMetric as NeighborQuality;
#else
              ReliabilityMetric as NeighborQuality;
#endif

   DSDV_QualityMetricM.StdControl = StdControl;
   DSDV_QualityMetricM.RouteUpdate = RouteUpdate;
   DSDV_QualityMetricM.RouteLookup = RouteLookup;
   DSDV_QualityMetricM.Router = Router;
   DSDV_QualityMetricM.Leds = Leds;

   Settings = NeighborQuality.Settings;

   SingleHopManager.SequenceNumber <- NeighborQuality;

   DSDV_QualityMetricM.QualityControl -> NeighborQuality;
   DSDV_QualityMetricM.NeighborQuality -> NeighborQuality;
   DSDV_QualityMetricM.Neighbors -> NeighborQuality;
   DSDV_QualityMetricM.Piggyback -> NeighborQuality;

#if ENERGY_METRIC
   NeighborQuality.SphereSettings = SphereSettings;
#endif

   triggerRouteAdvertisement = DSDV_QualityMetricM.triggerRouteAdvertisement;
}
