includes WSN;

module DSDV_SoI_Settings {
   provides {
      interface Settings as SoISettings;   /* For GenericSetting */
      interface SphereSettings;   /* For DSDV_SoI_Metric */
      command bool isAdjuvantNode();   /* For TinyDBShim */
   }
   uses {
      /* We want to utilize the default event in the case of TinyDBShim is
         not hookup */
      event uint16_t getAdjuvantValue();
   }
}

implementation {

   /* Set by Metric module at the init, update by Setting at run time */
   bool     amAdjuvantNode;
   bool     isSoIEnabled;
   bool     useHSNValue;	// TRUE to get from TinyDB, init is FALSE
   uint16_t defaultValueFunc;

   command bool isAdjuvantNode() {
      return (isSoIEnabled && amAdjuvantNode);
   }

   enum {
      SETTING_FLAG_SOI_ENABLED      = 0x1,
      SETTING_FLAG_MAKE_ADJUVANT    = 0x2,
      SETTING_FLAG_MAKE_NONADJUVANT = 0x4
   };


   /* SphereSettings */

   default event void SphereSettings.enableSoI(bool ToF) {
      return;
   }

   default event void SphereSettings.enableAdjuvantNode(bool ToF) {
      return;
   }

   default event wsnAddr SphereSettings.getPrimarySphereID() {
      return INVALID_NODE_ID;
   }

   command void SphereSettings.setDefault(bool SoI, bool Adjuvant, uint16_t Val) {
      isSoIEnabled = SoI;
      amAdjuvantNode = Adjuvant;
      useHSNValue = FALSE;	// Default is not to use the value from TinyDB

#ifdef ADJUVANT_NODE_ID
      if (TOS_LOCAL_ADDRESS == ADJUVANT_NODE_ID)
         useHSNValue = TRUE;	// Simulator, I'm by default adj. Ask TinyDB
#endif

      defaultValueFunc = Val;
      return;
   }

   command uint16_t SphereSettings.getAdjuvantValue() {
      return (useHSNValue?signal getAdjuvantValue():defaultValueFunc);
   }

   /* HSNValue */

   default event uint16_t getAdjuvantValue() {
      /* Return default value func if the TinyDB is not connected */
      return defaultValueFunc;
   }

   /* SoISetting */

   command result_t SoISettings.updateSetting(uint8_t *buf, uint8_t *len) {

      uint8_t i;

      if ((*len < 3) || (*len < buf[2] + 3)) {
         return FAIL;
      }

      if (buf[0] & SETTING_FLAG_SOI_ENABLED) {
         isSoIEnabled = TRUE;
         signal SphereSettings.enableSoI(TRUE);
      } else {
         isSoIEnabled = FALSE;
         signal SphereSettings.enableSoI(FALSE);
      }

      for (i=0; i< buf[2]; i++) {
         // WARNING: casting an address to a byte
         if (buf[i+3] == (uint8_t) TOS_LOCAL_ADDRESS) {
            if (buf[0] & SETTING_FLAG_MAKE_ADJUVANT) {
               defaultValueFunc = buf[1];  /* used if the TinyDB is not wired */
               useHSNValue = (defaultValueFunc == 255?TRUE:FALSE);
               amAdjuvantNode = TRUE;
               signal SphereSettings.enableAdjuvantNode(TRUE);
            }
            if (buf[0] & SETTING_FLAG_MAKE_NONADJUVANT) {
               amAdjuvantNode = FALSE;
               signal SphereSettings.enableAdjuvantNode(FALSE);
            }
         }
      }

      *len = buf[2] + 3;
      return SUCCESS;
   }

   command result_t SoISettings.fillSetting(uint8_t *buf, uint8_t *len) {
      if (*len < 2) {
         return FAIL;
      }

      buf[0] = 0;

      if (isSoIEnabled == TRUE) {
         buf[0] &= SETTING_FLAG_SOI_ENABLED;
      }

      if (amAdjuvantNode == TRUE) {
         buf[0] &= SETTING_FLAG_MAKE_ADJUVANT;
      }

      buf[1] = signal SphereSettings.getPrimarySphereID();

      *len = 2;

      return SUCCESS;
   }

}

