/*                                                                      tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *
 */
/*                                                                      tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
 * OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*                                                                      tab:4
 * Copyright (c) 2003 Intel Corporation
 * All rights reserved Contributions to the above software program by Intel
 * Corporation is program is licensed subject to the BSD License, available at
 * http://www.opensource.org/licenses/bsd-license.html
 *
 */
// cost to send each packet
#define PACKET_SEND_COST 19

// cost to receive each packet
#define PACKET_RECEIVE_COST 11

// this is arbitrary
#define STARTING_ENERGY 65000L

module EnergyMetricM
{
   provides {
      interface StdControl;
      interface NeighborQuality;
      interface Piggyback;
      interface Settings as MetricSettings;
   }
   uses {
      interface StdControl as QualityControl;
      interface NeighborQuality as ActualNeighborQuality;
      interface Piggyback as NeighborQualPiggyback;
      interface NeighborAttr;
      interface SphereSettings;
   }
}

implementation {

   uint8_t expNoRetransmission[NUM_QUALITY_LEVELS];
   bool amAdjuvantNode;
   bool soiEnable;


   command result_t StdControl.init() {
      /* Based on 3 maximum retransmissions. */
      //Normalized by a factor of 10
      expNoRetransmission[0] = 24;
      expNoRetransmission[1] = 14;
      expNoRetransmission[2] = 12;
      expNoRetransmission[3] = 11;

      /* Based on 2 maximum retransmissions */
      /*
      expNoRetransmission[0] = 18;
      expNoRetransmission[1] = 14;
      expNoRetransmission[2] = 11;
      expNoRetransmission[3] = 10;
      */


      amAdjuvantNode = FALSE;
      return call QualityControl.init();
   }
   command result_t StdControl.start() {
      return call QualityControl.start();
   }

   command result_t StdControl.stop() {
      return call QualityControl.stop();
   }

   command uint16_t NeighborQuality.getNeighborQuality(wsnAddr addr) {
      uint8_t wallPower = 0;
      result_t ret;

      ret = call NeighborAttr.getAttr(addr, &wallPower);
      if(ret == FAIL) { //should never happen.
         wallPower = 0; //Assume it is not wall powered.
      }

      //If neighbor is wallpowered, the receive cost is zero.
      if(amAdjuvantNode && wallPower)//small number
         return 1;
      else if(amAdjuvantNode) // send cost is zero
         return (expNoRetransmission[call ActualNeighborQuality.getNeighborQuality(addr)]*PACKET_RECEIVE_COST);
      else if(wallPower) // receive cost is zero
         return (expNoRetransmission[call ActualNeighborQuality.getNeighborQuality(addr)]*PACKET_SEND_COST);
      else //both send and receive cost
      {
         dbg(DBG_USR2, "I am in right place \n");
         dbg(DBG_USR2, "Neighbor Attr is %d\n",call ActualNeighborQuality.getNeighborQuality(addr));
         return (expNoRetransmission[call ActualNeighborQuality.getNeighborQuality(addr)]*(PACKET_SEND_COST + PACKET_RECEIVE_COST));
      }
   }

   command uint8_t Piggyback.fillPiggyback(wsnAddr addr, uint8_t* energyStatus,
                                                                uint8_t len) {
     *(energyStatus + len-1) = (uint8_t)amAdjuvantNode; // Last byte of the piggyback
      call NeighborQualPiggyback.fillPiggyback(addr,
                                              energyStatus, len-1);
      return len;
   }

   // Get the energy status information from the neighbor.
   command result_t Piggyback.receivePiggyback(wsnAddr addr, uint8_t* buf,
                                               uint8_t len) {
      call NeighborAttr.setAttr(addr, buf[len-1]);
      return call NeighborQualPiggyback.receivePiggyback(addr, buf, len-1);
   }

   command result_t MetricSettings.updateSetting(uint8_t *buf, uint8_t *len) {
      uint8_t i;

      if (*len < NUM_QUALITY_LEVELS) {
         return FAIL;
      }

      for (i=0; i < NUM_QUALITY_LEVELS; i++) {
         expNoRetransmission[i] = buf[i];
      }

      *len = NUM_QUALITY_LEVELS;

      return SUCCESS;
   }

   command result_t MetricSettings.fillSetting(uint8_t *buf, uint8_t *len) {
      uint8_t i;

      if (*len < NUM_QUALITY_LEVELS) {
         return FAIL;
      }

      for (i=0; i < NUM_QUALITY_LEVELS; i++) {
         buf[i] = expNoRetransmission[i];
      }

      *len = NUM_QUALITY_LEVELS;

      return SUCCESS;
   }

   event void SphereSettings.enableSoI(bool ToF) {
      if(ToF)
         soiEnable = TRUE;
      else
         soiEnable = FALSE;
   }

   event void SphereSettings.enableAdjuvantNode(bool ToF)
   {
      if(ToF)
         amAdjuvantNode = TRUE;
      else
         amAdjuvantNode = FALSE;
   }
   event wsnAddr SphereSettings.getPrimarySphereID()
   {
      return INVALID_NODE_ID;
   }
}
