/*                                                                      tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *
 */
/*                                                                      tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
 * OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*                                                                      tab:4
 * Copyright (c) 2003 Intel Corporation
 * All rights reserved Contributions to the above software program by Intel
 * Corporation is program is licensed subject to the BSD License, available at
 * http://www.opensource.org/licenses/bsd-license.html
 *
 */
// assume 10 sec epoch
#define EPOCH_LENGTH 10

// this is arbitrary
#define STARTING_ENERGY 65000L

// cost to receive an intent from each neighbor during an epoch
#define PER_NEIGHBOR_PER_EPOCH_RESYNC_COST 2

// cost to send one intent during an epoch
#define PER_EPOCH_FIXED_RESYNC_COST 3

// cost to send each packet
#define PACKET_SEND_COST 19

// cost to receive each packet
#define PACKET_RECEIVE_COST 11

module EnergyModelM
{
   provides {
      interface StdControl as Control;
      command uint16_t EnergyConsumed();  /* energy consumed since last epoch */
   }
   uses {
      interface Timer;
      interface Neighbors;
      interface NetStat;
      interface Intercept;
      interface MultiHopMsg;
   }
}

implementation {
   uint16_t remainingEnergy;
   uint16_t previousEnergy;
   uint16_t previousSent;     // # of packets sent, last time we checked
   uint16_t previousReceived; // # of packets received, last time we checked
   uint16_t timeSinceLastUpdate;
   uint16_t previousReport;

   command result_t Control.init() {
      remainingEnergy = STARTING_ENERGY;
      previousEnergy = remainingEnergy;
      previousSent = 0;
      previousReceived = 0;
      previousReport = 0;
      return SUCCESS;
   }

   command result_t Control.start() {
      call Timer.start(TIMER_REPEAT, CLOCK_SCALE);
      return SUCCESS;
   }

   command result_t Control.stop() {
      call Timer.stop();
      return SUCCESS;
   }

// TODO: make sure NEIGHBOR_AGE_CACHE_TIMEOUT is turned on
   event result_t Timer.fired() {
      timeSinceLastUpdate++;
      return SUCCESS;
   }

   void accountForReSyncOverhead() {
      uint16_t energy = 0;

      energy += PER_EPOCH_FIXED_RESYNC_COST;
      energy += PER_NEIGHBOR_PER_EPOCH_RESYNC_COST *
                                    call Neighbors.numNeighbors();

      // ammortize according to time since last updated
      energy = (energy * timeSinceLastUpdate / EPOCH_LENGTH);

      remainingEnergy -= energy;

      return;
   }

   void accountForSentMessages() {
      uint16_t tmp;
      uint16_t recentlySent;
      uint16_t recentlyReceived;

      tmp = call NetStat.sentMessages();
      recentlySent = tmp - previousSent;
      previousSent = tmp;

      tmp = call NetStat.receivedMessages();
      recentlyReceived = tmp - previousReceived;
      previousReceived = tmp;

      remainingEnergy -= (recentlySent * PACKET_SEND_COST) +
                         (recentlyReceived * PACKET_RECEIVE_COST);
   }

   command uint16_t EnergyConsumed() {

      uint16_t report;
      accountForSentMessages();
      accountForReSyncOverhead();
      timeSinceLastUpdate=0;

      report = previousEnergy - remainingEnergy;
      previousEnergy = remainingEnergy;

      // smooth out the results
#if SMOOTH_ENERGY
      report = (report/2) + (previousReport/2);
      previousReport = report;
#endif
      return report;
   }

   event result_t Intercept.intercept(TOS_MsgPtr msg, void* payload, uint16_t payloadLen) {
#ifndef PLATFORM_PC
      // only fill in on originating node
      if (call MultiHopMsg.getSource(msg) == (wsnAddr) TOS_LOCAL_ADDRESS) {
         uint16_t report;
         char * buf = payload;

         report = call EnergyConsumed();

         buf[1]=(report & 0xFF);
         buf[0]=((report >> 8) & 0xFF);
      }
#endif
      return SUCCESS;
   }

}
