/*
 * Copyright (c) 2003, Vanderbilt University
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE VANDERBILT UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE VANDERBILT
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE VANDERBILT UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE VANDERBILT UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package isis.nest.messageCenter;

import java.awt.event.*;
import net.tinyos.util.*;
import isis.nest.util.*;
import net.tinyos.message.*;
/**
 *
 * @author  nadand
 */
public class SerialConnector extends javax.swing.JInternalFrame {
    
    private SerialStub serialStub;
    private int action = 0x0; // 0x0: default, 0x1: local, 0x2: server, 0x3 : illegal
    private long msgsent=0;
    private long msgreceived=0;
    private long msgadded=0;
    private long msgposted=0;
    
    private PacketReader packetReader;
    private DistributorThread distributorThread;
        
    private java.util.Vector packetBuffer = new java.util.Vector();
    
    private java.util.HashMap messageIdRegisterMap = new java.util.HashMap();
    private java.util.HashMap clientRegisterMap =  new java.util.HashMap();
    
    static private SerialConnector _instance = null;
    
    private short maxMsgLength = 36;
    private short group=0;
    
    public static final int GET_ALL_MESSAGES = -1;
    
    private static final int PACKET_ADDRESS_FIELD = 0;
    private static final int PACKET_TYPE_FIELD = 2;
    private static final int PACKET_GROUP_FIELD = 3;
    private static final int PACKET_LENGTH_FIELD = 4;
    private static final int PACKET_DATA_BEGIN = 5;
    private static final int PACKET_CRC_SIZE = 2;
    
    private java.util.prefs.Preferences prefsRoot = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
    private java.util.prefs.Preferences prefs;
    
    /** Creates new Singleton SerialConnector */
    protected SerialConnector() {
        initComponents();
        prefs = prefsRoot.node(prefsRoot.absolutePath()+"/SerialConnector");
        this.comPortTextField.setText(prefs.get("ComPort","COM1"));
        this.comSpeedTextField.setText(prefs.get("ComSpeed","57600"));
        this.sComPortTextField.setText(prefs.get("SyncedComPort","COM1"));
        this.sComPortSpeedTextField.setText(prefs.get("SyncedComSpeed","57600"));
        this.ipAddressTextField.setText(prefs.get("IpAddress","127.0.0.1"));
        this.ipPortTextField.setText(prefs.get("IpPort","9000"));
        this.lhPortTextField.setText(prefs.get("LocalPort","9000"));
        this.groupTextField.setText(prefs.get("GroupId","0x7D"));
        buttonGroup1.add(this.connectionRadioButtonCOM);
        buttonGroup1.add(this.connectionRadioButtonSCOM);
        buttonGroup1.add(this.connectionRadioButtonIP);
        buttonGroup1.add(this.connectionRadioButtonLH);
        
        setRBstate(false);
        this.buttonGroup1.setSelected(this.connectionRadioButtonCOM.getModel(),true);
    }
    /**************************Singleton Pattern "snstructor"**********************/
    static public SerialConnector instance() {
        if(null == _instance) {
            _instance = new SerialConnector();
        }
        return _instance;
    }
    
    private void setRBstate(boolean enabled){
        this.comPortTextField.setEnabled(enabled);
        this.comSpeedTextField.setEnabled(enabled);
        this.comPortLabel.setEnabled(enabled);
        this.speedLabel.setEnabled(enabled);
        this.sComPortTextField.setEnabled(enabled);
        this.sComPortSpeedTextField.setEnabled(enabled);
        this.sComPortLabel.setEnabled(enabled);
        this.sComPortSpeedLabel.setEnabled(enabled);
        this.lhPortLabel.setEnabled(enabled);
        this.lhPortTextField.setEnabled(enabled);
        this.ipLabel.setEnabled(enabled);
        this.ipAddressTextField.setEnabled(enabled);
        this.ipPortTextField.setEnabled(enabled);
        this.portLabel.setEnabled(enabled);
        
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        mainPanel = new javax.swing.JPanel();
        connectionRadioButtonCOM = new javax.swing.JRadioButton();
        comPortLabel = new javax.swing.JLabel();
        comPortTextField = new javax.swing.JTextField();
        speedLabel = new javax.swing.JLabel();
        comSpeedTextField = new javax.swing.JTextField();
        connectionRadioButtonIP = new javax.swing.JRadioButton();
        ipLabel = new javax.swing.JLabel();
        ipAddressTextField = new javax.swing.JTextField();
        portLabel = new javax.swing.JLabel();
        ipPortTextField = new javax.swing.JTextField();
        connectionRadioButtonLH = new javax.swing.JRadioButton();
        lhPortLabel = new javax.swing.JLabel();
        lhPortTextField = new javax.swing.JTextField();
        placeholderjLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        packetSizeLabel = new javax.swing.JLabel();
        packetSizeTextField = new javax.swing.JTextField();
        groupLabel = new javax.swing.JLabel();
        groupTextField = new javax.swing.JTextField();
        connectionRadioButtonSCOM = new javax.swing.JRadioButton();
        sComPortLabel = new javax.swing.JLabel();
        sComPortSpeedLabel = new javax.swing.JLabel();
        sComPortTextField = new javax.swing.JTextField();
        sComPortSpeedTextField = new javax.swing.JTextField();
        messagePanel = new javax.swing.JPanel();
        messageLabel = new javax.swing.JLabel();
        sentLabel = new javax.swing.JLabel();
        sentTextField = new javax.swing.JTextField();
        receivedLabel = new javax.swing.JLabel();
        receivedTextField = new javax.swing.JTextField();
        controlPanel = new javax.swing.JPanel();
        ssButton = new javax.swing.JButton();

        setIconifiable(true);
        setMaximizable(true);
        setResizable(true);
        setTitle("SerialConnector");
        mainPanel.setLayout(new java.awt.GridBagLayout());

        mainPanel.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        connectionRadioButtonCOM.setText("SerialPort");
        connectionRadioButtonCOM.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                connectionRadioButtonCOMItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        mainPanel.add(connectionRadioButtonCOM, gridBagConstraints);

        comPortLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        comPortLabel.setText("port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(comPortLabel, gridBagConstraints);

        comPortTextField.setText("COM1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(comPortTextField, gridBagConstraints);

        speedLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        speedLabel.setText("speed");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(speedLabel, gridBagConstraints);

        comSpeedTextField.setText("57600");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(comSpeedTextField, gridBagConstraints);

        connectionRadioButtonIP.setText("Remote Server");
        connectionRadioButtonIP.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                connectionRadioButtonIPItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(connectionRadioButtonIP, gridBagConstraints);

        ipLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        ipLabel.setText("address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(ipLabel, gridBagConstraints);

        ipAddressTextField.setText("127.0.0.1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(ipAddressTextField, gridBagConstraints);

        portLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        portLabel.setText("port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(portLabel, gridBagConstraints);

        ipPortTextField.setText("9000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(ipPortTextField, gridBagConstraints);

        connectionRadioButtonLH.setText("Localhost");
        connectionRadioButtonLH.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                connectionRadioButtonLHItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(connectionRadioButtonLH, gridBagConstraints);

        lhPortLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        lhPortLabel.setText("port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(lhPortLabel, gridBagConstraints);

        lhPortTextField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        lhPortTextField.setText("9000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(lhPortTextField, gridBagConstraints);

        placeholderjLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        mainPanel.add(placeholderjLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(jSeparator1, gridBagConstraints);

        packetSizeLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        packetSizeLabel.setText("packet size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add(packetSizeLabel, gridBagConstraints);

        packetSizeTextField.setText("36");
        packetSizeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                packetSizeTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add(packetSizeTextField, gridBagConstraints);

        groupLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        groupLabel.setText("group ID");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add(groupLabel, gridBagConstraints);

        groupTextField.setText("0x7D");
        groupTextField.setMinimumSize(new java.awt.Dimension(80, 20));
        groupTextField.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add(groupTextField, gridBagConstraints);

        connectionRadioButtonSCOM.setText("Sync'ed SerialPort");
        connectionRadioButtonSCOM.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectionRadioButtonSCOMActionPerformed(evt);
            }
        });

        connectionRadioButtonSCOM.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                connectionRadioButtonSCOMStateChanged(evt);
            }
        });

        connectionRadioButtonSCOM.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                connectionRadioButtonSCOMItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(connectionRadioButtonSCOM, gridBagConstraints);

        sComPortLabel.setText("port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(sComPortLabel, gridBagConstraints);

        sComPortSpeedLabel.setText("speed");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(sComPortSpeedLabel, gridBagConstraints);

        sComPortTextField.setText("COM1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(sComPortTextField, gridBagConstraints);

        sComPortSpeedTextField.setText("57600");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainPanel.add(sComPortSpeedTextField, gridBagConstraints);

        getContentPane().add(mainPanel, java.awt.BorderLayout.NORTH);

        messagePanel.setLayout(new java.awt.GridBagLayout());

        messagePanel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        messageLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        messageLabel.setText("message counter");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        messagePanel.add(messageLabel, gridBagConstraints);

        sentLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        sentLabel.setText("sent");
        sentLabel.setToolTipText("sent");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        messagePanel.add(sentLabel, gridBagConstraints);

        sentTextField.setBackground(new java.awt.Color(255, 255, 255));
        sentTextField.setEditable(false);
        sentTextField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        sentTextField.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        messagePanel.add(sentTextField, gridBagConstraints);

        receivedLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        receivedLabel.setText("received");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        messagePanel.add(receivedLabel, gridBagConstraints);

        receivedTextField.setBackground(new java.awt.Color(255, 255, 255));
        receivedTextField.setEditable(false);
        receivedTextField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        receivedTextField.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        messagePanel.add(receivedTextField, gridBagConstraints);

        getContentPane().add(messagePanel, java.awt.BorderLayout.CENTER);

        controlPanel.setLayout(new java.awt.GridBagLayout());

        ssButton.setText("Start Port");
        ssButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ssButtonActionPerformed(evt);
            }
        });

        controlPanel.add(ssButton, new java.awt.GridBagConstraints());

        getContentPane().add(controlPanel, java.awt.BorderLayout.WEST);

        pack();
    }//GEN-END:initComponents

    private void connectionRadioButtonSCOMItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_connectionRadioButtonSCOMItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            this.sComPortTextField.setEnabled(true);
            this.sComPortSpeedTextField.setEnabled(true);
            this.sComPortLabel.setEnabled(true);
            this.sComPortSpeedLabel.setEnabled(true);
            
        } else if(evt.getStateChange() == ItemEvent.DESELECTED) {
            this.sComPortTextField.setEnabled(false);
            this.sComPortSpeedTextField.setEnabled(false);
            this.sComPortLabel.setEnabled(false);
            this.sComPortSpeedLabel.setEnabled(false);

        }
    }//GEN-LAST:event_connectionRadioButtonSCOMItemStateChanged

    private void connectionRadioButtonSCOMStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_connectionRadioButtonSCOMStateChanged
    }//GEN-LAST:event_connectionRadioButtonSCOMStateChanged

    private void connectionRadioButtonSCOMActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connectionRadioButtonSCOMActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_connectionRadioButtonSCOMActionPerformed
    
    private void packetSizeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_packetSizeTextFieldActionPerformed
        try{
            maxMsgLength=(short)(Integer.parseInt(packetSizeTextField.getText()) & 0xff);
        }catch(Exception e){
            this.packetSizeTextField.setText(Integer.toString(maxMsgLength));
        }
        
    }//GEN-LAST:event_packetSizeTextFieldActionPerformed
    
    private void ssButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ssButtonActionPerformed
        
        if(this.ssButton.getText().equalsIgnoreCase("Start Port")){
            
            prefs.put("ComPort",this.comPortTextField.getText());
            prefs.put("ComSpeed",this.comSpeedTextField.getText());
            prefs.put("SyncedComPort",this.sComPortTextField.getText());
            prefs.put("SyncedComSpeed",this.sComPortSpeedTextField.getText());
            prefs.put("IpAddress",this.ipAddressTextField.getText());
            prefs.put("IpPort",this.ipPortTextField.getText());
            prefs.put("LocalPort",this.lhPortTextField.getText());
            prefs.put("GroupId",this.groupTextField.getText());
            
            String value = groupTextField.getText();
            if(value.trim().toUpperCase().startsWith("0X"))
                group=Short.parseShort(value.trim().substring(2),16);
            else
                group=Short.parseShort(value.trim());
            
            
            try{
                this.connectionRadioButtonCOM.setEnabled(false);
                this.connectionRadioButtonSCOM.setEnabled(false);
                this.connectionRadioButtonIP.setEnabled(false);
                this.connectionRadioButtonLH.setEnabled(false);
                
                setRBstate(false);
                
                javax.swing.ButtonModel selected = this.buttonGroup1.getSelection();
                if(this.connectionRadioButtonCOM.getModel() == selected)
                    serialStub = new SerialPortStub(this.comPortTextField.getText().trim(), maxMsgLength, Integer.parseInt(this.comSpeedTextField.getText()));
                if(this.connectionRadioButtonSCOM.getModel() == selected)
                    serialStub = new SyncedCRCSerialPortStub(this.sComPortTextField.getText().trim(), maxMsgLength, Integer.parseInt(this.sComPortSpeedTextField.getText()));
                if(this.connectionRadioButtonIP.getModel() == selected)
                    serialStub = new SerialForwarderStub(ipAddressTextField.getText(), Integer.parseInt(ipPortTextField.getText()), maxMsgLength);
                if(this.connectionRadioButtonLH.getModel() == selected)
                    serialStub = new SerialForwarderStub("", Integer.parseInt(lhPortTextField.getText()), maxMsgLength);
                
                
                
                serialStub.Open();
                distributorThread = new SerialConnector.DistributorThread();
                distributorThread.start();
                packetReader = new SerialConnector.PacketReader();
                packetReader.start();
                serialStub.registerPacketListener(packetReader);
                
                this.ssButton.setText("Stop Port");
            }catch(Exception e) {
                System.err.println("Could not connect to local port: " + e.toString());
                this.connectionRadioButtonCOM.setEnabled(true);
                this.connectionRadioButtonSCOM.setEnabled(true);
                this.connectionRadioButtonIP.setEnabled(true);
                this.connectionRadioButtonLH.setEnabled(true);
                
                javax.swing.ButtonModel selected = this.buttonGroup1.getSelection();
                if(this.connectionRadioButtonCOM.getModel() == selected){
                    this.connectionRadioButtonSCOM.doClick();
                    this.connectionRadioButtonIP.doClick() ;
                    this.connectionRadioButtonLH.doClick() ;
                    this.connectionRadioButtonCOM.doClick();
                }
                if(this.connectionRadioButtonSCOM.getModel() == selected){
                    this.connectionRadioButtonCOM.doClick();
                    this.connectionRadioButtonLH.doClick() ;
                    this.connectionRadioButtonIP.doClick() ;
                    this.connectionRadioButtonSCOM.doClick();
                }
                if(this.connectionRadioButtonIP.getModel() == selected){
                    this.connectionRadioButtonCOM.doClick();
                    this.connectionRadioButtonSCOM.doClick();
                    this.connectionRadioButtonLH.doClick() ;
                    this.connectionRadioButtonIP.doClick() ;
                }
                if(this.connectionRadioButtonLH.getModel() == selected){
                    this.connectionRadioButtonCOM.doClick();
                    this.connectionRadioButtonSCOM.doClick();
                    this.connectionRadioButtonIP.doClick() ;
                    this.connectionRadioButtonLH.doClick() ;
                }
                this.ssButton.setText("Start Port");
                
            }
            
        }else if(this.ssButton.getText().equalsIgnoreCase("Stop Port")){
            try{
                this.connectionRadioButtonCOM.setEnabled(true);
                this.connectionRadioButtonSCOM.setEnabled(true);
                this.connectionRadioButtonIP.setEnabled(true);
                this.connectionRadioButtonLH.setEnabled(true);
                
                javax.swing.ButtonModel selected = this.buttonGroup1.getSelection();
                if(this.connectionRadioButtonCOM.getModel() == selected){
                    this.connectionRadioButtonSCOM.doClick();
                    this.connectionRadioButtonLH.doClick() ;
                    this.connectionRadioButtonCOM.doClick();
                }
                if(this.connectionRadioButtonSCOM.getModel() == selected){
                    this.connectionRadioButtonCOM.doClick();
                    this.connectionRadioButtonLH.doClick() ;
                    this.connectionRadioButtonSCOM.doClick();
                }
                if(this.connectionRadioButtonIP.getModel() == selected){
                    this.connectionRadioButtonCOM.doClick();
                    this.connectionRadioButtonSCOM.doClick();
                    this.connectionRadioButtonIP.doClick() ;
                }
                if(this.connectionRadioButtonLH.getModel() == selected){
                    this.connectionRadioButtonIP.doClick() ;
                    this.connectionRadioButtonLH.doClick() ;
                }
                
                packetReader.stopRun();
                distributorThread.end();
                serialStub.Close();
                
                
                this.ssButton.setText("Start Port");
                
            }catch(Exception e) {
                System.err.println("Could not terminate connection to local port: " + e.toString());
            }
            
        }
    }//GEN-LAST:event_ssButtonActionPerformed
    
    private void connectionRadioButtonLHItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_connectionRadioButtonLHItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            this.lhPortLabel.setEnabled(true);
            this.lhPortTextField.setEnabled(true);
        } else if(evt.getStateChange() == ItemEvent.DESELECTED) {
            this.lhPortLabel.setEnabled(false);
            this.lhPortTextField.setEnabled(false);
        }
    }//GEN-LAST:event_connectionRadioButtonLHItemStateChanged
    
    private void connectionRadioButtonIPItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_connectionRadioButtonIPItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            this.ipLabel.setEnabled(true);
            this.ipAddressTextField.setEnabled(true);
            this.ipPortTextField.setEnabled(true);
            this.portLabel.setEnabled(true);
            
        } else if(evt.getStateChange() == ItemEvent.DESELECTED) {
            this.ipLabel.setEnabled(false);
            this.ipAddressTextField.setEnabled(false);
            this.ipPortTextField.setEnabled(false);
            this.portLabel.setEnabled(false);
        }
    }//GEN-LAST:event_connectionRadioButtonIPItemStateChanged
    
    private void connectionRadioButtonCOMItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_connectionRadioButtonCOMItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            this.comPortTextField.setEnabled(true);
            this.comSpeedTextField.setEnabled(true);
            this.comPortLabel.setEnabled(true);
            this.speedLabel.setEnabled(true);
            
        } else if(evt.getStateChange() == ItemEvent.DESELECTED) {
            this.comPortTextField.setEnabled(false);
            this.comSpeedTextField.setEnabled(false);
            this.comPortLabel.setEnabled(false);
            this.speedLabel.setEnabled(false);
            
            
        }
    }//GEN-LAST:event_connectionRadioButtonCOMItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel sComPortSpeedLabel;
    private javax.swing.JLabel speedLabel;
    private javax.swing.JButton ssButton;
    private javax.swing.JLabel lhPortLabel;
    private javax.swing.JPanel controlPanel;
    private javax.swing.JLabel placeholderjLabel;
    private javax.swing.JRadioButton connectionRadioButtonLH;
    private javax.swing.JTextField comPortTextField;
    private javax.swing.JLabel ipLabel;
    private javax.swing.JRadioButton connectionRadioButtonCOM;
    private javax.swing.JLabel sComPortLabel;
    private javax.swing.JRadioButton connectionRadioButtonSCOM;
    private javax.swing.JRadioButton connectionRadioButtonIP;
    private javax.swing.JLabel sentLabel;
    private javax.swing.JTextField comSpeedTextField;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JTextField sComPortTextField;
    private javax.swing.JTextField receivedTextField;
    private javax.swing.JTextField lhPortTextField;
    private javax.swing.JTextField packetSizeTextField;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTextField groupTextField;
    private javax.swing.JLabel packetSizeLabel;
    private javax.swing.JLabel receivedLabel;
    private javax.swing.JPanel messagePanel;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JLabel portLabel;
    private javax.swing.JTextField ipAddressTextField;
    private javax.swing.JTextField sentTextField;
    private javax.swing.JLabel comPortLabel;
    private javax.swing.JTextField ipPortTextField;
    private javax.swing.JTextField sComPortSpeedTextField;
    private javax.swing.JLabel groupLabel;
    // End of variables declaration//GEN-END:variables
    
    /*********************************Message sendIF******************************/
    
    public void registerPacketListener(PacketListenerIF packetListener, int messageID){
        java.util.HashSet listenerList;
        if(messageIdRegisterMap.containsKey(new Integer(messageID))) {
            listenerList = (java.util.HashSet) this.messageIdRegisterMap.get(new Integer(messageID));
        }else {
            listenerList = new java.util.HashSet();
            this.messageIdRegisterMap.put(new Integer(messageID),listenerList);
        }
        if(clientRegisterMap.containsKey(packetListener)){
            
            ClientThread clientHandler = (ClientThread)clientRegisterMap.get(packetListener);
            clientHandler.references++;
        }else{
            ClientThread newClientHandler = new ClientThread(packetListener);
            clientRegisterMap.put(packetListener,newClientHandler);
            newClientHandler.references++;
            newClientHandler.start();
        }
        
        listenerList.add(packetListener);
        
    }
    
    public boolean removePacketListener(PacketListenerIF packetListener, int messageID){
        java.util.HashSet listenerList;
        if(messageIdRegisterMap.containsKey(new Integer(messageID))) {
            listenerList = (java.util.HashSet) this.messageIdRegisterMap.get(new Integer(messageID));
        }else {
            return false;
        }
        if(clientRegisterMap.containsKey(packetListener)){
            ClientThread clientHandler = (ClientThread)clientRegisterMap.get(packetListener);
            if(--clientHandler.references==0){
                clientHandler.end();
                clientRegisterMap.remove(packetListener);
            }
        }
        
        if(listenerList.remove(packetListener)){
            if(listenerList.isEmpty())
                messageIdRegisterMap.remove(new Integer(messageID));
            return true;
        }
        return false;
    }

    public boolean removePacketListener(MessageCenterInternalFrame packetListener){
        java.util.HashSet listenerList;
        java.util.Iterator mapIt = messageIdRegisterMap.keySet().iterator();
        while(mapIt.hasNext()){
            Object key = mapIt.next();
            if(messageIdRegisterMap.containsKey(key)) {
                listenerList = (java.util.HashSet) this.messageIdRegisterMap.get(key);
            }else {
                continue;
            }
            if(clientRegisterMap.containsKey(packetListener)){
                ClientThread clientHandler = (ClientThread)clientRegisterMap.get(packetListener);
                if(--clientHandler.references==0){
                    clientHandler.end();
                    clientRegisterMap.remove(packetListener);
                }
            }

            if(listenerList.remove(packetListener)){
                if(listenerList.isEmpty())
                    messageIdRegisterMap.remove(key);
                
            }
            
        }
        return true;
    }

    
    
    public boolean sendMessage(int address, short type, short dgroup /*deprecated*/, byte[] data){
        if(data.length > Integer.parseInt(packetSizeTextField.getText()))
            return false;
        
        
        sentTextField.setText(Long.toString(++msgsent));
        TOSMsg tosPacket = new TOSMsg(36);
        //address
        tosPacket.set_addr(address);
        //System.out.println("address "+messageAdress);
        //type
        tosPacket.set_type(type);
        //System.out.println("type "+pollActiveMessage);
        //Group
        tosPacket.set_group(this.group);
        //System.out.println("group "+groupId);
        //Length
        tosPacket.set_length((short)data.length);
        //System.out.println("length "+(short)data.length);
        //data
        tosPacket.dataSet(data, 0, tosPacket.offset_data(0), data.length);
        //CRC
        tosPacket.set_crc(1);
        
        
        try{
            if(serialStub != null){
                serialStub.Write(tosPacket.dataGet());
                
            }
            return true;
        }catch(java.io.IOException ioe){
            
        }
        return false;
        
    }
    
    /******************************Inner Classes***********************************/
    protected class DistributorThread extends Thread{
        
        byte[] packet;
        
        PacketListenerIF destination;
        boolean running = true;
        
        public void end(){
            running = false;
        }
        
        public void run(){
            
            while(running){
                if(!packetBuffer.isEmpty()){
                    distributeBuffer();
                }else{
                    try{
                        //System.out.println("Sleeping");
                        this.sleep(100);
                    }catch(InterruptedException ie ){                    }
                }
            }
        }
        
        private synchronized void distributeBuffer(){
            while(!packetBuffer.isEmpty()){
                //System.out.println("Buffer Size: " + packetBuffer.size());
                packet =(byte[])packetBuffer.get(0);
                packetBuffer.remove(0);
                
                java.util.HashSet toNotify = new java.util.HashSet();
                
                
                if(messageIdRegisterMap.containsKey(new Integer(GET_ALL_MESSAGES))) {
                    toNotify.addAll((java.util.HashSet)messageIdRegisterMap.get(new Integer(GET_ALL_MESSAGES)));
                }
                if(messageIdRegisterMap.containsKey(new Integer(packet[PACKET_TYPE_FIELD]))) {
                    toNotify.addAll((java.util.HashSet)messageIdRegisterMap.get(new Integer(packet[PACKET_TYPE_FIELD])));
                }
                
                java.util.Iterator notifyListIterator = toNotify.iterator();
                
                while(notifyListIterator.hasNext()){
                    
                    PacketListenerIF packetIF =(PacketListenerIF)notifyListIterator.next();
                    if(clientRegisterMap.containsKey(packetIF)){
                        ClientThread clientHandler = (ClientThread)clientRegisterMap.get(packetIF);
                        clientHandler.forwardPacketReceived(packet,packetIF);
                        msgadded++;
                    }
                }
            }
        }
        
    }
    
    protected class ClientThread extends Thread{
        
        //byte[] packet;
        private java.util.Vector messageBuffer;
        PacketListenerIF destination;
        boolean running = true;
        public int references = 0;
        
        /*public ClientThread(){
        }*/
        
        public ClientThread(PacketListenerIF destination){
            this.destination = destination;
            messageBuffer = new java.util.Vector();
        }

        public synchronized void  forwardPacketReceived(byte[] packet, PacketListenerIF destination) {
            messageBuffer.add(packet);
            //this.packet = packet;
            //this.destination = destination;

        }
        
        public void end(){
            running = false;
        }
        
        public void run(){
            while(running)
                if(!messageBuffer.isEmpty()){
                    sendBuffer();
                }else{
                    try{
                        this.sleep(100);
                    }catch(InterruptedException ie ){}
                }
        }
        
        private synchronized void sendBuffer(){
            while(!this.messageBuffer.isEmpty()){
                this.destination.packetReceived((byte[])this.messageBuffer.get(0));
                this.messageBuffer.remove(0);
                msgposted++;
                //System.out.println("recvd:"+msgreceived+" added:"+msgadded+"posted:"+msgposted);
            }
        }
        
    }
    
    protected class PacketReader extends Thread implements PacketListenerIF{
        boolean run = true;
        public void run(){
            try{
                while(run){
                    serialStub.Read();
                }
            }catch(Exception e){
            }
        }
        
        public void stopRun(){
            run = false;
        }
        
        // the first 5 bytes are: addr(2), type(1), group(1), length(1)
        public void packetReceived(byte[] packet) {
            //packetBuffer.add(packet);
            receivedTextField.setText(Long.toString(++msgreceived));
            //System.out.println("Type: " +Integer.toHexString(0xFF & packet[2]));
            
            java.util.HashSet toNotify = new java.util.HashSet();
            
            if(messageIdRegisterMap.containsKey(new Integer(GET_ALL_MESSAGES))) {
                toNotify.addAll((java.util.HashSet)messageIdRegisterMap.get(new Integer(GET_ALL_MESSAGES)));
            }
            if(messageIdRegisterMap.containsKey(new Integer(packet[PACKET_TYPE_FIELD]))) {
                toNotify.addAll((java.util.HashSet)messageIdRegisterMap.get(new Integer(packet[PACKET_TYPE_FIELD])));
            }
            java.util.Iterator notifyListIterator = toNotify.iterator();
            while(notifyListIterator.hasNext()){
                ((PacketListenerIF)notifyListIterator.next()).packetReceived(packet);
                /*PacketListenerIF packetIF =(PacketListenerIF)notifyListIterator.next();
                if(clientRegisterMap.containsKey(packetIF)){
                    ClientThread clientHandler = (ClientThread)clientRegisterMap.get(packetIF);
                    clientHandler.forwardPacketReceived(packet,packetIF);
                    msgadded++;
                }*/
             
             
             
             
            }
            
        }
        
    }
    
}
