// *** WARNING ****** WARNING ****** WARNING ****** WARNING ****** WARNING ***
// ***                                                                     ***
// *** This file was automatically generated by create_NeighborExt.pl.     ***
// *** Any and all changes made to this file WILL BE LOST!                 ***
// ***                                                                     ***
// *** WARNING ****** WARNING ****** WARNING ****** WARNING ****** WARNING ***

includes cqueue;
includes SchemaType;
includes Command;
includes NestArch;

module TuplePublisherM
{
  provides
  {
    interface TuplePublisher;
    interface StdControl;

    interface Neighbor_location;
    interface Neighbor_ucb_location_nak;
    interface Neighbor_anchorCorrections;
    interface Neighbor_anchors;
    interface Neighbor_sounderCoefficients;
    interface Neighbor_distanceBuffer;
    interface Neighbor_rangingData;
    interface Neighbor_micCoefficients;  }
  uses
  {
    interface Leds;
    interface TupleStore;
    interface TupleManager;
    interface RoutingSendByBroadcast;
    interface RoutingSendByBroadcast as CommandBroadcast;
    interface RoutingReceive;
    interface StdControl as CommandControl;
    interface CommandRegister as Publish;
    interface Random;
    interface Timer;
  }
}
implementation
{
  TOS_Msg m_msg;
  bool m_is_sending;
  uint8_t m_tupleTypeToBePublished;



  enum {
    MAX_QUEUE_SIZE = 12,
  };

  TupleMsgHeader_t m_queue[ MAX_QUEUE_SIZE ];
  cqueue_t m_cq;

  command result_t StdControl.init()
  {
    ParamList paramList;
    m_is_sending = FALSE;
    init_cqueue( &m_cq, MAX_QUEUE_SIZE );
    call CommandControl.init();
    paramList.numParams=1;
    paramList.params[0]=INT8;
    if (call Publish.registerCommand("Publish", VOID, 0, &paramList) != SUCCESS)
			return FAIL;
    return SUCCESS;
  }

  command result_t StdControl.start()
  {
    call CommandControl.start();
    return SUCCESS;
  }

  command result_t StdControl.stop()
  { 
   call CommandControl.stop();
   return SUCCESS;
  }

  event result_t Publish.commandFunc(char *commandName, char *resultBuf, SchemaErrorNo *errorNo, ParamVals *params)
	{
	    	                	    uint32_t randomDelay;
	    m_tupleTypeToBePublished = *(uint8_t*)params->paramDataPtr[0];
	    randomDelay = call Random.rand() & 0x0fff;             call Timer.start(TIMER_ONE_SHOT, randomDelay);
	    return SUCCESS;
	}

  event result_t Timer.fired() 
  {
	call TuplePublisher.publish(m_tupleTypeToBePublished, TOS_LOCAL_ADDRESS);
	return SUCCESS;
  }

  task void do_publish();

  result_t requestRemoteTuples(uint8_t tupleType)
  {
    if( push_back_cqueue(&m_cq) == SUCCESS )
    {
      m_queue[ m_cq.back ].address   = 0;
      m_queue[ m_cq.back ].tupletype = tupleType;
      post do_publish();
      return SUCCESS;
    }
    return FAIL;
  }
      
  result_t createRemoteTupleRequest(uint8_t tupleType)
  {
    struct CommandMsg* cmdHeaders;
    char* cmdName;
    uint8_t* param;

       if( (cmdHeaders = (struct CommandMsg*)initRoutingMsg( &m_msg, sizeof(struct CommandMsg) )) == 0 )
         return FAIL;
   if( (cmdName = (char*)pushToRoutingMsg( &m_msg, sizeof("Publish") )) == 0 )
      return FAIL;
   if( (param = (uint8_t*)pushToRoutingMsg( &m_msg, sizeof(uint8_t) )) == 0 )
      return FAIL;

      cmdHeaders->nodeid = TOS_BCAST_ADDR;
   cmdHeaders->fromBase = 0;
   strcpy(cmdName, "Publish");
   *param = tupleType;
   return SUCCESS;
  }
      


  command void Neighbor_location.set( uint16_t address, location_t* location )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->location = *location;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->location = *location;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 2, address );
  }

  command void Neighbor_location.requestRemoteTuples()
  {
      requestRemoteTuples( 2);
  }

  command void Neighbor_location.publish()
  {
    call TuplePublisher.publish( 2, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_location.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_location.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_location.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_location.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_ucb_location_nak.set( uint16_t address, bool* ucb_location_nak )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->ucb_location_nak = *ucb_location_nak;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->ucb_location_nak = *ucb_location_nak;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 3, address );
  }

  command void Neighbor_ucb_location_nak.requestRemoteTuples()
  {
      requestRemoteTuples( 3);
  }

  command void Neighbor_ucb_location_nak.publish()
  {
    call TuplePublisher.publish( 3, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_ucb_location_nak.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_ucb_location_nak.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_ucb_location_nak.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_ucb_location_nak.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_anchorCorrections.set( uint16_t address, anchorCorrectionArray_t* anchorCorrections )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->anchorCorrections = *anchorCorrections;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->anchorCorrections = *anchorCorrections;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 4, address );
  }

  command void Neighbor_anchorCorrections.requestRemoteTuples()
  {
      requestRemoteTuples( 4);
  }

  command void Neighbor_anchorCorrections.publish()
  {
    call TuplePublisher.publish( 4, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_anchorCorrections.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_anchorCorrections.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_anchorCorrections.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_anchorCorrections.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_anchors.set( uint16_t address, anchorArray_t* anchors )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->anchors = *anchors;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->anchors = *anchors;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 5, address );
  }

  command void Neighbor_anchors.setElement( uint16_t address, anchor_t* anchor, uint8_t elementIndex )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->anchors.data[elementIndex] = *anchor;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->anchors.data[elementIndex] = *anchor;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publishElement( 5, address, elementIndex );
  }

  command void Neighbor_anchors.requestRemoteTuples()
  {
      requestRemoteTuples( 5);
  }

  command void Neighbor_anchors.publish()
  {
	uint8_t elementIndex;
	for(elementIndex=0; elementIndex<3; elementIndex++) //this should be changed to use array size, which is passed to //!! as a parameter
	    call TuplePublisher.publishElement( 5, TOS_LOCAL_ADDRESS, elementIndex );
  }

  command void Neighbor_anchors.publishElement(uint8_t elementIndex)
  {
    call TuplePublisher.publishElement( 5, TOS_LOCAL_ADDRESS, elementIndex );
  }


  default event void Neighbor_anchors.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_anchors.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_anchors.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_anchors.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_sounderCoefficients.set( uint16_t address, D2Polynomial_t* sounderCoefficients )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->sounderCoefficients = *sounderCoefficients;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->sounderCoefficients = *sounderCoefficients;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 18, address );
  }

  command void Neighbor_sounderCoefficients.requestRemoteTuples()
  {
      requestRemoteTuples( 18);
  }

  command void Neighbor_sounderCoefficients.publish()
  {
    call TuplePublisher.publish( 18, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_sounderCoefficients.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_sounderCoefficients.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_sounderCoefficients.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_sounderCoefficients.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_distanceBuffer.set( uint16_t address, DistanceBuffer_t* distanceBuffer )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->distanceBuffer = *distanceBuffer;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->distanceBuffer = *distanceBuffer;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 19, address );
  }

  command void Neighbor_distanceBuffer.requestRemoteTuples()
  {
      requestRemoteTuples( 19);
  }

  command void Neighbor_distanceBuffer.publish()
  {
    call TuplePublisher.publish( 19, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_distanceBuffer.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_distanceBuffer.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_distanceBuffer.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_distanceBuffer.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_rangingData.set( uint16_t address, RangingData_t* rangingData )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->rangingData = *rangingData;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->rangingData = *rangingData;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 20, address );
  }

  command void Neighbor_rangingData.requestRemoteTuples()
  {
      requestRemoteTuples( 20);
  }

  command void Neighbor_rangingData.publish()
  {
    call TuplePublisher.publish( 20, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_rangingData.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_rangingData.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_rangingData.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_rangingData.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }

  command void Neighbor_micCoefficients.set( uint16_t address, D2Polynomial_t* micCoefficients )
  {
    Neighbor_t* nn = call TupleStore.privateGetByAddress( address );

    if( nn != 0 )
    {
      nn->micCoefficients = *micCoefficients;
    }
    else
    {
      nn = call TupleManager.getByAddress( address );
      nn->micCoefficients = *micCoefficients;
      call TupleManager.setTuple( nn );
    }

    call TuplePublisher.publish( 21, address );
  }

  command void Neighbor_micCoefficients.requestRemoteTuples()
  {
      requestRemoteTuples( 21);
  }

  command void Neighbor_micCoefficients.publish()
  {
    call TuplePublisher.publish( 21, TOS_LOCAL_ADDRESS );
  }


  default event void Neighbor_micCoefficients.updatedFromRemote( uint16_t address )
  {
  }

  command NeighborPtr_t Neighbor_micCoefficients.getByAddress(uint16_t address)
  {
      return call TupleStore.getByAddress(address);
  }

  command TupleIterator_t Neighbor_micCoefficients.initIterator()
  {
      return call TupleStore.initIterator();
  }

  command bool Neighbor_micCoefficients.getNext(TupleIterator_t* iterator)
  {
      return call TupleStore.getNext(iterator);
  }


  command void TuplePublisher.publish( uint8_t tupletype, uint16_t address )
  {
    if( address != TOS_LOCAL_ADDRESS )
      return;

    if( push_back_cqueue(&m_cq) == SUCCESS )
    {
      m_queue[ m_cq.back ].address   = address;
      m_queue[ m_cq.back ].tupletype = tupletype;
      post do_publish();
    }
  }

  command void TuplePublisher.publishElement( uint8_t tupletype, uint16_t address, uint8_t elementIndex )
  {
    if( address != TOS_LOCAL_ADDRESS )
      return;

    if( push_back_cqueue(&m_cq) == SUCCESS )
    {
      m_queue[ m_cq.back ].address   = address;
      m_queue[ m_cq.back ].tupletype = tupletype;
      m_queue[ m_cq.back ].elementIndex = elementIndex;
      post do_publish();
    }
  }

  task void post_do_publish()
  {
    post do_publish();
  }

  task void do_publish()
  {
    TupleMsgHeader_t* head;
    void* msgdata;
    TupleMsgHeader_t headdata;
    const Neighbor_t* nn;

        if( (m_is_sending == TRUE) || (is_empty_cqueue( &m_cq ) == TRUE) )
      return;

        headdata = m_queue[ m_cq.front ];
    pop_front_cqueue( &m_cq );

        if( headdata.address == 0 )
    {
       if( createRemoteTupleRequest(headdata.tupletype) == FAIL)
          return;
                    if( call CommandBroadcast.send( 0, &m_msg ) == SUCCESS )
      {
         m_is_sending = TRUE;
       }
       else
       {
         if( push_front_cqueue( &m_cq ) == TRUE ) 
         m_queue[ m_cq.front ] = headdata;
         post post_do_publish();
       }
    }
    else
    {

              if( (nn = call TupleStore.getByAddress(headdata.address)) == 0 )
        return;
 
              switch( headdata.tupletype )
       {
      case 2: // location
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(location_t) )) == 0 )
	  return;
	*(location_t*)msgdata = nn->location;
	break;

      case 3: // ucb_location_nak
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(bool) )) == 0 )
	  return;
	*(bool*)msgdata = nn->ucb_location_nak;
	break;

      case 4: // anchorCorrections
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(anchorCorrectionArray_t) )) == 0 )
	  return;
	*(anchorCorrectionArray_t*)msgdata = nn->anchorCorrections;
	break;

      case 5: // anchors
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(anchorArray_t) )) == 0 )
	  return;
	*(anchor_t*)msgdata = nn->anchors.data[headdata.elementIndex];
	break;

      case 18: // sounderCoefficients
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(D2Polynomial_t) )) == 0 )
	  return;
	*(D2Polynomial_t*)msgdata = nn->sounderCoefficients;
	break;

      case 19: // distanceBuffer
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(DistanceBuffer_t) )) == 0 )
	  return;
	*(DistanceBuffer_t*)msgdata = nn->distanceBuffer;
	break;

      case 20: // rangingData
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(RangingData_t) )) == 0 )
	  return;
	*(RangingData_t*)msgdata = nn->rangingData;
	break;

      case 21: // micCoefficients
        if( (msgdata = initRoutingMsg( &m_msg, sizeof(D2Polynomial_t) )) == 0 )
	  return;
	*(D2Polynomial_t*)msgdata = nn->micCoefficients;
	break;

         default:
     	   return;
       }

                     if( (head = (TupleMsgHeader_t*)pushToRoutingMsg( &m_msg, sizeof(TupleMsgHeader_t) )) == 0 )
         return;

              *head = headdata;


                     if( call RoutingSendByBroadcast.send( 0, &m_msg ) == SUCCESS )
       {
         m_is_sending = TRUE;
       }
       else
       {
         if( push_front_cqueue( &m_cq ) == TRUE )
	   m_queue[ m_cq.front ] = headdata;
         post post_do_publish();
       }
    }
  }

  event result_t RoutingSendByBroadcast.sendDone( TOS_MsgPtr msg, result_t success )
  {
    if( msg == &m_msg )
      m_is_sending = FALSE;
    post do_publish();
    return SUCCESS;
  }

  event result_t CommandBroadcast.sendDone( TOS_MsgPtr msg, result_t success )
  {
    if( msg == &m_msg )
      m_is_sending = FALSE;
    return SUCCESS;
  }

  event TOS_MsgPtr RoutingReceive.receive( TOS_MsgPtr msg )
  {
    TupleMsgHeader_t* head;
    void* msgdata;

    
    if( (head = (TupleMsgHeader_t*)popFromRoutingMsg( msg, sizeof(TupleMsgHeader_t) )) == 0 )
      return msg;

    switch( head->tupletype )
    {
      case 2: // location
        if( (msgdata = popFromRoutingMsg( msg, sizeof(location_t) )) == 0 )
	  return msg;
	call Neighbor_location.set( head->address, (location_t*)msgdata );
	signal Neighbor_location.updatedFromRemote( head->address );
	break;

      case 3: // ucb_location_nak
        if( (msgdata = popFromRoutingMsg( msg, sizeof(bool) )) == 0 )
	  return msg;
	call Neighbor_ucb_location_nak.set( head->address, (bool*)msgdata );
	signal Neighbor_ucb_location_nak.updatedFromRemote( head->address );
	break;

      case 4: // anchorCorrections
        if( (msgdata = popFromRoutingMsg( msg, sizeof(anchorCorrectionArray_t) )) == 0 )
	  return msg;
	call Neighbor_anchorCorrections.set( head->address, (anchorCorrectionArray_t*)msgdata );
	signal Neighbor_anchorCorrections.updatedFromRemote( head->address );
	break;

      case 5: // anchors
        if( (msgdata = popFromRoutingMsg( msg, sizeof(anchorArray_t) )) == 0 )
	  return msg;
	call Neighbor_anchors.setElement( head->address, (anchor_t*)msgdata, head->elementIndex );
	signal Neighbor_anchors.updatedFromRemote( head->address );
	break;

      case 18: // sounderCoefficients
        if( (msgdata = popFromRoutingMsg( msg, sizeof(D2Polynomial_t) )) == 0 )
	  return msg;
	call Neighbor_sounderCoefficients.set( head->address, (D2Polynomial_t*)msgdata );
	signal Neighbor_sounderCoefficients.updatedFromRemote( head->address );
	break;

      case 19: // distanceBuffer
        if( (msgdata = popFromRoutingMsg( msg, sizeof(DistanceBuffer_t) )) == 0 )
	  return msg;
	call Neighbor_distanceBuffer.set( head->address, (DistanceBuffer_t*)msgdata );
	signal Neighbor_distanceBuffer.updatedFromRemote( head->address );
	break;

      case 20: // rangingData
        if( (msgdata = popFromRoutingMsg( msg, sizeof(RangingData_t) )) == 0 )
	  return msg;
	call Neighbor_rangingData.set( head->address, (RangingData_t*)msgdata );
	signal Neighbor_rangingData.updatedFromRemote( head->address );
	break;

      case 21: // micCoefficients
        if( (msgdata = popFromRoutingMsg( msg, sizeof(D2Polynomial_t) )) == 0 )
	  return msg;
	call Neighbor_micCoefficients.set( head->address, (D2Polynomial_t*)msgdata );
	signal Neighbor_micCoefficients.updatedFromRemote( head->address );
	break;

      default:
	return msg;
    }

    
    return msg;
  }
}


