/*
 * Copyright (c) 2003, Vanderbilt University
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE VANDERBILT UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE VANDERBILT
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE VANDERBILT UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE VANDERBILT UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package isis.nest.messageCenter;

/**
 *
 * @author  nadand
 */
public class CenterFrame extends javax.swing.JFrame {
    
    
    static private java.util.Hashtable childWindowList = new java.util.Hashtable();
    
    static private CenterFrame _instance = null;
    
    private FrameMenuItem serialConnectorMenuItem;
    
    /** Creates new form centerFrame */
    private CenterFrame() {
        _instance = this;
        initComponents();
        desktopPane.add(SerialConnector.instance());
        SerialConnector.instance().setVisible(true);
        serialConnectorMenuItem = new CenterFrame.FrameMenuItem(SerialConnector.instance());
        windowMenu.add(serialConnectorMenuItem);
        childWindowList.put(SerialConnector.instance(),serialConnectorMenuItem);
        
        new AppLoader();
        //registerChildFrame(new AllMSGDisplay());
        //registerChildFrame(new AppLoader());
    }
    
    /**************************Singleton Pattern "snstructor"**********************/
    static public CenterFrame instance() {
        if(null == _instance) {
            _instance = new CenterFrame();
        }
        return _instance;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        desktopPane = new javax.swing.JDesktopPane();
        centerMenuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        saveMenuItem = new javax.swing.JMenuItem();
        windowMenu = new javax.swing.JMenu();

        setTitle("messageCenter");
        setName("centerFrame");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        getContentPane().add(desktopPane, java.awt.BorderLayout.CENTER);

        fileMenu.setText("File");
        saveMenuItem.setText("Save..");
        saveMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(saveMenuItem);
        centerMenuBar.add(fileMenu);
        windowMenu.setText("Window");
        windowMenu.addMenuListener(new javax.swing.event.MenuListener() {
            public void menuSelected(javax.swing.event.MenuEvent evt) {
                windowMenuMenuSelected(evt);
            }
            public void menuDeselected(javax.swing.event.MenuEvent evt) {
            }
            public void menuCanceled(javax.swing.event.MenuEvent evt) {
            }
        });

        centerMenuBar.add(windowMenu);
        setJMenuBar(centerMenuBar);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(800, 600));
        setLocation((screenSize.width-800)/2,(screenSize.height-600)/2);
    }//GEN-END:initComponents

	private void windowMenuMenuSelected(javax.swing.event.MenuEvent evt) {//GEN-FIRST:event_windowMenuMenuSelected
		java.util.Enumeration internalFrames = childWindowList.keys();
		while (internalFrames.hasMoreElements()){
			javax.swing.JInternalFrame internalFrame = (javax.swing.JInternalFrame)internalFrames.nextElement();
			FrameMenuItem menuItem = (FrameMenuItem)childWindowList.get(internalFrame);
			menuItem.setText(internalFrame.getTitle());
		}
	}//GEN-LAST:event_windowMenuMenuSelected
    
    private void saveMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveMenuItemActionPerformed
        javax.swing.JFileChooser chooser = new javax.swing.JFileChooser();
        chooser.setDialogTitle("Just a Test dialog");
        int returnVal = chooser.showSaveDialog(this);
        if(returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
            System.out.println("You chose to open this file: " +
            chooser.getSelectedFile().getName());
        }
        
    }//GEN-LAST:event_saveMenuItemActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new CenterFrame().show();
        //new AllMSGDisplay();
        
    }
    
    protected isis.nest.messageCenter.SerialConnector serialConnector;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar centerMenuBar;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JDesktopPane desktopPane;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JMenu windowMenu;
    // End of variables declaration//GEN-END:variables
    
    /*****************************Add Child Window IF *************************/
    
    public void registerChildFrame(javax.swing.JInternalFrame newChildFrame){
        FrameMenuItem menuItem = new FrameMenuItem(newChildFrame);
        childWindowList.put(newChildFrame,menuItem);
        this.windowMenu.add(menuItem);
        desktopPane.add(newChildFrame);
        newChildFrame.setVisible(true);
        
        
    }
    
    public void removeChildFrame(javax.swing.JInternalFrame oldChildFrame){
        oldChildFrame.setVisible(false);
        this.windowMenu.remove((FrameMenuItem)childWindowList.get(oldChildFrame));
        desktopPane.remove(oldChildFrame);
        
        
    }
    
    /********************************* Inner Classes **************************/
    
    private class FrameMenuItem extends javax.swing.JMenuItem{
        
        public javax.swing.JInternalFrame childFrame;
        
        public FrameMenuItem(javax.swing.JInternalFrame newChildFrame){
            super(newChildFrame.getTitle());
            this.childFrame = newChildFrame;
            
            this.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    try{
                        childFrame.setSelected(true);
                        childFrame.moveToFront();
                        if(childFrame.isIcon())
                            childFrame.setIcon(false);
                    }catch(java.beans.PropertyVetoException pve){}
                }
            });
        }
    }
    
    
}
