/*									tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *  install, copy or use the software.
 *
 *  Intel Open Source License 
 *
 *  Copyright (c) 2002 Intel Corporation 
 *  All rights reserved. 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 * 
 *	Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *      Neither the name of the Intel Corporation nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE INTEL OR ITS
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * 
 */
/* 
 * Authors:  Wei Hong
 *           Intel Research Berkeley Lab
 * Date:     6/27/2002
 *
 */

// Header files for attributes -- See AttrUse.ti and AttrRegister.ti

// XXX nested .th files are not supported yet
// includes SchemaType;

#define NUM_SYSTEM_ATTRS	13
#ifdef BOARD_MICASB
#define	NUM_SENSOR_ATTRS	10
#else
#ifdef BOARD_MICAWB
#define NUM_SENSOR_ATTRS	6
#endif
#endif

enum {
	MAX_ATTRS = NUM_SYSTEM_ATTRS 
//may not always be defined
#ifdef NUM_SENSOR_ATTRS
	   + NUM_SENSOR_ATTRS
#endif
,
	MAX_ATTR_NAME_LEN = 8,
	MAX_CONST_LEN = 4,
	MAX_CONST_ATTRS = 1
};

// will add support for other languages later
typedef struct {
	TOSType type;	
	uint8_t nbytes;
    uint8_t idx; //index into AttrDesc array
	uint8_t id; // id for AttrRegister interface dispatch
	int8_t constIdx;  // index for constant values
	char name[MAX_ATTR_NAME_LEN + 1];
} AttrDesc;

typedef AttrDesc *AttrDescPtr;

typedef struct {
  uint8_t numAttrs;
  AttrDesc attrDesc[MAX_ATTRS];
} AttrDescs;

typedef AttrDescs *AttrDescsPtr;
