/* uartDebugParser.c
 *
 * This program parses an log file generated by uartDebugServer.c
 * The same table of states and events that used by uartDebugServer should be
 * used here too. If no state-event table is included, will simply display 
 * the raw bytes provided by each node.
 *
 * Author: Wei Ye (USC/ISI)
 * Date: 03/10/2003
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>

// if debug another component, comment out following line
// or include a corresponding debug table, which should be the same
// as in uartDebugServer.c
#include "smacDebugTab.h"

#define MAXBUFLEN 80

int main(int argc, char ** argv)
{
   unsigned int numbytes, i, msgNo;
   char buf[MAXBUFLEN];
   unsigned int nodeId, days, hours, minutes, seconds, milisec;
   FILE *logFile;
   char timeStamp;
   
   if (argc != 2) {
      printf("Usage: uartDebugParser logFile\n");
      exit(1);
   }
   
   if ((logFile = fopen(argv[1], "r")) == NULL) {
      printf("Error: can't open log file.\n");
      exit(1);
   }
   
   fscanf(logFile, "%s\n", buf);
   if (strcmp(buf, "time-stamped") == 0) {
      timeStamp = 1;
      printf("time-stamped\n");
   } else if (strcmp(buf, "no_timestamp") == 0) {
      timeStamp = 0;
      printf("no timestamp\n");
   } else {
      printf("Invalid log format!\n");
      exit(1);
   }
   fgets(buf, MAXBUFLEN, logFile);
   printf("%s\n", buf);

   while (1) {
      if (timeStamp) {
         if (EOF == fscanf(logFile, "%d %d %d %d %d",
            &nodeId, &hours, &minutes, &seconds, &milisec)) {
            break;
         }
         printf("Node %d at %02d:%02d:%02d.%02d\n", 
            nodeId, hours, minutes, seconds, milisec);
      } else {
         if (EOF == fscanf(logFile, "%d", &nodeId)) {
            break;
         }
         printf("Node %d:\n", nodeId);
      }
      fscanf(logFile, "%d", &numbytes);
      // print out debugging info
      for(i = 0; i < numbytes; i++){
         fscanf(logFile, "%d", &msgNo);
#ifdef STATE_EVENT
         if (msgNo >= sizeof(stateEvent)) exit(1);
         printf("   %s\n", stateEvent[msgNo]);
#else
         printf("   %d\n", msgNo);
#endif
      }
      printf("\n");
   }
   fclose(logFile);
   return 0;
}
