/*									tab:4
 * Copyright (c) 2002 the University of Southern California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF SOUTHERN CALIFORNIA BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
 * UNIVERSITY OF SOUTHERN CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * THE UNIVERSITY OF SOUTHERN CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF SOUTHERN CALIFORNIA HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 *
 * Authors:	Wei Ye
 * Date created: 1/21/2003
 *
 * The radio for Mica consists of 3 parts:
 *   1) RFM; 2) SPI; 3) Timer/counter 2
 *
 * This module implements the radio control functions:
 *   1) Put radio into different states:
 *   	a) idle; b) sleep; c) receive; d) transmit
 *   2) Physical carrier sense
 *   3) Tx and Rx of bytes
 * 
 */

configuration RadioControl
{
   provides {
      interface StdControl;
      interface RadioState;
      interface CarrierSense;
      interface RadioByte;
   }
}

implementation
{
   components RadioControlM, CC1000ControlM, HPLCC1000M, ADCC;
   
   StdControl = RadioControlM;
   RadioState = RadioControlM;
   CarrierSense = RadioControlM;
   RadioByte = RadioControlM;
   
   RadioControlM.CC1000StdControl -> CC1000ControlM;
   RadioControlM.CC1000Control -> CC1000ControlM;
   
   CC1000ControlM.HPLChipcon -> HPLCC1000M.HPLCC1000;
   
   RadioControlM.ADCControl -> ADCC;
   RadioControlM.RSSIADC -> ADCC.ADC[TOS_ADC_CC_RSSI_PORT];
}
