/*									tab:4
 * Copyright (c) 2002 the University of Southern California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF SOUTHERN CALIFORNIA BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
 * UNIVERSITY OF SOUTHERN CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * THE UNIVERSITY OF SOUTHERN CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF SOUTHERN CALIFORNIA HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 *
 * Authors:	Wei Ye
 *
 * this file defines the events in S-MAC for debugging
 */

#ifndef SMAC_EVENTS
#define SMAC_EVENTS

// packet transmission
#define TX_SYNC_DONE 11
#define TX_RTS_DONE  12
#define TX_CTS_DONE  13
#define TX_BCAST_DONE 14
#define TX_UCAST_DONE 15
#define TX_ACK_DONE 16

// packet reception
#define RX_SYNC_DONE 17
#define RX_RTS_DONE 18
#define RX_CTS_DONE 19
#define RX_BCAST_DONE 20
#define RX_UCAST_DONE 21
#define RX_ACK_DONE 22
#define RX_ERROR 23
#define RX_UNKNOWN_PKT 24

// timer event
#define TIMER_FIRE_NAV 25
#define TIMER_FIRE_NEIGHBOR_NAV 26
#define TIMER_FIRE_DATA_SENSE1 27
#define TIMER_FIRE_DATA_SENSE2 28
#define TIMER_FIRE_WAIT_CTS 29
#define TIMER_FIRE_WAIT_ACK 30
#define TIMER_FIRE_LISTEN_SYNC 31
#define TIMER_FIRE_LISTEN_DATA 32
#define TIMER_FIRE_SCHED_SLEEP 33
#define TIMER_FIRE_NEED_TX_SYNC 34
#define TIMER_FIRE_TX_DELAY 35
#define TIMER_FIRE_ADAP_LISTEN_DONE 36
#define TIMER_FIRE_TX_RETRY 37

// carrier sense
#define CHANNEL_BUSY_DETECTED 38
#define CHANNEL_IDLE_DETECTED 39
#define START_SYMBOL_DETECTED 40

// other events
#define TRYTOSEND_FAIL_NOT_IDLE 41
#define TRYTOSEND_FAIL_NAV 42
#define TRYTOSEND_FAIL_NEIGHBNAV 43

// tx related flags and events
#define SMAC_TX_REQUEST_IS_0 44
#define SMAC_TX_REQUEST_IS_1 45
#define SMAC_BCAST_REQUEST_REJECTED_TXREQUEST_IS_1 46
#define SMAC_BCAST_REQUEST_REJECTED_DATA_IS_0 47
#define SMAC_BCAST_REQUEST_REJECTED_PKTLEN_ERROR 48
#define SMAC_UCAST_REQUEST_REJECTED_TXREQUEST_IS_1 49
#define SMAC_UCAST_REQUEST_REJECTED_DATA_IS_0 50
#define SMAC_UCAST_REQUEST_REJECTED_PKTLEN_ERROR 51
#define SMAC_UCAST_REQUEST_REJECTED_NUMFRAGS_IS_0 52

// application layer
#define APP_TX_PENDING_IS_0 53
#define APP_TX_PENDING_IS_1 54
#define APP_TX_BCAST_ACCEPTED_BY_MAC 55
#define APP_TX_BCAST_REJECTED_BY_MAC 56
#define APP_TX_UCAST_ACCEPTED_BY_MAC 57
#define APP_TX_UCAST_REJECTED_BY_MAC 58
#define APP_POST_TX_TASK_FAILED 59
#define APP_TIME_COUNT_IS_0 60
#define APP_TIME_COUNT_NOT_RENEW 61

// physical layer
#define PHY_RX_BUF_FULL 62
#define PHY_STATE_IS_RECEIVING 63
#define PHY_STATE_IS_TRANSMITTING 64

#define TIMER_FIRE_TX_ERR 65
#define TIMER_FIRE_TX_HOLD_PKT 66
#define TIMER_FIRE_DATA_ACTIVE 67
#define TIMER_FIRE_UPD_NEIGHB_LIST 68
#define PHY_RESET_CALLED 69
#define NUM_NEIGHB_BECOMES_0 70
#define SYNC_BLOCKED 71

#endif // SMAC_EVENTS
