includes Epidemic;

module TestEpidemicM {
  provides interface StdControl;
  uses {
    interface Epidemic;
    interface Timer as SendTimer;
    interface Leds;
    interface Send as SendMH;
    interface RouteControl;
  }
}

implementation {

  uint16_t myValue;
  uint32_t bigValue;
  uint16_t timerPeriod;

  TOS_Msg buf;
  bool currentlySending;

  enum {
    TIMER_PERIOD = 8192,
  };

  enum {
    EP_MYVALUE_CH = 1,
    EP_BIGVALUE_CH = 2,
    EP_SEND_PERIOD_CH = 3,
  };

  command result_t StdControl.init() {
    timerPeriod = TIMER_PERIOD;
    currentlySending = FALSE;
    return SUCCESS;
  }
  
  command result_t StdControl.start() {
    myValue = 0xfedc;

    call Epidemic.registerDataItem(EP_MYVALUE_CH, 
				   &myValue, sizeof(myValue));

    call Epidemic.registerDataItem(EP_BIGVALUE_CH, 
				   &bigValue, sizeof(bigValue));
    
    call Epidemic.registerDataItem(EP_SEND_PERIOD_CH,
				   &timerPeriod, sizeof(timerPeriod));
    
    call SendTimer.start(TIMER_ONE_SHOT, timerPeriod);
    return SUCCESS;
  }
  
  command result_t StdControl.stop() {
    return SUCCESS;
  }

  task void SendTask() {
    uint16_t buflen;
    TestEpidemicMsg *epMsg;

    if ((epMsg = (TestEpidemicMsg *)call SendMH.getBuffer(&buf,&buflen))) {

      epMsg->value = myValue;
      
      dbg(DBG_USR1, "Sending myValue = %d to parent = %d\n", myValue,
	  call RouteControl.getParent());
    
      if (call SendMH.send(&buf, sizeof(TestEpidemicMsg)) == SUCCESS) {
	call Leds.redToggle();
      }
    }
  }

  event result_t SendTimer.fired() {

    if (call RouteControl.getParent() != 0xffff) {
      post SendTask();
    }
    call SendTimer.start(TIMER_ONE_SHOT, timerPeriod);
    return SUCCESS;
  }

  event result_t Epidemic.changeHandler(uint8_t channel,
					uint8_t *pData) {

    switch (channel) {

    case EP_MYVALUE_CH:
#ifdef PLATFORM_PC
      dbg(DBG_USR1, "@%lld myValue is now %d\n", 
	  tos_state.tos_time, myValue);
#endif
      if (myValue % 2 == 1)
	call Leds.greenOn();
      else
	call Leds.greenOff();
      break;

    case EP_BIGVALUE_CH:      
#ifdef PLATFORM_PC
      dbg(DBG_USR1, "@%lld bigValue is now %d\n", 
	  tos_state.tos_time, bigValue);
#endif
      if (bigValue % 2 == 1)
	call Leds.redOn();
      else
	call Leds.redOff();
      break;
    }
    
    return SUCCESS;
  }

  event result_t SendMH.sendDone(TOS_MsgPtr pMsg, result_t success) {
    call Leds.redToggle();
    return SUCCESS;
  }
}






