/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/*
 *
 * Authors:		Gilman Tolle
 * Date last modified:  3/12/03
 *
 */

/**
 * @author Gilman Tolle
 */


#ifndef _TOS_EPIDEMIC_H
#define _TOS_EPIDEMIC_H

#include "AM.h"

enum {
  AM_EPIDEMICMSG = 70,
};

#define MAKE_KEY(_appID, _paramID) (((uint32_t)_appID) << 8 | ((uint32_t)_paramID))

#define KEY_TO_COMPONENT(_appParamID) (((uint32_t)_appParamID) >> 8)
#define KEY_TO_PARAM(_appParamID) ((uint8_t)_appParamID)

enum {
  MAX_DATA_SIZE = 16,
};

typedef struct EpidemicMetadata {
  uint32_t key;
  int16_t   seqno;
} __attribute__ ((packed)) EpidemicMetadata;

typedef struct EpidemicMsg {
  EpidemicMetadata metadata;
  uint8_t          data[MAX_DATA_SIZE];
} __attribute__ ((packed)) TOS_EpidemicMsg;

#endif

