
module Blinker {
  provides {
    interface StdControl;
  }
  uses {
    interface Timer;
    interface Time;
  }
}

implementation {

  command result_t StdControl.init() {
    return SUCCESS;
  }

  command result_t StdControl.start() {
    return call Timer.start(TIMER_ONE_SHOT, 500);
    return SUCCESS;
  }

  command result_t StdControl.stop() {
    return call Timer.stop();
  }
  int state;
  event result_t Timer.fired() {
    tos_time_t t;
    uint16_t diff;
    state ^= 1;
    if(state & 0x1) TOSH_SET_YELLOW_LED_PIN();
    else TOSH_CLR_YELLOW_LED_PIN();


    t = call Time.get(); 
    diff = t.low32 & 0x3ff;
    diff = 0x400 - diff;
    call Timer.start(TIMER_ONE_SHOT, diff);
    return SUCCESS;
  }
  
}


