/*									tab:4
 *
 *
 * "Copyright (c) 2000-2002 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*									tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *  install, copy or use the software.
 *
 *  Intel Open Source License 
 *
 *  Copyright (c) 2002 Intel Corporation 
 *  All rights reserved. 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 * 
 *	Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *      Neither the name of the Intel Corporation nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE INTEL OR ITS
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * 
 */
/* History:   created 1/25/2001
 *
 *  @author ..., Hu Siquan
 *
 *  $Id$ 
 *
 */
/******************************************************************************
 * Measures MTS400/420 weatherboard sensors & gps and converts to engineering units
 * were possible. 
 *-----------------------------------------------------------------------------
 * Output results through mica2 uart port and radio. 
 * Use Xlisten.exe program to view data from either port:
 *  uart: mount mica2 on mib510 with MTS400/420
 *        connect serial cable to PC
 *        run xlisten.exe at 57600 baud
 *  radio: run mica2 with  MTS400/420, 
 *         run mica2 with TOSBASE
 *         run xlisten.exe at 57600 baud
 *------------------------------------------------------------------------------
 * NOTES:

 * -Intersema pressure sensor control lines are shared with gps control lines

 * -Cannot enable gps rx/tx and intersema at same time

 *

 * - gps is always enabled, work for both  MTS420  and MTS400 sensor boards.

 * - if gps not present (MTS400) then additional ~2sec gps timeout will occur

 *

 * Strategy:

 * 1. Turn on gps power and leave on

 * 2. sequentially read  all weather sensors (green led on).

 *    - xmit weather sensor data

 * 3. get gps packet (red led on):

 *    - enable gps Rx,Tx lines to cpu

 *    - wait up to 1 sec to receive a packet (toggle yellow if no pkt)

 *    - xmit gps packet

 *    - disable gps Rx,Rx lines

 * 4. repeat 2,3

 * NOTE:  

 * No real power strategy; just turns sensors on sequentially, gps always on.

 * Need I2C BusArbitration routines for better power control

 *------------------------------------------------------------------------------
 
 *-----------------------------------------------------------------------------
 * Data packet structure  :
 *
 * * PACKET #1 (of 2)
 * ----------------
 *  msg->data[0] : sensor id, MTS400 = 0x85,MTS420 = 0x86
 *  msg->data[1] : packet id = 1
 *  msg->data[2] : node id
 *  msg->data[3] : reserved
 *  msg->data[4,5] : battery ADC data
 *  msg->data[6,7] : humidity data
 *  msg->data[8,9] : temperature data
 *  msg->data[10,11] : cal_word1 
 *  msg->data[12,13] : cal_word2
 *  msg->data[14,15] : cal_word3
 *  msg->data[16,17] : cal_word4
 *  msg->data[18,19] : intersematemp
 *  msg->data[20,21] : pressure
 *  msg->data[22,23] : taosch0
 *  msg->data[24,25] : taosch1
 *  msg->data[26,27] : accel_x
 *  msg->data[28, 3] : accel_y   TOS packet is 29 bytes 0..28
 
 * 
 * PACKET #2 (of 2)
 * ----------------
 *  msg->data[0] : sensor id, MTS400 = 0x85,MTS420 = 0x86
 *  msg->data[1] : packet id = 2
 *  msg->data[2] : node id
 *  msg->data[3] : reserved
 *  msg->data[4] : Hours
 *  msg->data[5] : Minutes
 *  msg->data[6] : Latitude degrees
 *  msg->data[7] : Longitude degrees
 *  msg->data[8,9,10,11] : Decimal seconds
 *  msg->data[12,13,14,15] : Latitude decimal minutes
 *  msg->data[16,17,18,19] : Longitude decimal minutes
 *  msg->data[20] : NSEWind
 *  msg->data[21] : whether the packet is valid
 *
 *------------------------------------------------------------------------------
 *****************************************************************************/

includes sensorboard;


module TestMTS400M {
  provides interface StdControl;
  uses {

//gps
 //   interface I2CSwitchCmds as GpsCmd;
     interface GpsCmd;

   

   

    interface StdControl as GpsControl;
 //   interface BareSendMsg as GpsSend;
    interface ReceiveMsg as GpsReceive;
    
    interface ADC as ADCBATT;
    
//UART communication
    interface StdControl as UARTControl;
    interface BareSendMsg as UARTSend;
    interface ReceiveMsg as UARTReceive;

//RF communication
    interface StdControl as RadioControl;
    interface BareSendMsg as RadioSend;
    interface ReceiveMsg as RadioReceive;;

//Accels
    interface StdControl as AccelControl;
    interface I2CSwitchCmds as AccelCmd;
    interface ADC as AccelX;
    interface ADC as AccelY;

//Intersema
    interface SplitControl as PressureControl;
    //interface StdControl as PressureControl;
    interface ADC as IntersemaTemp;
    interface ADC as IntersemaPressure;
    interface Calibration as IntersemaCal;
    
//Sensirion
    interface SplitControl as TempHumControl;
    interface ADC as Humidity;
    interface ADC as Temperature;
    interface ADCError as HumidityError;
    interface ADCError as TemperatureError;
//Taos
    interface SplitControl as TaosControl;
    interface ADC as TaosCh0;
    interface ADC as TaosCh1;

    interface Timer;
    interface Leds;


  }

}
implementation
{

#include "gps.h"


  enum {START, BUSY, GPS_BUSY,BATT_DONE, HUMIDITY_DONE, PRESSURE_DONE, LIGHT_DONE, ACCEL_DONE, GPS_DONE};
  enum {SENSOR_NONE = 0,

        SENSOR_BATT_START = 10,

		

		SENSOR_HUMIDITY_START = 20,

        SENSOR_HUMIDITY_GETHUMDATA = 21,

        SENSOR_HUMIDITY_GETTEMPDATA = 22,

		SENSOR_HUMIDITY_STOP = 23,



		SENSOR_PRESSURE_START = 30,

		SENSOR_PRESSURE_GETCAL = 31,

		SENSOR_PRESSURE_GETPRESSDATA = 32,

		SENSOR_PRESSURE_GETTEMPDATA = 33,

		SENSOR_PRESSURE_STOP = 34,



		SENSOR_LIGHT_START = 40,

		SENSOR_LIGHT_GETCH0DATA = 41,

		SENSOR_LIGHT_GETCH1DATA = 42,

		SENSOR_LIGHT_STOP = 43,

		

		SENSOR_ACCEL_START = 50,

		SENSOR_ACCEL_GETXDATA = 51,

		SENSOR_ACCEL_GETYDATA = 52,

		SENSOR_ACCEL_STOP = 53

		};
  
  enum { SENSOR_ID = 0, PACKET_ID, NODE_ID, RSVD};

  enum {  VREF=4, 

       	HUMIDITY = 6,

       	
       	TEMP = 8,

       	CAL_WORD1 = 10, 

       	CAL_WORD2 = 12, 

       	CAL_WORD3 = 14,

       	CAL_WORD4 = 16,

       	INTERSEMATEMP = 18,

        PRESSURE = 20,

        TAOSCH0 = 22,

        TAOSCH1 = 24,

        ACCEL_X = 26,

       	ACCEL_Y = 28,

  };

  enum { 

    HOUR = 4,MINUTE,LAT_DEG,LONG_DEG,DEC_SEC,

    LAT_DEC_MIN=12,

    LONG_DEC_MIN=16,NSEWIND=20,FIXED};



  #define TIMER_PERIOD 100            // timer period in msec

  #define GPS_MAX_WAIT 20             // max wait time for gps packet = GPS_MAX_WAIT*TIMER_PERIOD

  #define MSG_LEN  29                 // excludes TOS header, but includes xbow header



  char count;

 
  uint16_t calibration[4];           //intersema calibration words
  norace uint8_t  state;                    //

  uint8_t  sensor_state;             //debug only
  

  uint8_t gps_wait_cnt;              //cnts wait periods for gps pkt to arrive
  bool gps_pwr_on;                   //true if gps power on

    
  TOS_Msg msg_buf_uart, msg_buf_radio;
  TOS_Msg gps_buf_uart, gps_buf_radio;
  TOS_MsgPtr msg_uart,msg_radio,gps_uart,gps_radio;
  bool msg_state, gps_state, sending_packet;

  char gga_fields[GGA_FIELDS][GPS_CHAR_PER_FIELD]; // = {{0}};
   
  
  task void send_radio_msg() 
  {
  	uint8_t l_msgState, l_gpsState; 
  	atomic {
		l_msgState = msg_state; 
		l_gpsState = gps_state;
	}
	
  	if(l_msgState ){
  		msg_radio->data[SENSOR_ID] = SENSOR_BOARD_ID; 
		msg_radio->data[PACKET_ID] = 1;  	
		msg_radio->data[NODE_ID] = TOS_LOCAL_ADDRESS;
		//msg_radio->data[RSVD] = 0;
	
		msg_radio->addr = TOS_BCAST_ADDR;
    	msg_radio->type = 0;
    	msg_radio->length = MSG_LEN;
    	msg_radio->group = TOS_AM_GROUP;
    	
    	call Leds.redToggle();
    	call Leds.greenToggle();
    	call Leds.yellowToggle();
    
    	call RadioSend.send(msg_radio);
 
    }else{
    if(l_gpsState ){
    	gps_radio->data[SENSOR_ID] = SENSOR_BOARD_ID; 
		gps_radio->data[PACKET_ID] = 2;  	
		gps_radio->data[NODE_ID] = TOS_LOCAL_ADDRESS;
		gps_radio->data[RSVD] = 0;
	
		gps_radio->addr = TOS_BCAST_ADDR;
    	gps_radio->type = 0;
    	gps_radio->length = MSG_LEN;
    	gps_radio->group = TOS_AM_GROUP;
    
    	call RadioSend.send(gps_radio);	
   

     }
    }
    return;
  }

  task void send_uart_msg() {
	
	uint8_t i, l_msgState, l_gpsState;        
	// compose the uart gps paket here
	atomic {
		sending_packet = TRUE;
		l_msgState = msg_state; 
		l_gpsState = gps_state;
	}
	
	if(l_msgState ){
	msg_uart->data[SENSOR_ID] = SENSOR_BOARD_ID;
    msg_uart->data[PACKET_ID] = 1;
    msg_uart->data[NODE_ID] = TOS_LOCAL_ADDRESS;
    //msg_uart->data[RSVD] = 0;

    msg_uart->addr = TOS_UART_ADDR;
    msg_uart->type = 0;
    msg_uart->length = MSG_LEN;
    msg_uart->group = TOS_AM_GROUP;

    for (i = 2; i <= MSG_LEN - 1; i++)
    	msg_radio->data[i] = msg_uart->data[i];
    	msg_radio->data[RSVD] = msg_uart->data[RSVD];
    call UARTSend.send(msg_uart);
	}
	else{
    if(l_gpsState ){
	gps_uart->data[SENSOR_ID] = SENSOR_BOARD_ID;
    gps_uart->data[PACKET_ID] = 2;
    gps_uart->data[NODE_ID] = TOS_LOCAL_ADDRESS;
    gps_uart->data[RSVD] = 0;

    gps_uart->addr = TOS_UART_ADDR;
    gps_uart->type = 0;
    gps_uart->length = MSG_LEN;
    gps_uart->group = TOS_AM_GROUP;

    for (i = 2; i <= MSG_LEN - 1; i++)
    	gps_radio->data[i] = gps_uart->data[i];
    call UARTSend.send(gps_uart);
    }
    }
    
    return;
  }


 task void stopPressureControl()

 {

    atomic sensor_state = SENSOR_PRESSURE_STOP;

 	call PressureControl.stop();

 	return;

 }

   


 task void stopTempHumControl(){

 	atomic sensor_state = SENSOR_HUMIDITY_STOP;

	call TempHumControl.stop();

 	return;

 	}

  


  task void stopTaosControl(){

 	atomic sensor_state = SENSOR_LIGHT_STOP;

 	call TaosControl.stop();

 	return;

 	}





   task void powerOffAccel(){

     atomic sensor_state = SENSOR_ACCEL_STOP;

 	 call AccelCmd.PowerSwitch(0);                            //power off

 	 return;

 	}





  command result_t StdControl.init() {
   
    atomic {
    msg_uart = &msg_buf_uart;
    msg_radio = &msg_buf_radio;
    
    gps_uart = &gps_buf_uart;
    gps_radio = &gps_buf_radio;
    
    
    msg_state = FALSE;
    gps_state = FALSE;
    gps_pwr_on = FALSE;



    sending_packet = FALSE;
    }

	MAKE_BAT_MONITOR_OUTPUT();  // enable voltage ref power pin as output
	MAKE_ADC_INPUT();           // enable ADC7 as input

// usart1 is also connected to external serial flash
// set usart1 lines to correct state
    TOSH_MAKE_FLASH_OUT_OUTPUT();             //tx output
    TOSH_MAKE_FLASH_CLK_OUTPUT();             //usart clk

    

    call RadioControl.init();
    call UARTControl.init();
    call Leds.init();
    
    call GpsControl.init();      

	call TaosControl.init();
	call AccelControl.init();      //initialize accelerometer 
	call TempHumControl.init();    //init Sensirion
	call PressureControl.init();   // init Intersema
	
   	return SUCCESS;
  }

  command result_t StdControl.start() {
  	call HumidityError.enable();                 //in case Sensirion doesn't respond
    call TemperatureError.enable();              //  "
 
 	  call UARTControl.start();
    call RadioControl.start();
    
    call GpsControl.start();      
      
	  	atomic state = START;
    atomic sensor_state= SENSOR_NONE;

    atomic gps_wait_cnt = 0;

	   call Timer.start(TIMER_REPEAT, TIMER_PERIOD);    //start up sensor measurements

	return SUCCESS;
  }

  command result_t StdControl.stop() {
  	call GpsControl.stop();
  	call RadioControl.stop();
    call UARTControl.stop();
  	call Timer.stop();
  
    return SUCCESS;
  }

/******************************************************************************
 * Timer fired, test GPS, humidity/temp
 * async for test only

 * If gps_wait_cnt > 0 then gps is active, waiting for a packet
 *****************************************************************************/
event result_t Timer.fired() {
    uint8_t l_state;


		

	if (!gps_pwr_on){

	   return call GpsCmd.PowerSwitch(1);  //turn on GPS power, stays on for entire test  

	   return SUCCESS;

    }
    

    atomic l_state = state;

    if (sending_packet || (l_state == BUSY)) return SUCCESS ;      //don't overrun buffers


    

	

 switch(l_state) {

	    case START:

	       atomic{

		        state = BUSY;

		        sensor_state = SENSOR_BATT_START;

	       }
        call Leds.greenOn();

        SET_BAT_MONITOR();                //turn on voltage ref power
	    TOSH_uwait(100);                  //allow time to turn on
        return call ADCBATT.getData();           //get vref data;
   	    break;


     case BATT_DONE:

	       CLEAR_BAT_MONITOR();
	       atomic{

	         state = BUSY;
	         sensor_state = SENSOR_HUMIDITY_START;

	       }

	       return call TempHumControl.start();
	       break;	  


     case HUMIDITY_DONE:

	       atomic {

		         state = BUSY;

		         sensor_state  = SENSOR_PRESSURE_START;
		      }

	       return call PressureControl.start();
        break;

	 	  
     case PRESSURE_DONE:

	       atomic{

	         state = BUSY;
		        sensor_state = SENSOR_LIGHT_START;

	       }

		      return call TaosControl.start();

		      break;
 		  

     case LIGHT_DONE:
         atomic{

		          state = BUSY;
		          sensor_state = SENSOR_ACCEL_START;

         }

		       return call AccelCmd.PowerSwitch(1);//power on
	        break;
	
	    case ACCEL_DONE:

         call Leds.greenOff();

    		   atomic state = GPS_BUSY;

         return call GpsCmd.TxRxSwitch(1);           //enable gps tx/rx

 	       break;

	
    case GPS_BUSY:

         if (gps_wait_cnt >= GPS_MAX_WAIT){      // gps rcvd pkt before time out?             

           call GpsCmd.TxRxSwitch(0);           // no,disable gps tx/rx switches

           call Leds.yellowToggle();

		         return SUCCESS;

         }

	        else {

	          gps_wait_cnt++;                      //keep waiting for gps pkt

		         return SUCCESS;

	        }

      break;

	 }

    return SUCCESS;
}

/******************************************************************************
 * Packet received from GPS - ASCII msg
 * 1st byte in pkt is number of ascii bytes
 * async used only for testing
 GGA - Global Positioning System Fix Data
        GGA,123519,4807.038,N,01131.324,E,1,08,0.9,545.4,M,46.9,M, , *42
           123519       Fix taken at 12:35:19 UTC
           4807.038,N   Latitude 48 deg 07.038' N
           01131.324,E  Longitude 11 deg 31.324' E
           1            Fix quality: 0 = invalid
                                     1 = GPS fix
                                     2 = DGPS fix
           08           Number of satellites being tracked
           0.9          Horizontal dilution of position
           545.4,M      Altitude, Metres, above mean sea level
           46.9,M       Height of geoid (mean sea level) above WGS84
                        ellipsoid
           (empty field) time in seconds since last DGPS update
           (empty field) DGPS station ID number
 *****************************************************************************/
event TOS_MsgPtr GpsReceive.receive(TOS_MsgPtr data) {  

  uint8_t i,j,m,length,NS,EW;
  uint16_t k;
  uint32_t temp;
  bool end_of_field;
  char *packet_format;
  char *pdata;
  float dec_secs,dec_min;



   //change to GPS packet!!
  GPS_MsgPtr gps_data = (GPS_MsgPtr)data;
 

  // if gps_state = TRUE then waiting to xmit gps uart/radio packet

  if (gps_state) return data;       

  // check for NMEA format, gga_fields[0]
  packet_format = gps_data->data;
  // 
  if ( !((packet_format[3] == 'G') && (packet_format[4] == 'G') &&(packet_format[5] == 'A'))) {
         //SODbg(DBG_USR2, "No NEMA format, gps packet parese failed!!  \n");	  
     return data;

  } 
    
  // parse comma delimited fields to gga_filed[][]
  end_of_field = FALSE;
  i=0;
  k=0;
  length = gps_data->length;
  while (i < GGA_FIELDS) {
        // assemble gga_fields array
        end_of_field = FALSE;
        j = 0;
        while (!end_of_field & k < length) {
        	if (gps_data->data[k] == GPS_DELIMITER) {
               end_of_field = TRUE;
            } 
            else {
               gga_fields[i][j] = gps_data->data[k];
            }
            j++;
            k++;
         }
         // two commas (,,) indicate empty field
         // if field is empty, set it equal to 0
         if (j <= 1) {
            for (m=0; m<10; m++) gga_fields[i][m] = '0';
         }
         i++;
   }
   
   // uint8_t 
   if((gga_fields[6][0]-'0')<=0)  {

  	 //SODbg(DBG_USR2, "Gps not fixed! \n"); 
   	 gps_uart->data[FIXED]=(uint8_t)(gga_fields[6][0]-'0'); // invalid
    

	  
   }else{
     gps_uart->data[FIXED]=(uint8_t)(gga_fields[6][0]-'0');
   }  
 
   // gga_msg.hours = call extract_hours(gga_fields[1]);
    pdata=gga_fields[1];
    gps_uart->data[HOUR]=10*(pdata[0]-'0') + (pdata[1]-'0');
  
   // gga_msg.minutes = call extract_minutes(gga_fields[1]);
   gps_uart->data[MINUTE]=10*(pdata[2]-'0') + (pdata[3]-'0');
     
   // uint32_t
   // gga_msg.dec_sec = call extract_dec_sec(gga_fields[1]);
   dec_secs = 10*(pdata[4]-'0') +  (pdata[5]-'0') + 0.1*(pdata[7]-'0') 
              + 0.01*(pdata[8]-'0')
               + 0.001*(pdata[9]-'0');
   temp = (uint32_t)(dec_secs * 1000);
   gps_uart->data[DEC_SEC] = temp&0xff;
   gps_uart->data[DEC_SEC+1] = (temp&0xff00)>>8;
   gps_uart->data[DEC_SEC+2] = (temp&0xff0000)>>16;
   gps_uart->data[DEC_SEC+3] = (temp&0xff000000)>>24;
   
   // gga_msg.Lat_deg = call extract_Lat_deg(gga_fields[2]);
   pdata=gga_fields[2];
   gps_uart->data[LAT_DEG]= (uint16_t)(10*(pdata[0]-'0') + (pdata[1]-'0'));
 
    // gga_msg.Lat_dec_min = call extract_Lat_dec_min(gga_fields[2]);
   dec_min = 10*(pdata[2]-'0') +  (pdata[3]-'0') + 0.1*(pdata[5]-'0') 
              + 0.01*(pdata[6]-'0') + 0.001*(pdata[7]-'0') + 0.0001*(pdata[8]-'0');
   temp = (uint32_t)(dec_min * 10000);
   gps_uart->data[LAT_DEC_MIN] = temp&0xff;
   gps_uart->data[LAT_DEC_MIN+1] = (temp&0xff00)>>8;
   gps_uart->data[LAT_DEC_MIN+2] = (temp&0xff0000)>>16;
   gps_uart->data[LAT_DEC_MIN+3] = (temp&0xff000000)>>24;
    
   // gga_msg.Long_deg = call extract_Long_deg(gga_fields[4]);
   pdata = gga_fields[4];
   gps_uart->data[LONG_DEG]  =(100*(pdata[0]-'0') + 10*(pdata[1]-'0') + (pdata[2]-'0')); 
 
   // gga_msg.Long_dec_min = call extract_Long_dec_min(gga_fields[4]);     
   dec_min = 10*(pdata[3]-'0') +  (pdata[4]-'0') + 0.1*(pdata[6]-'0') 
              + 0.01*(pdata[7]-'0') + 0.001*(pdata[8]-'0') + 0.0001*(pdata[9]-'0');
   temp = (uint32_t)(dec_min * 10000);
   gps_uart->data[LONG_DEC_MIN] = temp&0xff;
   gps_uart->data[LONG_DEC_MIN+1] = (temp&0xff00)>>8;
   gps_uart->data[LONG_DEC_MIN+2] = (temp&0xff0000)>>16;
   gps_uart->data[LONG_DEC_MIN+3] = (temp&0xff000000)>>24;
 
   NS = (gga_fields[3][0] == 'N') ? 1 : 0;
   EW = (gga_fields[5][0] == 'W') ? 1 : 0;
   gps_uart->data[NSEWIND]= EW | (NS<<4); // eg. Status = 000N000E = 00010000
 
   if (!sending_packet) { 
     atomic gps_state = TRUE;
     post send_uart_msg();
   }
    return data;                    
}

event result_t GpsCmd.PowerSet(uint8_t PowerState){
  if(PowerState) atomic  gps_pwr_on = TRUE;

  else           atomic gps_pwr_on = FALSE;
  return SUCCESS;
 }


 event result_t GpsCmd.TxRxSet(uint8_t rtstate){

// gps tx/rx switches set to on or off

   if (rtstate){

     call GpsControl.start();          //reinit gps uart since its shared with pressure sensor

     atomic gps_wait_cnt = 0;          //start counting time intervals, waiting for gps pkt    

     call Leds.redOn();

   }

   else{

     atomic state = START;         // gps rx,tx control line switched off, restart weather sensors	    

     call Leds.redOff();

   }

   return SUCCESS;

 }

 
 /****************************************************************************
 * Battery Ref  or thermistor data ready 
 ****************************************************************************/
  async event result_t ADCBATT.dataReady(uint16_t data) {
      msg_uart->data[VREF] = data & 0x00ff;      //voltage reference data
      msg_uart-> data[VREF+1] = data >> 8;
      atomic state = BATT_DONE;
      return SUCCESS;
  }

 /******************************************************************************
 * Intersema MS5534A barometric pressure/temperature sensor
 *  - 6 cal coefficients (C1..C6) are extracted from 4, 16 bit,words from sensor
 * - Temperature measurement:
 *     UT1=8*C5+20224
 *     dT=data-UT1
 *     Temp=(degC x10)=200+dT(C6+50)/1024
 * - Pressure measurement:
 *     OFF=C2*4 + ((C4-512)*dT)/1024
 *     SENS=C1+(C3*dT)/1024 + 24576
 *     X=(SENS*(PressureData-7168))/16384 - OFF
 *     Press(mbar)= X/32+250
 *****************************************************************************/
  async event result_t IntersemaPressure.dataReady(uint16_t data) {    

    msg_uart->data[PRESSURE] = data & 0x00ff;

	msg_uart->data[PRESSURE+1] = data >> 8;

    atomic atomic sensor_state = SENSOR_PRESSURE_GETTEMPDATA;

    return call IntersemaTemp.getData();

  }



  

  async event result_t IntersemaTemp.dataReady(uint16_t data) {
    msg_uart->data[INTERSEMATEMP] = data & 0x00ff;
	msg_uart->data[INTERSEMATEMP+1] = data >> 8;

	post stopPressureControl();
    return SUCCESS;
  }

  
  event result_t IntersemaCal.dataReady(char word, uint16_t value) {
    // make sure we get all the calibration bytes
    count++;
   
    calibration[word-1] = value;

    if (count == 4) {
	  
	    msg_uart->data[CAL_WORD1] = calibration[0] & 0x00ff;
		msg_uart->data[CAL_WORD1+1] = calibration[0] >> 8;
		msg_uart->data[CAL_WORD2] = calibration[1] & 0x00ff;
		msg_uart->data[CAL_WORD2+1] = calibration[1] >> 8;
		msg_uart->data[CAL_WORD3] = calibration[2] & 0x00ff;
		msg_uart->data[CAL_WORD3+1] = calibration[2] >> 8;
		msg_uart->data[CAL_WORD4] = calibration[3] & 0x00ff;
		msg_uart->data[CAL_WORD4+1] = calibration[3] >> 8;
	 

	 atomic sensor_state = SENSOR_PRESSURE_GETPRESSDATA;
     call IntersemaPressure.getData();
    }

    return SUCCESS;
  }

  event result_t PressureControl.initDone() {
    return SUCCESS;
  }

  event result_t PressureControl.stopDone() {
    atomic state = PRESSURE_DONE;

	return SUCCESS;
  }

  event result_t PressureControl.startDone() {
    count = 0;
    atomic sensor_state = SENSOR_PRESSURE_GETCAL;

    call IntersemaCal.getData();
    return SUCCESS;
  }
  
/******************************************************************************
 * Sensirion SHT11 humidity/temperature sensor
 * - Humidity data is 12 bit:
 *     Linear calc (no temp correction)
 *        fRH = -4.0 + 0.0405 * data -0.0000028 * data^2     'RH linear
 *     With temperature correction:
 *        fRH = (fTemp - 25) * (0.01 + 0.00008 * data) + fRH        'RH true
 * - Temperature data is 14 bit
 *     Temp(degC) = -38.4 + 0.0098 * data
 *****************************************************************************/
  async event result_t Temperature.dataReady(uint16_t data) {
    
	msg_uart->data[TEMP] = data & 0x00ff;
	msg_uart->data[TEMP+1] = data >> 8;
	post stopTempHumControl();
   // call TempHumControl.stop();
	return SUCCESS;
  }

 async event result_t Humidity.dataReady(uint16_t data) {
   	msg_uart->data[HUMIDITY] = data & 0x00ff;
	msg_uart->data[HUMIDITY+1] = data >> 8;
    atomic sensor_state = SENSOR_HUMIDITY_GETTEMPDATA;

	return call Temperature.getData();
  }

  event result_t TempHumControl.startDone() {
    atomic sensor_state = SENSOR_HUMIDITY_GETHUMDATA;

	call Humidity.getData();
    return SUCCESS;
  }
  
  event result_t TempHumControl.initDone() {
  return SUCCESS;
  }

  event result_t TempHumControl.stopDone() {
   atomic state = HUMIDITY_DONE;
   return SUCCESS;
  }

event result_t HumidityError.error(uint8_t token)
  {
    call Temperature.getData();
    return SUCCESS;
  }


  event result_t TemperatureError.error(uint8_t token)
  {
    call TempHumControl.stop();
    atomic state = HUMIDITY_DONE;
    return SUCCESS;
  }

/******************************************************************************
 * Taos- tsl2250 light sensor
 * Two ADC channels:
 *    ADC Count Value (ACNTx) = INT(16.5*[CV-1]) +S*CV
 *    where CV = 2^^C
 *          C  = (data & 0x7) >> 4
 *          S  = data & 0xF
 * Light level (lux) = ACNT0*0.46*(e^^-3.13*R)
 *          R = ACNT1/ACNT0
 *****************************************************************************/
  async event result_t TaosCh1.dataReady(uint16_t data) {
    //data = data & 0xff;
    msg_uart->data[TAOSCH1] = data & 0x00ff;
	msg_uart->data[TAOSCH1+1] = 0x00;
	post stopTaosControl();
	return SUCCESS;
  }

  async event result_t TaosCh0.dataReady(uint16_t data) {
    //data = data & 0xff;
    msg_uart->data[TAOSCH0] = data & 0xff;
    msg_uart->data[TAOSCH0+1] = 0x00;
	atomic sensor_state = SENSOR_LIGHT_GETCH1DATA;
    return call TaosCh1.getData();
  }

  event result_t TaosControl.startDone(){
    atomic sensor_state = SENSOR_LIGHT_GETCH0DATA;

    return call TaosCh0.getData();
  }
  
  event result_t TaosControl.initDone() {
    return SUCCESS;
  }

  event result_t TaosControl.stopDone() {
    atomic state = LIGHT_DONE;
    return SUCCESS;
  }

/******************************************************************************
 * ADXL202E Accelerometer
 * At 3.0 supply this sensor's sensitivty is ~167mv/g
 *        0 g is at ~1.5V or ~VCC/2 - this varies alot.
 *        For an accurate calibration measure each axis at +/- 1 g and
 *        compute the center point (0 g level) as 1/2 of difference.
 * Note: this app doesn't measure the battery voltage, it assumes 3.2 volts
 * To getter better accuracy measure the battery voltage as this effects the
 * full scale of the Atmega128 ADC.
 * bits/mv = 1024/(1000*VBATT)
 * bits/g  = 1024/(1000*VBATT)(bits/mv) * 167(mv/g)
 *         = 171/VBATT (bits/g)
 * C       = 0.171/VBATT (bits/mg)
 * Accel(mg) ~ (ADC DATA - 512) /C
 *****************************************************************************/  
  
async event result_t AccelY.dataReady(uint16_t data){
   	msg_uart->data[ACCEL_Y] = data & 0x00ff;
	//msg_uart->data[ACCEL_Y+1] = data >> 8;
	msg_uart->data[RSVD] = data >> 8;
  
    post powerOffAccel();
  //  if (!sending_packet){
  //  	atomic msg_state = TRUE;
  //  	post send_uart_msg();                                  //post uart xmit
  //  }
    return SUCCESS;
}
 
 
/***************************************************/
async  event result_t AccelX.dataReady(uint16_t  data){
    msg_uart->data[ACCEL_X] = data & 0x00ff;
	msg_uart->data[ACCEL_X+1] = data >> 8;
    atomic sensor_state = SENSOR_ACCEL_GETYDATA;

	call AccelY.getData();
    return SUCCESS;
  }

 /***************************************************/
 event result_t AccelCmd.SwitchesSet(uint8_t PowerState){          //power on/off
  if (PowerState){

     call AccelX.getData();                     //start measuring X accel axis
     atomic sensor_state = SENSOR_ACCEL_GETXDATA;

  } 
  else{
  if (!sending_packet){
    	atomic msg_state = TRUE;
    	post send_uart_msg();                                  //post uart xmit
    }
  }
  return SUCCESS;
 }
 
 /***************************************************/    
event result_t UARTSend.sendDone(TOS_MsgPtr msg, result_t success) {
     atomic{

      if(msg_state) msg_uart = msg;
      if(gps_state) gps_uart = msg;
      if (gps_pwr_on)call GpsCmd.PowerSwitch(0);  //turn on GPS power, stays on for entire test  

	  TOSH_uwait(500);
      post send_radio_msg(); 
     } // atomic

      return SUCCESS;
}

event result_t RadioSend.sendDone(TOS_MsgPtr msg, result_t success) {
    atomic{

      if(msg_state) {

		       msg_radio = msg;

               msg_state = FALSE;

               //weather sensor measurement complete

               if(SENSOR_BOARD_ID==0x86)//#ifdef MTS420
		       state = ACCEL_DONE;               
		       else
		       state = START;
			   }
      if(gps_state) { 

	       gps_radio=msg;

	       gps_state = FALSE;

        call GpsCmd.TxRxSwitch(0);           //disable gps tx/rx

    }

	sending_packet = FALSE;
    } //atomic

      return SUCCESS;
}

/***************************************************/    
event TOS_MsgPtr UARTReceive.receive(TOS_MsgPtr data) {
    return data;
}

event TOS_MsgPtr RadioReceive.receive(TOS_MsgPtr data) {
    return data;
}
 

}
