// $Id$

// controls for the voltage reference monitor
#define MAKE_BAT_MONITOR_OUTPUT() sbi(DDRA, 5)
#define MAKE_ADC_INPUT() cbi(DDRF, 7)
#define SET_BAT_MONITOR() sbi(PORTA, 5)
#define CLEAR_BAT_MONITOR() cbi(PORTA, 5)

#define MAKE_GPS_ENA_OUTPUT() sbi(DDRE,6)
#define SET_GPS_ENA() cbi(PORTE,6)
#define CLR_GPS_ENA() sbi(PORTE,6)

// crossbow sensor board id
//define MTS420 to enable gps. 
//       MTS400 will not send gps packets.
#define MTS420

#ifndef MTS420
#define  SENSOR_BOARD_ID 0x85               //MTS400 sensor board id
#else
#define  SENSOR_BOARD_ID 0x86               //MTS420 sensor board id
#endif

#define GPS_MSG_LENGTH 100
#define GPS_CHAR 11
#define GGA_FIELDS 8
#define GPS_CHAR_PER_FIELD 10
#define GPS_DELIMITER ','
#define GPS_END_MSG '*'
//  18 bytes.
struct _gga_msg {

  uint8_t  hours;
  uint8_t  minutes;
  float dec_sec;
  uint8_t  Lat_deg;
  float Lat_dec_min;
  uint8_t  Long_deg;
  float Long_dec_min;
  uint8_t  NSEWind; 
//  uint8_t  num_sats;           
};
typedef struct _gga_msg GGA_Msg;




enum {
    BATT_TEMP_PORT = 7,             //adc port for battery voltage
};


