using System;
using System.Data;
using System.Drawing;
using TASKView.app;
using NationalInstruments.UI;
using NationalInstruments.UI.WindowsForms;

namespace TASKView.lib
{
	/**
	 *  The ChartsPanel controls display of the active charts. 
	 * 
	 * @author      Martin Turon
	 * @version     2004/4/20    mturon      Initial version
	 * 
	 * $Id$
	 */
	public class ChartsPanel : System.Windows.Forms.Panel
	{
		private const  int		CHART_COUNT = 3;
		private static Random	m_rand;

		#region // ==================== INSTANCE DATA ========================
		/** The actual array of chart objects */
		private ScatterGraph[]					m_chart;
		private ScatterGraph					m_chart0;
		private ScatterGraph					m_chart1;
		private ScatterGraph					m_chart2;


		protected int							m_chartCount;		//!< visible chart count
		protected int							m_chartTotal;		//!< total chart count
		private string[]						m_chartSensor;

		private AxMSFlexGridLib.AxMSFlexGrid	m_legendGrid;

		private NationalInstruments.UI.XAxis[]		m_xAxes;
		private NationalInstruments.UI.YAxis[]		m_yAxes;
		private NationalInstruments.UI.XAxis		xAxis1;
		private NationalInstruments.UI.YAxis		yAxis1;
		private NationalInstruments.UI.ScatterPlot ScatterPlot1;
		private NationalInstruments.UI.XAxis		xAxis2;
		private NationalInstruments.UI.YAxis		yAxis2;
		private NationalInstruments.UI.ScatterPlot ScatterPlot2;
		private NationalInstruments.UI.XAxis		xAxis3;
		private NationalInstruments.UI.YAxis		yAxis3;
		private NationalInstruments.UI.ScatterPlot ScatterPlot3;

		#endregion

		// ======================= METHODS ===========================

		#region // ==> ChartPanel: Initialization Code
		/** Constructor -- call InitializeComponent to build GUI. */
		public ChartsPanel()
		{
			InitializeComponent();

			m_rand = new Random();

			//
			// Other constructor logic that isn't autogenerated.
			//

			m_chartSensor   = new string[CHART_COUNT];
			m_chart    = new ScatterGraph[CHART_COUNT];
			m_chart[0] = m_chart0;
			m_chart[1] = m_chart1;
			m_chart[2] = m_chart2;

			m_xAxes    = new XAxis[CHART_COUNT];
			m_xAxes[0] = xAxis1;
			m_xAxes[1] = xAxis2;
			m_xAxes[2] = xAxis3;

			m_yAxes    = new YAxis[CHART_COUNT];
			m_yAxes[0] = yAxis1;
			m_yAxes[1] = yAxis2;
			m_yAxes[2] = yAxis3;

			m_chart[0].Visible = false;
			m_chart[1].Visible = false;
			m_chart[2].Visible = false;

			m_chartSensor[0] = "(none)";
			m_chartSensor[1] = "(none)";
			m_chartSensor[2] = "(none)";

			m_chartCount = 0;
		}

		/** Creates the user interface -- grabbed from Form builder */
		void InitializeComponent() 
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ChartsPanel));
			this.m_chart0 = new NationalInstruments.UI.WindowsForms.ScatterGraph();
			this.ScatterPlot1 = new NationalInstruments.UI.ScatterPlot();
			this.xAxis1 = new NationalInstruments.UI.XAxis();
			this.yAxis1 = new NationalInstruments.UI.YAxis();
			this.m_chart1 = new NationalInstruments.UI.WindowsForms.ScatterGraph();
			this.ScatterPlot2 = new NationalInstruments.UI.ScatterPlot();
			this.xAxis2 = new NationalInstruments.UI.XAxis();
			this.yAxis2 = new NationalInstruments.UI.YAxis();
			this.m_chart2 = new NationalInstruments.UI.WindowsForms.ScatterGraph();
			this.ScatterPlot3 = new NationalInstruments.UI.ScatterPlot();
			this.xAxis3 = new NationalInstruments.UI.XAxis();
			this.yAxis3 = new NationalInstruments.UI.YAxis();
			this.m_legendGrid = new AxMSFlexGridLib.AxMSFlexGrid();
			((System.ComponentModel.ISupportInitialize)(this.m_chart0)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.m_chart1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.m_chart2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.m_legendGrid)).BeginInit();
			this.SuspendLayout();
			// 
			// m_chart0
			// 
			this.m_chart0.Location = new System.Drawing.Point(233, 17);
			this.m_chart0.Name = "m_chart0";
			this.m_chart0.PlotAreaColor = System.Drawing.Color.White;
			this.m_chart0.Plots.AddRange(new NationalInstruments.UI.ScatterPlot[] {
																					  this.ScatterPlot1});
			this.m_chart0.SelectionColor = System.Drawing.Color.Gold;
			this.m_chart0.Size = new System.Drawing.Size(352, 96);
			this.m_chart0.TabIndex = 0;
			this.m_chart0.XAxes.AddRange(new NationalInstruments.UI.XAxis[] {
																				this.xAxis1});
			this.m_chart0.YAxes.AddRange(new NationalInstruments.UI.YAxis[] {
																				this.yAxis1});
			// 
			// ScatterPlot1
			// 
			this.ScatterPlot1.LineWidth = 2F;
			this.ScatterPlot1.PointColor = System.Drawing.Color.Goldenrod;
			this.ScatterPlot1.PointStyle = NationalInstruments.UI.PointStyle.SolidCircle;
			this.ScatterPlot1.XAxis = this.xAxis1;
			this.ScatterPlot1.YAxis = this.yAxis1;
			// 
			// xAxis1
			// 
			this.xAxis1.MajorDivisions.GridColor = System.Drawing.Color.Gray;
			this.xAxis1.MajorDivisions.GridVisible = true;
			this.xAxis1.MajorDivisions.LabelFormat = new NationalInstruments.UI.FormatString(NationalInstruments.UI.FormatStringMode.DateTime, "MM/dd/yy hh:mm:ss");
			this.xAxis1.MinorDivisions.GridColor = System.Drawing.Color.LightGray;
			this.xAxis1.MinorDivisions.GridVisible = true;
			this.xAxis1.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// yAxis1
			// 
			this.yAxis1.MajorDivisions.GridColor = System.Drawing.Color.Gainsboro;
			this.yAxis1.MajorDivisions.GridVisible = true;
			this.yAxis1.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// m_chart1
			// 
			this.m_chart1.Location = new System.Drawing.Point(125, 17);
			this.m_chart1.Name = "m_chart1";
			this.m_chart1.PlotAreaColor = System.Drawing.Color.White;
			this.m_chart1.Plots.AddRange(new NationalInstruments.UI.ScatterPlot[] {
																					  this.ScatterPlot2});
			this.m_chart1.SelectionColor = System.Drawing.Color.Gold;
			this.m_chart1.Size = new System.Drawing.Size(352, 96);
			this.m_chart1.TabIndex = 2;
			this.m_chart1.XAxes.AddRange(new NationalInstruments.UI.XAxis[] {
																				this.xAxis2});
			this.m_chart1.YAxes.AddRange(new NationalInstruments.UI.YAxis[] {
																				this.yAxis2});
			// 
			// ScatterPlot2
			// 
			this.ScatterPlot2.LineColor = System.Drawing.Color.LimeGreen;
			this.ScatterPlot2.LineWidth = 2F;
			this.ScatterPlot2.PointColor = System.Drawing.Color.Goldenrod;
			this.ScatterPlot2.PointStyle = NationalInstruments.UI.PointStyle.SolidCircle;
			this.ScatterPlot2.XAxis = this.xAxis2;
			this.ScatterPlot2.YAxis = this.yAxis2;
			// 
			// xAxis2
			// 
			this.xAxis2.MajorDivisions.GridColor = System.Drawing.Color.Gray;
			this.xAxis2.MajorDivisions.GridVisible = true;
			this.xAxis2.MajorDivisions.LabelFormat = new NationalInstruments.UI.FormatString(NationalInstruments.UI.FormatStringMode.Numeric, "F3");
			this.xAxis2.MinorDivisions.GridColor = System.Drawing.Color.LightGray;
			this.xAxis2.MinorDivisions.GridVisible = true;
			this.xAxis2.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// yAxis2
			// 
			this.yAxis2.MajorDivisions.GridColor = System.Drawing.Color.Gainsboro;
			this.yAxis2.MajorDivisions.GridVisible = true;
			this.yAxis2.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// m_chart2
			// 
			this.m_chart2.Location = new System.Drawing.Point(341, 17);
			this.m_chart2.Name = "m_chart2";
			this.m_chart2.PlotAreaColor = System.Drawing.Color.White;
			this.m_chart2.Plots.AddRange(new NationalInstruments.UI.ScatterPlot[] {
																					  this.ScatterPlot3});
			this.m_chart2.SelectionColor = System.Drawing.Color.Gold;
			this.m_chart2.Size = new System.Drawing.Size(352, 96);
			this.m_chart2.TabIndex = 8;
			this.m_chart2.XAxes.AddRange(new NationalInstruments.UI.XAxis[] {
																				this.xAxis3});
			this.m_chart2.YAxes.AddRange(new NationalInstruments.UI.YAxis[] {
																				this.yAxis3});
			// 
			// ScatterPlot3
			// 
			this.ScatterPlot3.LineWidth = 2F;
			this.ScatterPlot3.PointColor = System.Drawing.Color.Goldenrod;
			this.ScatterPlot3.PointStyle = NationalInstruments.UI.PointStyle.SolidCircle;
			this.ScatterPlot3.XAxis = this.xAxis3;
			this.ScatterPlot3.YAxis = this.yAxis3;
			// 
			// xAxis3
			// 
			this.xAxis3.MajorDivisions.GridColor = System.Drawing.Color.Gray;
			this.xAxis3.MajorDivisions.GridVisible = true;
			this.xAxis3.MajorDivisions.LabelFormat = new NationalInstruments.UI.FormatString(NationalInstruments.UI.FormatStringMode.Numeric, "F3");
			this.xAxis3.MinorDivisions.GridColor = System.Drawing.Color.LightGray;
			this.xAxis3.MinorDivisions.GridVisible = true;
			this.xAxis3.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// yAxis3
			// 
			this.yAxis3.MajorDivisions.GridColor = System.Drawing.Color.Gainsboro;
			this.yAxis3.MajorDivisions.GridVisible = true;
			this.yAxis3.Mode = NationalInstruments.UI.AxisMode.AutoScaleExact;
			// 
			// m_legendGrid
			// 
			this.m_legendGrid.Dock = System.Windows.Forms.DockStyle.Right;
			this.m_legendGrid.Location = new System.Drawing.Point(160, 0);
			this.m_legendGrid.Name = "m_legendGrid";
			this.m_legendGrid.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("m_legendGrid.OcxState")));
			this.m_legendGrid.Size = new System.Drawing.Size(40, 100);
			this.m_legendGrid.TabIndex = 9;
			// 
			// ChartsPanel
			// 
			this.Controls.Add(this.m_chart2);
			this.Controls.Add(this.m_legendGrid);
			this.Controls.Add(this.m_chart1);
			this.Controls.Add(this.m_chart0);
			((System.ComponentModel.ISupportInitialize)(this.m_chart0)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.m_chart1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.m_chart2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.m_legendGrid)).EndInit();
			this.ResumeLayout(false);

		}

		#endregion

		#region // ==> ChartPanel: Sizing Code
		protected void RecalcSize() 
		{
			m_legendGrid.Height = this.Height;
			m_legendGrid.Top = 0;
			m_legendGrid.Left = this.Width - m_legendGrid.Width;

			m_chart[0].Left = 0;
			m_chart[0].Width = m_legendGrid.Left;
			m_chart[1].Left = 0;
			m_chart[1].Width = m_legendGrid.Left;
			m_chart[2].Left = 0;
			m_chart[2].Width = m_legendGrid.Left;

			int chartHeight = (m_chartCount > 0)  ? (int)this.Height / m_chartCount : 0;
			m_chart[0].Height = (m_chart[0].Visible) ? chartHeight : 0;
			m_chart[1].Height = (m_chart[1].Visible) ? chartHeight : 0;
			m_chart[2].Height = (m_chart[2].Visible) ? chartHeight : 0;

			m_chart[0].Top = 0;
			m_chart[1].Top = m_chart[0].Top + m_chart[0].Height;
			m_chart[2].Top = m_chart[1].Top + m_chart[1].Height;
		}

		protected override void OnResize(EventArgs e)
		{
			RecalcSize();
			base.OnResize (e);
		}

		#endregion

		/** 
		 *	Builds UI to display node ids and colors for all motes that are 
		 *	marked for plotting. 
		 * 
		 * @author      Martin Turon
		 * @version     2004/4/21    mturon      Initial version
		 */
		public void BuildLegend() 
		{
			int plotCount = 0;

			m_legendGrid.Cols = 1;
			m_legendGrid.Row  = 0;
			m_legendGrid.Col  = 0;
			m_legendGrid.set_ColAlignment(0, 1);
			m_legendGrid.Text = "Node";

			MoteTable moteTable = theMoteTable.Instance;
			m_legendGrid.Rows = moteTable.Count + 1;
			foreach (MoteInfo moteInfo in moteTable.Values) 
			{
				if ((moteInfo.m_flags & MoteFlags.MF_PLOT) > 0)
				{
					m_legendGrid.Row  = ++plotCount;
					m_legendGrid.Text = moteInfo.m_nodeid.ToString();
					m_legendGrid.CellBackColor = moteInfo.m_color;
				}
			}
			m_legendGrid.Rows = plotCount+1;
		}

		/** 
		 *	Fills a plot data array with random time and data information. 
		 * 
		 * @author      Martin Turon
		 * @version     2004/4/22    mturon      Initial version
		 */
		public void FillRandom(out double[] xData, out double[] yData) 
		{
			uint i;
			const int SIZE = 100;
			xData = new double[SIZE];
			yData = new double[SIZE];

			for (i=0; i<SIZE; i++) 
			{
				xData[i] = (i + 0.1) * 0.1;					// time 
				yData[i] = i + 1.0 + m_rand.Next()%100.0;	// data
			}
		}

		/** 
		 *	Fills a plot data array with time information and data readings
		 *  from a given node and sensor. 
		 * 
		 * @author      Martin Turon
		 * @version     2004/4/27    mturon      Initial version
		 */
		public int FillNode(MoteInfo moteInfo, string sensor, out double[] xData, out double[] yData) 
		{
			ushort nodeid = moteInfo.m_nodeid;
			
			OdbcManager db = theOdbcManager.Instance;
			db.Connect();
			DataSet dSet = db.CreateDataSet(
			db.GetNodeDataCommand(nodeid, sensor));	
			db.Disconnect();

			int size = 0, i = 0;
			try 
			{
				size = dSet.Tables[0].Rows.Count - 1;
				if (size < 0) size = 0;

				xData = new double[size];
				yData = new double[size];
			
				foreach (DataRow dRow in dSet.Tables[0].Rows)
				{
					try 
					{
						if (i >= size) break;
						DateTime rtime = Convert.ToDateTime(dRow["result_time"]);
						object data = dRow[sensor];
						if (data.GetType() == Type.GetType("System.DBNull")) continue;
						yData[i] = Convert.ToDouble(data);
						xData[i] = rtime.ToOADate();
						++i;
					} 
					catch (Exception ex) 
					{
						theOdbcManager.Instance.ErrorLog("\n" + ex.ToString());
					}
				}	
			} 
			catch (Exception ex) 
			{
				theOdbcManager.Instance.ErrorLog("\n" + ex.ToString());
				xData = new double[0];
				yData = new double[0];
			}
	
			return size;
		}

		/** 
		 *	Fills the given chart with data from the given sensor. 
		 * 
		 * @author      Martin Turon
		 * @version     2004/4/28    mturon      Initial version
		 */
		public void ChartUpdate(uint chartNum) 
		{
			double[]	 xData, yData;
			ScatterGraph chartThis	= m_chart[chartNum];
			string		 sensor		= m_chartSensor[chartNum];

			if (!chartThis.Visible) return;

			foreach (MoteInfo moteInfo in theMoteTable.Instance.Values) 
			{
				if ((moteInfo.m_flags & MoteFlags.MF_PLOT) > 0)
				{
					int nodeid = moteInfo.m_nodeid;

					if ((moteInfo.m_plot[chartNum] != null) && 
						(chartThis.Plots.Contains(moteInfo.m_plot[chartNum]))) 
						continue;

					//	FillRandom(out xData, out yData);
					if (FillNode(moteInfo, sensor, out xData, out yData) == 0) continue;

					// The colors red and blue are flipped in the VB6 activeX chart component...
					// This code provides a good example of how to convert Color objects
					// into unsigned integer and back in C#.  See also MoteTable.m_colors.
					//Color color			= moteInfo.m_color;
					//Color colorConvert	= Color.FromArgb(color.B, color.G, color.R);
					//uint  colorPlot		= (uint)colorConvert.ToArgb();

					ScatterPlot plot = new ScatterPlot(m_xAxes[chartNum], m_yAxes[chartNum]);
					plot.LineWidth  = 2;
					plot.LineColor  = moteInfo.m_color;
					plot.PointColor = moteInfo.m_color;
					plot.PointStyle = PointStyle.SolidCircle;
					plot.CanScaleXAxis = true;
					plot.CanScaleYAxis = true;
					plot.PlotXY(xData, yData);

					chartThis.Plots.Add(plot);
					moteInfo.m_plot[chartNum] = plot;
				} 				
				else 
				{
					ScatterPlot plot = moteInfo.m_plot[chartNum];
					if (plot != null) 
					{
						chartThis.Plots.Remove(plot);
						moteInfo.m_plot[chartNum] = null;
					}
				}
			}
		}

		/** 
		 *	Toggles the visibility of the given chart, and refills it
		 *	with data from the given sensor. 
		 * 
		 * @author      Martin Turon
		 * @version     2004/4/21    mturon      Initial version
		 */
		public void ChartSensor(uint chartNum, string sensor) 
		{
			ScatterGraph	chartThis = m_chart[chartNum];
			bool						chartRedraw = false;

			if (theSensorTable.Instance.ContainsKey(sensor)) 
			{			
				if (!chartThis.Visible) 
				{
					m_chartCount++;
					chartThis.Visible = true;
					chartRedraw = true;
				}

				if (m_chartSensor[chartNum] != sensor) 
					chartRedraw = true;
				m_chartSensor[chartNum] = sensor;

				if (chartRedraw) 
					chartThis.Plots.Clear();
			} 
			else 
			{
				if (chartThis.Visible) 
				{
					m_chartCount--;
					chartThis.Visible = false;
					chartRedraw = true;
				}
			}

			ChartUpdate(chartNum);

			if (chartRedraw) 
			{
				//chartThis.Axes.Item(1).AutoScaleNow();
				//chartThis.Axes.Item(2).AutoScaleNow();
				RecalcSize();
				Refresh();
			}
		}
	}	// class ChartPanel


	/**
	 *  The ChartComboBox class controls which sensor to chart. 
	 * 
	 * @author      Martin Turon
	 * @version     2004/4/21    mturon      Initial version
	 */
	public class ChartComboBox : System.Windows.Forms.ComboBox
	{
		public ChartComboBox() 
		{
			try 
			{
				this.Items.Clear();
				this.Items.Add("(none)");
				Initialize();
			} 
			catch (Exception ex) 
			{
				theOdbcManager.Instance.ErrorLog(ex.ToString());
			}
		}

		private void Initialize() 
		{
			foreach (SensorInfo sensor in theSensorTable.Instance.Values) 
			{
				this.Items.Add(sensor.m_name);
			}
		}
	}	// class ChartComboBox
	
}
