package net.tinyos.surge.PacketAnalyzer;

import net.tinyos.surge.*;
import net.tinyos.surge.event.*;
import net.tinyos.message.*;
import net.tinyos.surge.util.*;
import java.util.*;
import java.lang.*;
import java.text.*;
import javax.swing.*;
import net.tinyos.surge.Dialog.*;
import java.awt.*;
import net.tinyos.surge.messages.*;

public class CricketsAnalyzer extends PacketAnalyzer
{
  protected static Hashtable proprietaryNodeInfo;
  protected static TwoKeyHashtable proprietaryEdgeInfo;
  
  public CricketsAnalyzer() {
    super();
    if(MainClass.getMoteIF() != null) 
      MainClass.getMoteIF().registerListener(new SurgeDemoMsg(), this);

    proprietaryNodeInfo = new Hashtable();
    proprietaryEdgeInfo = new TwoKeyHashtable();

    MainClass.objectMaintainer.AddEdgeEventListener(this);
    MainClass.objectMaintainer.AddNodeEventListener(this);
    AnalyzerDisplayEnable();
    
    new Thread(new DecayThread()).start();
  }

  public void messageReceived(int addr, Message m) {
    if(m.amType() == SurgeDemoMsg.AM_TYPE){
      MultihopMsg msg = new MultihopMsg(m.dataGet());
      this.PacketReceived(msg);
    }
  }
  
  public void PacketReceived(MultihopMsg msg) {
    Integer currentNodeNumber = new Integer(msg.get_originaddr());
    NodeInfo currentNodeInfo;   
    if( (currentNodeInfo = (NodeInfo)proprietaryNodeInfo.get(currentNodeNumber)) != null) {
      currentNodeInfo.update(msg);
    }
  }

  public synchronized void NodeCreated(NodeEvent e) {
    Integer newNodeNumber = e.GetNodeNumber();
    proprietaryNodeInfo.put(newNodeNumber, new NodeInfo(newNodeNumber));
  }
  
  public synchronized void NodeDeleted(NodeEvent e) {
    Integer deletedNodeNumber = e.GetNodeNumber();
    proprietaryNodeInfo.remove(deletedNodeNumber);
  }


  public void PaintScreenBefore(Graphics g) {
    Dimension d = MainClass.mainFrame.GetGraphDisplayPanel().getSize();

    g.setColor(Color.red);
    g.setFont(new Font("Helvetica", Font.PLAIN, 48));

    NodeInfo nodeInfo;
    int goodNodes = 0, totalNodes = 0;
    for(Enumeration nodes = proprietaryNodeInfo.elements();
	nodes.hasMoreElements();) {
      
      nodeInfo = (NodeInfo) nodes.nextElement();
      
      if (nodeInfo.goodRound) {
	goodNodes++;
      }
      if (nodeInfo.nodeNumber.intValue() != 0) 
	totalNodes++;
    }

    if (totalNodes > 0) {
      g.drawString("" + 
		   (int)((double)goodNodes/totalNodes*100.0) + "%",
		   10,48);
    } else {
      g.drawString("No Data",
		   10,48);
    }    
  }

  public void PaintNode(Integer pNodeNumber, 
			int x1, int y1, int x2, int y2, Graphics g) {
      NodeInfo nodeInfo = (NodeInfo)proprietaryNodeInfo.get(pNodeNumber);
      if(nodeInfo==null) return;
      
      if (nodeInfo.active) {
	g.setColor(Color.red);
	g.drawOval(x1, y1, x2-x1, y2-y1);
	g.drawOval(x1+3, y1+3, x2-x1-6, y2-y1-6);
      }
      
      if (nodeInfo.goodRound) {
	g.setColor(Color.green);
	g.drawOval(x1-3, y1-3, x2-x1+6, y2-y1+6);
      }

      g.setColor(MainFrame.labelColor);
      g.setFont(MainFrame.bigFont);
      String s = nodeInfo.getInfoString();
      g.drawString(s, (x1+x2)/2, y2-(y2-y1)/4 + 20);
  }

  private class NodeInfo
  {
    public Integer nodeNumber;
    public boolean active;
    public boolean goodRound;

    public int msgCount;
    public int lastSeqNo;

    public long lastTime;
    public long lastGoodTime;

    private int SAMPLE_PERIOD = 4096;

    public NodeInfo(Integer nodeNum) {
      nodeNumber = nodeNum;
      msgCount = 0;
    }

    public void update(MultihopMsg msg) {
      SurgeDemoMsg sMsg = new SurgeDemoMsg(msg.dataGet(), msg.offset_data(0));
      
      long curtime = System.currentTimeMillis();

      active = true;
      lastTime = curtime;

      msgCount++;
      lastSeqNo = (int)sMsg.get_seq_no();

      if (sMsg.get_goodRound() == 1) {
	goodRound = true;
	lastGoodTime = curtime;
      } else {
	goodRound = false;
      }
    }

    public void decay() {

      long curtime = System.currentTimeMillis();

      if (goodRound && 
	  (curtime-lastGoodTime >= (SAMPLE_PERIOD*2)))
      { goodRound = false; }
      
      if (active && 
	  (curtime-lastTime >= (SAMPLE_PERIOD/4))) 
      { active = false; }
    }

    public String getInfoString() { 
      return "" + msgCount + " msgs";
    }
  }

  private class DecayThread extends Thread 
  {
    private int DECAY_THREAD_RATE = 512;

    public void run() {
      while (true) {
	try {
	  Thread.currentThread().sleep(DECAY_THREAD_RATE);
	  Enumeration e = proprietaryNodeInfo.elements();
	  while (e.hasMoreElements()) {
	    NodeInfo ni = (NodeInfo)e.nextElement();
	    ni.decay();
	  }
	} catch (Exception e) { /* Ignore */ } 
      }
    }
  }
}
