// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
package net.tinyos.tinydb.topology.Dialog;


import java.awt.*;
import javax.swing.*;
import net.tinyos.tinydb.topology.*;

/**
 * A basic implementation of the JDialog class.
 */
public class JAboutDialog extends javax.swing.JDialog  
{
	public JAboutDialog(Frame parentFrame)
	{
		super(parentFrame);
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setTitle("net.tinyos.tinydb.topology");
		setModal(true);
		getContentPane().setLayout(new GridBagLayout());
		setSize(248,94);
		setVisible(false);
		okButton.setText("OK");
		okButton.setActionCommand("OK");
		okButton.setOpaque(false);
		okButton.setMnemonic((int)'O');
		getContentPane().add(okButton, new com.symantec.itools.awt.GridBagConstraintsD(2,1,1,1,0.0,0.0,java.awt.GridBagConstraints.CENTER,java.awt.GridBagConstraints.NONE,new Insets(0,0,10,0),0,0));
		okButton.setBounds(98,59,51,25);
		aboutLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		aboutLabel.setText("net.tinyos.tinydb.topology 2.0.  Kamin Whitehouse kamin@cs.berkeley.edu");
		getContentPane().add(aboutLabel, new com.symantec.itools.awt.GridBagConstraintsD(0,0,3,1,1.0,1.0,java.awt.GridBagConstraints.CENTER,java.awt.GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		aboutLabel.setBounds(0,0,248,59);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);
		//}}
	}

	public void setVisible(boolean b)
	{
	    if (b)
	    {
    		Rectangle bounds = (getParent()).getBounds();
    		Dimension size = getSize();
    		setLocation(bounds.x + (bounds.width - size.width)/2,
    			        bounds.y + (bounds.height - size.height)/2);
	    }

		super.setVisible(b);
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
			return;
		// Adjust components according to the insets
		Insets insets = getInsets();
		setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
		Component components[] = getContentPane().getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets.left, insets.top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

	// Used for addNotify check.
	boolean fComponentsAdjusted = false;

	//{{DECLARE_CONTROLS
	javax.swing.JButton okButton = new javax.swing.JButton();
	javax.swing.JLabel aboutLabel = new javax.swing.JLabel();
	//}}

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == JAboutDialog.this)
				jAboutDialog_windowClosing(event);
		}
	}

	void jAboutDialog_windowClosing(java.awt.event.WindowEvent event)
	{
		// to do: code goes here.
			 
		jAboutDialog_windowClosing_Interaction1(event);
	}

	void jAboutDialog_windowClosing_Interaction1(java.awt.event.WindowEvent event) {
		try {
			// JAboutDialog Hide the JAboutDialog
			this.setVisible(false);
		} 
		catch(Exception e){e.printStackTrace();}
	}
	
	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_actionPerformed(event);
		}
	}

	void okButton_actionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		okButton_actionPerformed_Interaction1(event);
	}

	void okButton_actionPerformed_Interaction1(java.awt.event.ActionEvent event) {
		try {
			// JAboutDialog Hide the JAboutDialog
			this.setVisible(false);
		} 
		catch(Exception e){e.printStackTrace();}
	}
}
