// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 * Authors:		Matt Welsh
 * Date last modified:  9/29/02
 */

/**
 * This interface defines commands for controlling aspects of the 
 * communication layer.
 * @author Matt Welsh
 */
interface CommControl 
{ 
  /** 
   * Set the value of the CRC check flag.
   * If set to 'true', received packets with a CRC field other than '1'
   * are dropped.
   * @return SUCCESS if the CRC check value could be set; FAIL otherwise
   *   (for example, if CRC check is not implemented).
   */
  command result_t setCRCCheck(bool value);

  /**
   * Return the current value of the CRC check flag.
   */
  command bool getCRCCheck();

  /** 
   * Set the value of the promiscuous mode flag.
   * If set to 'true', all received packets are passed to the receiver.
   * If set to 'false', only packets destined for this node (or sent to
   * the broadcast address) are passed up.
   * @return SUCCESS if the promiscuous flag could be set; FAIL otherwise
   *   (for example, if promiscuous mode is not implemented).
   */
  command result_t setPromiscuous(bool value);

  /**
   * Return the current value of the promiscuous mode flag.
   */
  command bool getPromiscuous();
}
