//$Id$
//@author Cory Sharp <cssharp@eecs.berkeley.edu>

module LedsIntensityM
{
  provides interface StdControl;
  provides interface LedsIntensity;
  uses interface Leds;
}
implementation
{
  enum
  {
    NUM_LEDS = 3,
    NUM_INTENSITY = 32,
    RESOLUTION = 128,
  };

  bool m_run;
  int8_t m_intensity[NUM_LEDS];
  int8_t m_accum[NUM_LEDS];
  static const int8_t m_exp[NUM_INTENSITY] = {
    0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 4, 5, 6, 7, 8, 9,
    11, 13, 16, 19, 22, 26, 30, 36, 42, 49, 58, 67, 79, 93, 108, 127,
  };

  task void dimleds()
  {
    if( m_run )
    {
      int i;
      int ledval = 0;
      for( i=NUM_LEDS-1; i>=0; i-- )
      {
	ledval <<= 1;
	if( (m_accum[i] += m_intensity[i]) >= 0 )
	{
	  m_accum[i] -= (RESOLUTION-1);
	  ledval |= 1;
	}
      }
      call Leds.set( ledval );
      post dimleds();
    }
    else
    {
      call Leds.set( 0 );
    }
  }

  command void LedsIntensity.set( uint8_t ledNum, uint8_t intensity )
  {
    if( ledNum < NUM_LEDS )
    {
      intensity >>= 3;
      if( intensity >= (NUM_INTENSITY-1) )
      {
	m_intensity[ledNum] = m_exp[NUM_INTENSITY-1];
	m_accum[ledNum] = 0;
      }
      else
      {
	m_intensity[ledNum] = m_exp[intensity];
	if( m_intensity[ledNum] == 0 )
	  m_accum[ledNum] = -1;
      }
    }
  }

  command result_t StdControl.init()
  {
    int i;
    for( i=0; i<NUM_LEDS; i++ )
    {
      m_intensity[i] = 0;
      m_accum[i] = -1;
    }
    call Leds.init();
    return SUCCESS;
  }

  command result_t StdControl.start()
  {
    m_run = TRUE;
    post dimleds();
    return SUCCESS;
  }

  command result_t StdControl.stop()
  {
    m_run = FALSE;
    return SUCCESS;
  }
}

