
// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 *
 * Authors: Alan Broad, Crossbow
 * Date last modified:  $Revision$
 *
 */

/**
 * Low level hardware access to the CC2420 Rx,Tx fifos
 * @author Alan Broad
 */

module HPLCC2420FIFOM {
  provides {
    interface HPLCC2420FIFO;
  }
}
implementation
{
  norace bool bSpiAvail;                    //true if Spi bus available
  uint8_t* txbuf; uint8_t* rxbuf;
  uint8_t txlength, rxlength; 

  task void signalTXdone() {
    signal HPLCC2420FIFO.TXFIFODone(txlength, txbuf);
  }

  task void signalRXdone() {
    signal HPLCC2420FIFO.RXFIFODone(rxlength, rxbuf);
  }

   /**************************************************************************
   * function: write_tx_fifo                                       
   *   - writes len bytes from *msg  to Tx fifo.
   *   - assumes msg[0] = IEEE pkt message length including 2 FCS bytes
   *   - FCS bytes are not written to TxFifo, they are appended to pkt by CC2420
   *   - so len should equal MSG_DATA_SIZE-2 ???
   **************************************************************************/
  async command result_t HPLCC2420FIFO.writeTXFIFO(uint8_t len, uint8_t *msg) {
     uint8_t i = 0;
     uint8_t *data;
     uint8_t status;

 //   while (!bSpiAvail){};                      //wait for spi bus 

	atomic {
	  bSpiAvail = FALSE;
     // len++;
	  data = msg;
          txbuf = msg;
          txlength = len;
      TOSH_CLR_CC_CS_PIN();                   //enable chip select
	  outp(CC2420_TXFIFO,SPDR);
	  while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
	  status = inp(SPDR);
    //  outp(len, SPDR);
	//  while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
      for (i=0; i <= len-1; i++){ 
        outp(*data,SPDR);
	    data++;
		while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
	  }
	  bSpiAvail = TRUE;
    }
	TOSH_SET_CC_CS_PIN();                       //disable chip select
    post signalTXdone();
    return status;
  }
   
   /**************************************************************************
   * function: read_rx_fifo                                       
   *   - read msg of length len from Rx fifo.
   *   - if msg size > len, return only len bytes
   *   - if msg size < len then return only msg size
   **************************************************************************/
  async command result_t HPLCC2420FIFO.readRXFIFO(uint8_t len, uint8_t *msg) {
     uint8_t status,datasize,i;

 //   while (!bSpiAvail){};                      //wait for spi bus 

	atomic {
	  bSpiAvail = FALSE;
	  TOSH_CLR_CC_CS_PIN();                   //enable chip select
	  outp(CC2420_RXFIFO | 0x40 ,SPDR);       //output Rxfifo address
	  while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
	  status = inp(SPDR);
      outp(0, SPDR);
	  while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
	  datasize = inp(SPDR);
	  msg[0] = datasize;
	  if (datasize < len) len = datasize;  //1st byte back is msg size
          rxlength = len;
          rxbuf = msg;
	  
	  for (i=1; i <= len ; i++){ 
        outp(0,SPDR);
	    while (!(inp(SPSR) & 0x80)){};          //wait for spi xfr to complete
	    msg[i] = inp(SPDR);
	  }
  
	  bSpiAvail = TRUE;
    }
	TOSH_SET_CC_CS_PIN();                       //disable chip select
        post signalRXdone();
      return status;
  }
}



