//$Id$
//@author Cory Sharp <cssharp@eecs.berkeley.edu>

includes MSP430Timer;

interface MSP430Compare
{
  async command MSP430CompareControl_t getControl();
  async command bool isInterruptPending();
  async command void clearPendingInterrupt();

  async command void setControl( MSP430CompareControl_t control );
  async command void setControlAsTimer();

  async command void enableEvents();
  async command void disableEvents();

  async command uint16_t getEvent();
  async command void setEvent( uint16_t time );
  async command void setEventFromPrev( uint16_t delta );
  async command void setEventFromNow( uint16_t delta );

  async event void fired();

}

