#ifndef MSP430REFVOLT_H
#define MSP430REFVOLT_H

// time to wait until we try again to reset REFON (in ms)
#define SWITCH_OFF_TRY_MS 5

typedef enum
{
  REFERENCE_1_5V,     // vref  1.5 V
  REFERENCE_2_5V,     // vref  2.5 V
  REFERENCE_UNSTABLE  // vref unstable or generator off
} RefVolt_t;

typedef enum
{
  INTERNAL_REFERENCE_STABLE,             // vref is stable
  INTERNAL_REFERENCE_UNSTABLE,           // vref is unstable
  INTERNAL_REFERENCE_OFF,                // generator should is switched off
  INTERNAL_REFERENCE_KILLED              // generator should be switched off
} RefVoltState_t;

#endif
