//$Id$
// @author Joe Polastre

module TimerJiffyAsyncM
{
  provides interface StdControl;
  provides interface TimerJiffyAsync;
  uses interface MSP430Compare as Alarm;
}
implementation
{
  uint32_t jiffy;
  bool bSet;

  command result_t StdControl.init()
  {
    call Alarm.setControlAsTimer();
    return SUCCESS;
  }

  command result_t StdControl.start()
  {
    atomic bSet = FALSE;
    return SUCCESS;
  }

  command result_t StdControl.stop()
  {
    atomic {
      bSet = FALSE;
      call Alarm.disableEvents();
    }
    return SUCCESS;
  }

  async event void Alarm.fired()
  {
    if (jiffy < 0xFFFF) {
      call Alarm.disableEvents();
      bSet = FALSE;
      signal TimerJiffyAsync.fired();
    }
    else {
      jiffy = jiffy >> 16;
      call Alarm.setEventFromNow( jiffy );
      call Alarm.clearPendingInterrupt();
      call Alarm.enableEvents();
    }
  }

  async command result_t TimerJiffyAsync.setOneShot( uint32_t _jiffy )
  {
    atomic {
      jiffy = _jiffy;
      bSet = TRUE;
    }
    if (_jiffy > 0xFFFF) {
      call Alarm.setEventFromNow( 0xFFFF );
    }
    else {
      call Alarm.setEventFromNow( _jiffy );
    }
    call Alarm.clearPendingInterrupt();
    call Alarm.enableEvents();
    return SUCCESS;
  }

  async command bool TimerJiffyAsync.isSet( )
  {
    return bSet;
  }

  async command result_t TimerJiffyAsync.stop()
  {
    atomic { 
      bSet = FALSE;
      call Alarm.disableEvents();
    }
    return SUCCESS;
  }
}

