#ifndef _H_hardware_h
#define _H_hardware_h

#include "msp430hardware.h"

#include "CC2420Const.h"
#include "AM.h"

// LEDs
TOSH_ASSIGN_PIN(RED_LED, 5, 4);
TOSH_ASSIGN_PIN(GREEN_LED, 5, 5);
TOSH_ASSIGN_PIN(YELLOW_LED, 5, 6);

// CC2420 RADIO #defines
TOSH_ASSIGN_PIN(RADIO_CSN, 4, 2);
TOSH_ASSIGN_PIN(RADIO_VREF, 4, 5);
TOSH_ASSIGN_PIN(RADIO_RESET, 4, 6);
TOSH_ASSIGN_PIN(RADIO_FIFOP, 1, 0);
TOSH_ASSIGN_PIN(RADIO_SFD, 4, 1);
TOSH_ASSIGN_PIN(RADIO_GIO0, 1, 3);
TOSH_ASSIGN_PIN(RADIO_FIFO, 1, 3);
TOSH_ASSIGN_PIN(RADIO_GIO1, 1, 4);
TOSH_ASSIGN_PIN(RADIO_CCA, 1, 4);

TOSH_ASSIGN_PIN(CC_FIFO, 1, 3);
TOSH_ASSIGN_PIN(CC_SFD, 4, 1);
TOSH_ASSIGN_PIN(CC_VREN, 4, 5);
TOSH_ASSIGN_PIN(CC_RSTN, 4, 6);

// UART pins
TOSH_ASSIGN_PIN(SOMI0, 3, 2);
TOSH_ASSIGN_PIN(SIMO0, 3, 1);
TOSH_ASSIGN_PIN(UCLK0, 3, 3);
TOSH_ASSIGN_PIN(UTXD0, 3, 4);
TOSH_ASSIGN_PIN(URXD0, 3, 5);
TOSH_ASSIGN_PIN(UTXD1, 3, 6);
TOSH_ASSIGN_PIN(URXD1, 3, 7);
TOSH_ASSIGN_PIN(UCLK1, 5, 3);
TOSH_ASSIGN_PIN(SOMI1, 5, 2);
TOSH_ASSIGN_PIN(SIMO1, 5, 1);

#define TOSH_CC_FIFOP_BIT 0x01

static inline bool isFIFOP() {
  return (P1IFG & TOSH_CC_FIFOP_BIT);
}

static inline void TOSH_CLR_RADIO_FIFOP_INT() {
  P1IFG &= ~TOSH_CC_FIFOP_BIT;
}

static inline void TOSH_SET_RADIO_FIFOP_INT() {
  P1IFG |= TOSH_CC_FIFOP_BIT;
}

static inline void ENABLE_RADIO_FIFOP_INT() { 
  // disable interrupt during processing
  P1IE &= ~0x01; 
  // set high>low interrupt
  P1IES |= 0x01; 
  // clear interrupt flag
  P1IFG &= ~0x01; 
  // enable interrupt
  P1IE |= 0x01; 
}

static inline void DISABLE_RADIO_FIFOP_INT() { 
  // disable interrupt
  P1IE &= ~0x01; 
}

// ADC
TOSH_ASSIGN_PIN(ADC0, 6, 0);
TOSH_ASSIGN_PIN(ADC1, 6, 1);
TOSH_ASSIGN_PIN(ADC2, 6, 2);
TOSH_ASSIGN_PIN(ADC3, 6, 3);

// HUMIDITY
TOSH_ASSIGN_PIN(HUM_SDA, 1, 5);
TOSH_ASSIGN_PIN(HUM_SCL, 1, 6);
TOSH_ASSIGN_PIN(HUM_PWR, 1, 7);

// FLASH
TOSH_ASSIGN_PIN(FLASH_PWR, 4, 3);
TOSH_ASSIGN_PIN(FLASH_CS, 4, 4);

// PROGRAMMING PINS (tri-state)
//TOSH_ASSIGN_PIN(TCK, );
TOSH_ASSIGN_PIN(PROG_RX, 1, 1);
TOSH_ASSIGN_PIN(PROG_TX, 2, 2);

void TOSH_SET_PIN_DIRECTIONS(void)
{
  //LEDS
  TOSH_SET_RED_LED_PIN();
  TOSH_SET_GREEN_LED_PIN();
  TOSH_SET_YELLOW_LED_PIN();
  TOSH_MAKE_RED_LED_OUTPUT();
  TOSH_MAKE_GREEN_LED_OUTPUT();
  TOSH_MAKE_YELLOW_LED_OUTPUT();

  //RADIO PINS
  //CC2420 pins
  TOSH_SET_SOMI1_PIN();
  TOSH_MAKE_SOMI1_INPUT();
  //TOSH_MAKE_SIMO1_OUTPUT();
  //TOSH_MAKE_UCLK1_OUTPUT();
  TOSH_SET_RADIO_RESET_PIN();
  TOSH_MAKE_RADIO_RESET_OUTPUT();
  TOSH_CLR_RADIO_VREF_PIN();
  TOSH_MAKE_RADIO_VREF_OUTPUT();
  TOSH_SET_RADIO_CSN_PIN();
  TOSH_MAKE_RADIO_CSN_OUTPUT();
  TOSH_MAKE_RADIO_FIFOP_INPUT();
  TOSH_MAKE_RADIO_GIO0_INPUT();
  TOSH_MAKE_RADIO_SFD_INPUT();
  TOSH_MAKE_RADIO_GIO1_INPUT();

  //PROG PINS
  TOSH_MAKE_PROG_RX_INPUT();
  TOSH_MAKE_PROG_TX_INPUT();

  //FLASH PINS
  TOSH_MAKE_FLASH_PWR_OUTPUT();
  TOSH_CLR_FLASH_PWR_PIN();
  TOSH_MAKE_FLASH_CS_OUTPUT();
  TOSH_SET_FLASH_CS_PIN();

  //HUMIDITY PINS
  TOSH_MAKE_HUM_SCL_OUTPUT();
  TOSH_MAKE_HUM_SDA_OUTPUT();
  //  TOSH_MAKE_HUM_PWR_OUTPUT();
  TOSH_CLR_HUM_SCL_PIN();
  TOSH_CLR_HUM_SDA_PIN();
  //  TOSH_CLR_HUM_PWR_PIN();
}

#endif//_H_hardware_h

