/* @(#)MatlabClock.java
 *
 * "Copyright (c) 2001 and The Regents of the University 
 * of California.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * $\Id$
 */

/**
 * 
 *
 * @author <a href="mailto:kamin@cs.berkeley.edu">Kamin Whitehouse</a>
 */

package com.mathworks.timer;

import javax.swing.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.util.*;
import java.lang.System.*;

public class TimerGui extends JFrame implements AdjustmentListener, ActionListener
{
    //constructors
    TimerTask timerTask; //parent object

    static final String START = "|>";
    static final String STOP = "||";
    static int numTimers = 1;
    static TimerGui lastTimerGui;
    JButton startButton = null;
    JButton stopButton = null;
    JLabel sleepLabel = null;
    JTextField sleepValue = null;
    JLabel units = null;
    JScrollBar sleepSlider = null;

    public TimerGui(TimerTask timer)
    {
	super("Timer" + String.valueOf(numTimers));
	numTimers+=1;
	timerTask=timer;
	createGUI();
    }
    
    static private Point getNewLocation(){
	if( (lastTimerGui==null) || (!lastTimerGui.isShowing())){
	    return new Point(0,0);
	}
	else{
	    Point p = lastTimerGui.getLocationOnScreen();
	    p.y += lastTimerGui.getSize().height;
	    return p;
	}
    }

    private void createGUI()
    {
	this.setSize(250, 150);
	this.setLocation(getNewLocation());
	lastTimerGui = this;
	startButton = new JButton(START);
	startButton.addActionListener(this);
	stopButton = new JButton(STOP);
	stopButton.setEnabled(false);
	stopButton.addActionListener(this);
	sleepLabel = new JLabel("   Frequency   ");
	units = new JLabel(" milliseconds      ");
	sleepValue = new JTextField(String.valueOf(1000));
	sleepValue.setActionCommand("textField");
	sleepValue.addActionListener(this);
	sleepValue.setColumns(8);
	sleepSlider = new JScrollBar(Scrollbar.HORIZONTAL,1000, 200, 10, 4200);
	sleepSlider.addAdjustmentListener(this);

	Panel labelPanel = new Panel();
	labelPanel.add(startButton);
	labelPanel.add(stopButton);
	labelPanel.add(sleepLabel);
	labelPanel.add(sleepValue);
	labelPanel.add(units);

	Panel sleepPanel = new Panel();
	sleepPanel.setLayout(new BorderLayout());
	sleepPanel.add("North", labelPanel);
	sleepPanel.add("South", sleepSlider);

	getContentPane().add(sleepPanel);
	
	this.addWindowListener(new WindowAdapter() { 
		public void windowClosing(WindowEvent e){closeWindow();}
	    });
	this.pack();
	this.show();
    }

    public void closeWindow(){
	this.dispose();
    }

    public void setRate(double Rate)
    {
	sleepSlider.setValue((int)Rate);
	sleepValue.setText(String.valueOf(Rate));
    }


    public void start( )
    {
	stopButton.setEnabled(true);
    }

    public void stop( )
    {
	stopButton.setEnabled(false);
    }


    public void actionPerformed(ActionEvent e)
    {
	try{
	    Object source = e.getSource();
	    if (e.getActionCommand().equals("textField")) {
		if(timerTask.isRunning()>0){
		    timerTask.stopFromGui();
		    timerTask.setRateFromGui(Double.parseDouble(sleepValue.getText()));
		    timerTask.startFromGui();
		}
		else{
		    timerTask.setRateFromGui(Double.parseDouble(sleepValue.getText()));
		}
		sleepSlider.setValue(Integer.parseInt(sleepValue.getText()));
	    }
	    else if (((JButton)source).getLabel()==START) {
		//		if(timerTask!=null)
		timerTask.startFromGui();
		stopButton.setEnabled(true);
	    } else if (((JButton)source).getLabel()==STOP) {
		//		if(timerTask!=null)
		timerTask.stopFromGui();
		stopButton.setEnabled(false);
	    }
	}catch(Exception f){System.out.println(f.getMessage());}
	return;
    }

    public void adjustmentValueChanged(AdjustmentEvent e)
    {
	Object source = e.getSource();
	sleepValue.setText(String.valueOf(sleepSlider.getValue()));
	try{
	    if(timerTask.isRunning()>0){
		timerTask.stopFromGui();
		timerTask.setRateFromGui(Double.parseDouble(sleepValue.getText())/1000);
		timerTask.setStartDelay(Double.parseDouble(sleepValue.getText())/1000);
		timerTask.startFromGui();
	    }
	    else{
		timerTask.setRateFromGui(Double.parseDouble(sleepValue.getText())/1000);
	    }
	}catch(Exception e2){System.out.println(e2.getMessage());}
	return;
    }
    
    protected void finalize()
    {
	this.dispose();
    }
}








