/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class Comment
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Comment.java,v $ $Revision: 1.26 $ $Date: 2003/04/06 02:00:44 $ $Name: jdom_1_0_b9_rc2 $";
    protected String text;
    protected Object parent;

    protected Comment() {
    }

    public Comment(String text) {
        this.setText(text);
    }

    public Element getParent() {
        if (this.parent instanceof Element) {
            return (Element)this.parent;
        }
        return null;
    }

    protected Comment setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Comment detach() {
        if (this.parent instanceof Element) {
            ((Element)this.parent).removeContent(this);
        } else if (this.parent instanceof Document) {
            ((Document)this.parent).removeContent(this);
        }
        return this;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    protected Comment setDocument(Document document) {
        this.parent = document;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Comment setText(String text) {
        String reason = Verifier.checkCommentData(text);
        if (reason != null) {
            throw new IllegalDataException(text, "comment", reason);
        }
        this.text = text;
        return this;
    }

    public String toString() {
        return "[Comment: " + new XMLOutputter().outputString(this) + "]";
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Comment comment = null;
        try {
            comment = (Comment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        comment.parent = null;
        return comment;
    }
}

