/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotApplet
extends JApplet {
    private transient PlotBox _plot;

    protected void _read(InputStream in) throws IOException {
        this.plot().read(in);
    }

    protected void _setPlotSize(int appletWidth, int appletHeight) {
        this.plot().setSize(appletWidth, appletHeight);
    }

    public String getAppletInfo() {
        return "PlotApplet 5.1p2: A data plotter.\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n Christopher Hylands, cxh@eecs.berkeley.edu\n($Id: PlotApplet.java,v 1.47 2001/01/26 21:02:15 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"height", "integer", "100"}, {"width", "integer", "100"}};
        return pinfo;
    }

    public void init() {
        block7: {
            super.init();
            if (this._plot == null) {
                this._plot = this.newPlot();
            }
            this.getContentPane().add((Component)this.plot(), "North");
            String widthspec = this.getParameter("width");
            int width = widthspec != null ? Integer.parseInt(widthspec) : 400;
            String heightspec = this.getParameter("height");
            int height = heightspec != null ? Integer.parseInt(heightspec) : 400;
            this._setPlotSize(width, height);
            this.plot().setButtons(true);
            Color background = Color.white;
            String colorspec = this.getParameter("background");
            if (colorspec != null) {
                background = PlotBox.getColorByName(colorspec);
            }
            this.setBackground(background);
            this.plot().setBackground(background);
            this.getContentPane().setBackground(background);
            Color foreground = Color.black;
            colorspec = this.getParameter("foreground");
            if (colorspec != null) {
                foreground = PlotBox.getColorByName(colorspec);
            }
            this.setForeground(foreground);
            this.plot().setForeground(foreground);
            this.plot().setVisible(true);
            String dataurlspec = this.getParameter("dataurl");
            if (dataurlspec == null) break block7;
            try {
                this.showStatus("Reading data");
                URL dataurl = new URL(this.getDocumentBase(), dataurlspec);
                InputStream in = dataurl.openStream();
                this._read(in);
                this.showStatus("Done");
            }
            catch (MalformedURLException e) {
                System.err.println(e.toString());
            }
            catch (FileNotFoundException e) {
                System.err.println("PlotApplet: file not found: " + e);
            }
            catch (IOException e) {
                System.err.println("PlotApplet: error reading input file: " + e);
            }
        }
    }

    public PlotBox newPlot() {
        return new Plot();
    }

    public PlotBox plot() {
        return this._plot;
    }
}

