/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha;

import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeLoaderUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class OyoahaMetalTheme
extends DefaultMetalTheme {
    protected String name = "Oyoaha Custom Theme";
    protected ColorUIResource primary1;
    protected ColorUIResource primary2;
    protected ColorUIResource primary3;
    protected ColorUIResource secondary1;
    protected ColorUIResource secondary2;
    protected ColorUIResource secondary3;
    protected ColorUIResource black;
    protected ColorUIResource white;
    protected FontUIResource controlFont;
    protected FontUIResource systemFont;
    protected FontUIResource userFont;
    protected FontUIResource smallFont;

    public OyoahaMetalTheme(File file) {
        this.initColors();
        try {
            this.loadProperties(new FileInputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OyoahaMetalTheme(URL uRL) {
        this.initColors();
        try {
            this.loadProperties(uRL.openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OyoahaMetalTheme(InputStream inputStream) {
        this.initColors();
        try {
            this.loadProperties(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    protected void loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = properties.get("name");
        if (object != null) {
            this.name = object.toString();
        }
        Object object2 = null;
        object2 = properties.get("primary1");
        if (object2 != null) {
            this.primary1 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("primary2")) != null) {
            this.primary2 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("primary3")) != null) {
            this.primary3 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("secondary1")) != null) {
            this.secondary1 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("secondary2")) != null) {
            this.secondary2 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("secondary3")) != null) {
            this.secondary3 = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("black")) != null) {
            this.black = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("white")) != null) {
            this.white = OyoahaThemeLoaderUtilities.readColor(object2.toString());
        }
        if ((object2 = properties.get("controlFont")) != null) {
            this.controlFont = OyoahaThemeLoaderUtilities.readFont(object2.toString());
        }
        if ((object2 = properties.get("systemFont")) != null) {
            this.systemFont = OyoahaThemeLoaderUtilities.readFont(object2.toString());
        }
        if ((object2 = properties.get("userFont")) != null) {
            this.userFont = OyoahaThemeLoaderUtilities.readFont(object2.toString());
        }
        if ((object2 = properties.get("smallFont")) != null) {
            this.smallFont = OyoahaThemeLoaderUtilities.readFont(object2.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public FontUIResource getControlTextFont() {
        return this.controlFont != null ? this.controlFont : super.getControlTextFont();
    }

    public FontUIResource getSystemTextFont() {
        return this.systemFont != null ? this.systemFont : super.getSystemTextFont();
    }

    public FontUIResource getUserTextFont() {
        return this.userFont != null ? this.userFont : super.getUserTextFont();
    }

    public FontUIResource getMenuTextFont() {
        return this.controlFont != null ? this.controlFont : super.getControlTextFont();
    }

    public FontUIResource getWindowTitleFont() {
        return this.controlFont != null ? this.controlFont : super.getControlTextFont();
    }

    public FontUIResource getSubTextFont() {
        return this.smallFont != null ? this.smallFont : super.getSubTextFont();
    }

    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    protected ColorUIResource getBlack() {
        return this.black;
    }

    protected ColorUIResource getWhite() {
        return this.white;
    }
}

