/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaBumpObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaButtonBorderLike;
import com.oyoaha.swing.plaf.oyoaha.OyoahaButtonLikeComponent;
import com.oyoaha.swing.plaf.oyoaha.OyoahaFlash;
import com.oyoaha.swing.plaf.oyoaha.OyoahaImageLoader;
import com.oyoaha.swing.plaf.oyoaha.OyoahaJava1PaintUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaJava1SoundUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaJava2PaintUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaJava2SoundUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaPaintUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaRolloverListener;
import com.oyoaha.swing.plaf.oyoaha.OyoahaSoundUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeScheme;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeChanged;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUpdater;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaColorPool;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaDefaultColorPool;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaListCellRenderer;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OyoahaUtilities {
    public static final int UNSELECTED_ENABLED = 1000;
    public static final int UNSELECTED_PRESSED = 1001;
    public static final int UNSELECTED_ROLLOVER = 1002;
    public static final int UNSELECTED_DISABLED = 1003;
    public static final int SELECTED_ENABLED = 1004;
    public static final int SELECTED_PRESSED = 1005;
    public static final int SELECTED_ROLLOVER = 1006;
    public static final int SELECTED_DISABLED = 1007;
    public static final int UNVISIBLE = 1008;
    public static final int FOCUS = 100;
    public static final int WHITE = 101;
    public static final int BLACK = 102;
    public static final int GRAY = 103;
    private static OyoahaPaintUtilities paint;
    private static OyoahaSoundUtilities sound;
    private static OyoahaLookAndFeel oyoahaLookAndFeel;
    private static OyoahaImageLoader loader;
    protected static OyoahaColorPool pool;
    private static OyoahaRolloverListener mouseListener;
    private static OyoahaUpdater animation;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int TOPLEFT = 2;
    public static final int LEFT = 3;
    public static final int LEFTBOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BOTTOMRIGHT = 6;
    public static final int RIGHT = 7;
    public static final int RIGHTTOP = 8;

    public static final boolean isVersion(String string) {
        String string2 = System.getProperty("java.version");
        if (string2 != null) {
            return string2.compareTo(string) >= 0;
        }
        return false;
    }

    public static final void initialize(OyoahaLookAndFeel oyoahaLookAndFeel) {
        OyoahaUtilities.uninitialize(OyoahaUtilities.oyoahaLookAndFeel);
        OyoahaUtilities.oyoahaLookAndFeel = oyoahaLookAndFeel;
        loader = new OyoahaImageLoader();
        pool = null;
        boolean bl = OyoahaUtilities.isVersion("1.2");
        paint = !bl ? new OyoahaJava1PaintUtilities() : new OyoahaJava2PaintUtilities();
        sound = null;
        paint.initialize();
    }

    public static final void uninitialize(OyoahaLookAndFeel oyoahaLookAndFeel) {
        if (OyoahaUtilities.oyoahaLookAndFeel == null || OyoahaUtilities.oyoahaLookAndFeel != oyoahaLookAndFeel) {
            return;
        }
        if (animation != null) {
            animation.stop();
        }
        if (paint != null) {
            paint.uninitialize();
        }
        if (sound != null) {
            sound.uninitialize();
        }
    }

    public static final OyoahaRolloverListener getOyoahaRolloverListener() {
        if (mouseListener == null) {
            mouseListener = new OyoahaRolloverListener();
        }
        return mouseListener;
    }

    public static final void installRolloverListener(Component component) {
        if (OyoahaUtilities.isRolloverEnabled(component)) {
            if (component instanceof AbstractButton && ((AbstractButton)component).isRolloverEnabled()) {
                return;
            }
            component.addMouseListener(OyoahaUtilities.getOyoahaRolloverListener());
        }
    }

    public static final void uninstallRolloverListener(Component component) {
        if (mouseListener != null) {
            component.removeMouseListener(mouseListener);
        }
    }

    public static final int getStatus(Component component) {
        int n = 1000;
        if (component instanceof OyoahaListCellRenderer) {
            n = ((OyoahaListCellRenderer)component).getStatus();
        } else if (component instanceof OyoahaTreeCellRenderer) {
            n = ((OyoahaTreeCellRenderer)component).getStatus();
        } else if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Container container = abstractButton.getParent();
            if (abstractButton.isEnabled()) {
                if (!(abstractButton instanceof MenuElement)) {
                    if (buttonModel.isSelected()) {
                        n = buttonModel.isArmed() && buttonModel.isPressed() ? 1005 : (buttonModel.isRollover() || OyoahaUtilities.isRollover(component) ? 1006 : 1004);
                    } else if (buttonModel.isArmed() && buttonModel.isPressed()) {
                        n = 1001;
                    } else if (buttonModel.isRollover() || OyoahaUtilities.isRollover(component)) {
                        n = 1002;
                    }
                } else if (buttonModel.isSelected()) {
                    n = OyoahaUtilities.isPressed(component) || buttonModel.isPressed() ? 1005 : (buttonModel.isArmed() || buttonModel.isRollover() || OyoahaUtilities.isRollover(component) ? 1006 : 1004);
                } else if (OyoahaUtilities.isPressed(component) || buttonModel.isPressed()) {
                    n = 1001;
                } else if (buttonModel.isArmed() || buttonModel.isRollover() || OyoahaUtilities.isRollover(component)) {
                    n = 1002;
                }
            } else {
                n = buttonModel.isSelected() ? 1007 : 1003;
            }
        } else if (component instanceof JInternalFrame) {
            if (!component.isEnabled()) {
                n = ((JInternalFrame)component).isSelected() ? 1007 : 1003;
            } else if (((JInternalFrame)component).isSelected()) {
                n = OyoahaUtilities.isPressed(component) ? 1005 : (OyoahaUtilities.isRollover(component) ? 1006 : 1004);
            } else if (OyoahaUtilities.isPressed(component)) {
                n = 1001;
            } else if (OyoahaUtilities.isRollover(component)) {
                n = 1002;
            }
        } else if (!component.isEnabled()) {
            n = 1003;
        } else if (OyoahaUtilities.isPressed(component)) {
            n = 1001;
        } else if (OyoahaUtilities.isRollover(component)) {
            n = 1002;
        }
        return n;
    }

    public static final boolean isPressed(Component component) {
        if (mouseListener != null) {
            return mouseListener.isPressed(component);
        }
        return false;
    }

    public static final boolean isRollover(Component component) {
        if (mouseListener != null) {
            return mouseListener.isRollover(component);
        }
        return false;
    }

    public static final Component getPressed() {
        if (mouseListener != null) {
            return mouseListener.getPressed();
        }
        return null;
    }

    public static final Component getRollover() {
        if (mouseListener != null) {
            return mouseListener.getRollover();
        }
        return null;
    }

    public static void playStartClick() {
        if (sound != null) {
            sound.playStartClick();
        }
    }

    public static void playStopClick() {
        if (sound != null) {
            sound.playStopClick();
        }
    }

    public static void initializeAnimation(boolean bl, boolean bl2) {
        animation = new OyoahaUpdater(bl, bl2);
        animation.start();
    }

    public static void initializeSound(String string, String string2) {
        if (string == null && string2 == null) {
            return;
        }
        sound = !OyoahaUtilities.isVersion("1.3") ? new OyoahaJava1SoundUtilities() : new OyoahaJava2SoundUtilities();
        sound.initialize(string, string2);
    }

    public static final boolean hasFocus(Component component) {
        return paint.hasFocus(component);
    }

    public static final boolean isDefaultButton(Component component) {
        return paint.isDefaultButton(component);
    }

    public static final boolean isLeftToRight(Component component) {
        return paint.isLeftToRight(component);
    }

    public static final Rectangle getFullRect(Component component) {
        Rectangle rectangle = component.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    public static final Rectangle getViewRect2(Component component) {
        Rectangle rectangle = OyoahaUtilities.getFullRect(component);
        if (component instanceof JComponent) {
            Insets insets = ((Container)component).getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        } else if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
        return rectangle;
    }

    public static final Rectangle getViewRect(Component component) {
        Rectangle rectangle = OyoahaUtilities.getFullRect(component);
        Insets insets = OyoahaUtilities.getRealInsets(component);
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        } else if (component instanceof JComponent) {
            Border border = ((JComponent)component).getBorder();
            if (border instanceof OyoahaButtonBorderLike) {
                OyoahaButtonBorderLike oyoahaButtonBorderLike = (OyoahaButtonBorderLike)((Object)border);
                rectangle.x += oyoahaButtonBorderLike.getLeftInsets();
                rectangle.y += oyoahaButtonBorderLike.getTopInsets();
                rectangle.width -= oyoahaButtonBorderLike.getRightInsets() + rectangle.x;
                rectangle.height -= oyoahaButtonBorderLike.getBottomInsets() + rectangle.y;
            } else {
                insets = ((Container)component).getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.right + rectangle.x;
                rectangle.height -= insets.bottom + rectangle.y;
            }
        } else if (component instanceof Container) {
            insets = ((Container)component).getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
        return rectangle;
    }

    public static final Insets getRealInsets(Component component) {
        return OyoahaUtilities.getRealInsets(OyoahaUtilities.getUIClassID(component));
    }

    public static final Insets getRealInsets(String string) {
        Object object = UIManager.get(string + ".realInsets");
        if (object != null && object instanceof Insets) {
            return (Insets)object;
        }
        return null;
    }

    public static final Point getAPosition(Component component) {
        return paint.getAPosition(component);
    }

    public static final boolean intersects(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return paint.intersects(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static final Shape normalizeClip(Graphics graphics, int n, int n2, int n3, int n4) {
        return paint.normalizeClip(graphics, n, n2, n3, n4);
    }

    public static final boolean isComponentOpaque(Component component) {
        return paint.isOpaque(component);
    }

    public static final boolean isOpaque(Component component) {
        OyoahaButtonLikeComponent oyoahaButtonLikeComponent = OyoahaUtilities.getOyoahaButtonLikeComponent(component);
        if (oyoahaButtonLikeComponent != null) {
            return true;
        }
        return paint.isOpaque(component);
    }

    public static final Color getBackground(Component component) {
        return paint.getBackground(component);
    }

    public static final Color getForeground(Component component) {
        return component.getForeground();
    }

    public static boolean getBoolean(String string) {
        return OyoahaUtilities.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        Object object = UIManager.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public static final void loadImage(Image image) {
        loader.loadImage(image);
    }

    public static final Image loadImage(int[] nArray, int n, int n2) {
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        loader.loadImage(image);
        return image;
    }

    public static final OyoahaBackgroundObject getBackgroundObject(Component component) {
        return OyoahaUtilities.getBackgroundObject(OyoahaUtilities.getUIClassID(component));
    }

    public static final OyoahaBackgroundObject getBackgroundObject(String string) {
        Object object = UIManager.get(string + ".backgroundObject");
        if (object != null && object instanceof OyoahaBackgroundObject) {
            return (OyoahaBackgroundObject)object;
        }
        return null;
    }

    public static final OyoahaFlash getFlash(Component component) {
        return OyoahaUtilities.getFlash(OyoahaUtilities.getUIClassID(component));
    }

    public static final OyoahaFlash getFlash(String string) {
        OyoahaBackgroundObject oyoahaBackgroundObject = null;
        oyoahaBackgroundObject = string.equals("Slider") ? OyoahaUtilities.getBackgroundObject("SliderTrack") : (string.equals("ScrollBar") ? OyoahaUtilities.getBackgroundObject("ScrollBarTrack") : OyoahaUtilities.getBackgroundObject(string));
        if (oyoahaBackgroundObject != null && oyoahaBackgroundObject instanceof OyoahaFlash) {
            return (OyoahaFlash)((Object)oyoahaBackgroundObject);
        }
        return null;
    }

    public static final OyoahaFlash getFlashBorder(Component component) {
        Border border;
        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) != null && border instanceof OyoahaFlash) {
            return (OyoahaFlash)((Object)border);
        }
        return null;
    }

    public static final OyoahaFlash getFlashIcon(Component component) {
        Icon icon;
        if (component instanceof AbstractButton && (icon = ((AbstractButton)component).getIcon()) != null && icon instanceof OyoahaFlash) {
            return (OyoahaFlash)((Object)icon);
        }
        return null;
    }

    public static final OyoahaBumpObject getOyoahaBumpObject() {
        Object object = UIManager.get("oyoahabump");
        if (object != null && object instanceof OyoahaBumpObject) {
            return (OyoahaBumpObject)object;
        }
        return null;
    }

    public static final boolean isRolloverEnabled(Component component) {
        return OyoahaUtilities.isRolloverEnabled(component, oyoahaLookAndFeel.getDefaultRolloverPolicy(component));
    }

    public static final boolean isRolloverEnabled(Component component, boolean bl) {
        return OyoahaUtilities.getBoolean(OyoahaUtilities.getUIClassID(component) + ".rollover", bl);
    }

    /*
     * Unable to fully structure code
     */
    public static final void paintBump(Graphics var0, Component var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        var9_9 = OyoahaUtilities.getOyoahaBumpObject();
                        if (var9_9 == null || var7_7 == 0 || var8_8 == 0) {
                            return;
                        }
                        var10_10 = var2_2;
                        var11_11 = var3_3;
                        if (var7_7 <= 0) break block7;
                        var12_12 = var7_7 * var9_9.getWidth() + (var7_7 - 1);
                        if (var12_12 > var4_4) {
                            return;
                        }
                        var10_10 += (var4_4 - var12_12) / 2;
                        break block8;
                    }
                    var7_7 = 1;
                    var12_12 = var7_7 * var9_9.getWidth();
                    if (var12_12 <= var4_4) ** GOTO lbl18
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var12_12 = ++var7_7 * var9_9.getWidth() + (var7_7 - 1);
lbl18:
                        // 2 sources

                        ** while (var12_12 < var4_4)
                    }
lbl19:
                    // 1 sources

                    var12_12 = --var7_7 * var9_9.getWidth() + (var7_7 - 1);
                    var10_10 += (var4_4 - var12_12) / 2;
                }
                if (var8_8 <= 0) break block9;
                var12_12 = var8_8 * var9_9.getHeight() + (var8_8 - 1);
                if (var12_12 > var5_5) {
                    return;
                }
                var11_11 += (var5_5 - var12_12) / 2;
                break block10;
            }
            var8_8 = 1;
            var12_12 = var8_8 * var9_9.getHeight();
            if (var12_12 <= var5_5) ** GOTO lbl34
            return;
lbl-1000:
            // 1 sources

            {
                var12_12 = ++var8_8 * var9_9.getHeight() + (var8_8 - 1);
lbl34:
                // 2 sources

                ** while (var12_12 < var5_5)
            }
lbl35:
            // 1 sources

            var12_12 = --var8_8 * var9_9.getHeight() + (var8_8 - 1);
            var11_11 += (var5_5 - var12_12) / 2;
        }
        var12_12 = 0;
        while (var12_12 < var8_8) {
            var13_13 = 0;
            while (var13_13 < var7_7) {
                var9_9.paint(var0, var1_1, var10_10 + var13_13 * var9_9.getWidth() + var13_13, var11_11 + var12_12 * var9_9.getHeight() + var12_12, var6_6);
                ++var13_13;
            }
            ++var12_12;
        }
    }

    public static final void setAlphaChannel(Graphics graphics, Component component, float f) {
        paint.setAlphaChannel(graphics, component, f);
    }

    public static final void paintBackground(Graphics graphics, Component component) {
        Rectangle rectangle = OyoahaUtilities.getFullRect(component);
        paint.paintBackground(graphics, component, rectangle.x, rectangle.y, rectangle.width, rectangle.height, OyoahaUtilities.getBackground(component), OyoahaUtilities.getStatus(component));
    }

    public static final void paintBackground(Graphics graphics, Component component, int n, int n2, int n3, int n4, int n5) {
        paint.paintBackground(graphics, component, n, n2, n3, n4, null, n5);
    }

    public static final void paintBackground(Graphics graphics, Component component, int n, int n2, int n3, int n4, Color color, int n5) {
        paint.paintBackground(graphics, component, n, n2, n3, n4, color, n5);
    }

    public static final void paintColorBackground(Graphics graphics, Component component, int n, int n2, int n3, int n4, Color color, int n5) {
        paint.paintColorBackground(graphics, component, n, n2, n3, n4, color, n5);
    }

    public static final boolean isAlphaClasses(Component component) {
        OyoahaButtonLikeComponent oyoahaButtonLikeComponent = OyoahaUtilities.getOyoahaButtonLikeComponent(component);
        if (oyoahaButtonLikeComponent != null) {
            return oyoahaButtonLikeComponent.isBorderPainted(component);
        }
        return false;
    }

    public static final OyoahaButtonLikeComponent getOyoahaButtonLikeComponent(Component component) {
        if (component instanceof OyoahaButtonLikeComponent) {
            return (OyoahaButtonLikeComponent)((Object)component);
        }
        if (component instanceof JComponent) {
            String string = OyoahaUtilities.getUIClassID2(component);
            if (string == null) {
                return null;
            }
            Object object = UIManager.get(string);
            if (object == null || !object.toString().startsWith("com.oyoaha.")) {
                return null;
            }
            object = UIManager.getUI((JComponent)component);
            if (object != null && object instanceof OyoahaButtonLikeComponent) {
                return (OyoahaButtonLikeComponent)object;
            }
        }
        return null;
    }

    public static final void setOpaque(Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        OyoahaButtonLikeComponent oyoahaButtonLikeComponent = OyoahaUtilities.getOyoahaButtonLikeComponent(component);
        if (oyoahaButtonLikeComponent != null) {
            ((JComponent)component).setOpaque(false);
        }
    }

    public static final void unsetOpaque(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(OyoahaUtilities.isOpaque(component));
        }
    }

    public static final OyoahaThemeScheme getScheme() {
        return oyoahaLookAndFeel.getOyoahaThemeScheme();
    }

    protected static final OyoahaColorPool getDefaultOyoahaColorPool() {
        if (pool == null) {
            Object object = UIManager.get("OyoahaUtilities.defaultOyoahaColorPool");
            pool = object != null && object instanceof OyoahaColorPool ? (OyoahaColorPool)object : new OyoahaDefaultColorPool(oyoahaLookAndFeel);
        }
        return pool;
    }

    public static final void updateOyoahaThemeScheme(OyoahaThemeSchemeChanged oyoahaThemeSchemeChanged) {
    }

    public static final void updateOyoahaTheme() {
        pool = null;
    }

    public static final Color getColor(Component component) {
        return OyoahaUtilities.getColor(OyoahaUtilities.getBackground(component), OyoahaUtilities.getStatus(component));
    }

    public static final Color getColor(Component component, int n) {
        return OyoahaUtilities.getColor(OyoahaUtilities.getBackground(component), n);
    }

    public static final Color getColor(Color color, int n) {
        return OyoahaUtilities.getDefaultOyoahaColorPool().getColor(color, n);
    }

    public static final Color getColor(int n) {
        if (n == 102) {
            return oyoahaLookAndFeel.getOyoahaThemeScheme().getBlack();
        }
        if (n == 101) {
            return oyoahaLookAndFeel.getOyoahaThemeScheme().getWhite();
        }
        return OyoahaUtilities.getDefaultOyoahaColorPool().getColor(n);
    }

    public static final Color getColorFromScheme(int n) {
        return oyoahaLookAndFeel.getOyoahaThemeScheme().get(n);
    }

    public static final Color getColor(Component component, Color color) {
        return OyoahaUtilities.getColor(color, OyoahaUtilities.getStatus(component));
    }

    public static final void paintAScrollMosaic(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image, int n5, int n6) {
        paint.paintAScrollMosaic(graphics, component, n, n2, n3, n4, image, n5, n6);
    }

    public static final void paintAGradient(Graphics graphics, Component component, int n, int n2, int n3, int n4, Color color, Color color2, boolean bl, boolean bl2, int n5) {
        paint.paintAGradient(graphics, component, n, n2, n3, n4, color, color2, bl, bl2, n5);
    }

    public static final void paintRScrollMosaic(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image, int n5, int n6) {
        paint.paintAScrollMosaic(graphics, component, n, n2, n3, n4, image, n5, n6);
    }

    public static final void paintAMosaic(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image) {
        paint.paintAMosaic(graphics, component, n, n2, n3, n4, image);
    }

    public static final void paintRMosaic(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image) {
        paint.paintRMosaic(graphics, component, n, n2, n3, n4, image);
    }

    public static final void paintAImageAt(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image, int n5) {
        paint.paintAImageAt(graphics, component, n, n2, n3, n4, image, n5);
    }

    public static final void paintAImageAt(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image, int n5, int n6, int n7) {
        paint.paintAImageAt(graphics, component, n, n2, n3, n4, image, n5, n6, n7);
    }

    public static final void paintRImageAt(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image, int n5) {
        paint.paintRImageAt(graphics, component, n, n2, n3, n4, image, n5);
    }

    public static final void paintRScaling(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image) {
        paint.paintRScaling(graphics, component, n, n2, n3, n4, image);
    }

    public static final void paintAScaling(Graphics graphics, Component component, int n, int n2, int n3, int n4, Image image) {
        paint.paintAScaling(graphics, component, n, n2, n3, n4, image);
    }

    public static final String getUIClassID2(Component component) {
        if (component instanceof JComponent) {
            String string = ((JComponent)component).getUIClassID();
            if (string == null || string == "") {
                return null;
            }
            return string;
        }
        return null;
    }

    public static final String getUIClassID(Component component) {
        if (component instanceof JComponent) {
            String string = ((JComponent)component).getUIClassID();
            if (string == null || string == "") {
                return "Panel";
            }
            if (string.endsWith("UI")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        return "Panel";
    }
}

