/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha;

import com.oyoaha.swing.plaf.oyoaha.IDATEnumeration;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PNGImageProducer
implements ImageProducer,
Runnable {
    private int dataWidth;
    private int dataHeight;
    private int width = -1;
    private int height = -1;
    private int sigmask = 65535;
    private ColorModel model;
    private Object pixels;
    private int[] ipixels;
    private byte[] bpixels;
    private Hashtable properties;
    private Vector theConsumers = new Vector();
    private boolean multipass;
    private boolean complete;
    private boolean error;
    InputStream underlyingStream;
    DataInputStream inputStream;
    private Thread controlThread;
    private boolean infoAvailable = false;
    private boolean completePasses = false;
    private int updateDelay = 750;
    private boolean headerFound = false;
    private int compressionMethod = -1;
    private int depth = -1;
    private int colorType = -1;
    private int filterMethod = -1;
    private int interlaceMethod = -1;
    private int pass;
    private byte[] palette;
    private boolean transparency;
    int chunkLength;
    int chunkType;
    boolean needChunkInfo = true;
    static final int CHUNK_bKGD = 1649100612;
    static final int CHUNK_cHRM = 1665684045;
    static final int CHUNK_gAMA = 1732332865;
    static final int CHUNK_hIST = 1749635924;
    static final int CHUNK_IDAT = 1229209940;
    static final int CHUNK_IEND = 1229278788;
    static final int CHUNK_IHDR = 1229472850;
    static final int CHUNK_PLTE = 1347179589;
    static final int CHUNK_pHYs = 1883789683;
    static final int CHUNK_sBIT = 1933723988;
    static final int CHUNK_tEXt = 1950701684;
    static final int CHUNK_tIME = 1950960965;
    static final int CHUNK_tRNS = 1951551059;
    static final int CHUNK_zTXt = 2052348020;
    static final int[] startingRow = new int[]{0, 0, 0, 4, 0, 2, 0, 1};
    static final int[] startingCol = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    static final int[] rowInc = new int[]{1, 8, 8, 8, 4, 4, 2, 2};
    static final int[] colInc = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockHeight = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockWidth = new int[]{1, 8, 4, 4, 2, 2, 1, 1};

    public PNGImageProducer(InputStream inputStream) {
        this.properties = new Hashtable();
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream, 1024);
        }
        this.underlyingStream = inputStream;
        this.inputStream = new DataInputStream(this.underlyingStream);
    }

    public void dispose() {
        try {
            if (this.underlyingStream != null) {
                this.underlyingStream.close();
                this.underlyingStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block6: {
            if (this.theConsumers.contains(imageConsumer)) {
                return;
            }
            this.theConsumers.addElement(imageConsumer);
            try {
                this.initConsumer(imageConsumer);
                this.sendPixels(imageConsumer, 0, 0, this.width, this.height);
                if (this.complete && this.isConsumer(imageConsumer)) {
                    if (this.error) {
                        imageConsumer.imageComplete(1);
                    } else {
                        imageConsumer.imageComplete(3);
                    }
                    this.removeConsumer(imageConsumer);
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block6;
                imageConsumer.imageComplete(1);
            }
        }
    }

    private void blockFill(int n) {
        int n2;
        int n3 = this.dataWidth;
        int n4 = this.pass;
        int n5 = blockWidth[n4];
        int n6 = startingCol[n4];
        int n7 = colInc[n4];
        int n8 = n7 - n5;
        int n9 = n + n3 - n5;
        int n10 = blockHeight[n4];
        int n11 = n + n3 * n10;
        int n12 = n2 = n + n6;
        if (this.colorType == 3) {
            byte by;
            byte[] byArray = this.bpixels;
            int n13 = byArray.length;
            while (n12 <= n9) {
                int n14 = n12 + n5;
                by = byArray[n12++];
                while (n12 < n14) {
                    byArray[n12] = by;
                    ++n12;
                }
                n12 += n8;
            }
            if (n12 < (n9 += n5)) {
                by = byArray[n12++];
                while (n12 < n9) {
                    byArray[n12] = by;
                    ++n12;
                }
            }
            if (n13 < n11) {
                n11 = n13;
            }
            n12 = n2 + n3;
            while (n12 < n11) {
                System.arraycopy(byArray, n2, byArray, n12, n3 - n6);
                n12 += n3;
            }
        } else {
            int n15;
            int[] nArray = this.ipixels;
            int n16 = nArray.length;
            while (n12 <= n9) {
                int n17 = n12 + n5;
                n15 = nArray[n12++];
                while (n12 < n17) {
                    nArray[n12] = n15;
                    ++n12;
                }
                n12 += n8;
            }
            if (n12 < (n9 += n5)) {
                n15 = nArray[n12++];
                while (n12 < n9) {
                    nArray[n12] = n15;
                    ++n12;
                }
            }
            if (n16 < n11) {
                n11 = n16;
            }
            n12 = n2 + n3;
            while (n12 < n11) {
                System.arraycopy(nArray, n2, nArray, n12, n3 - n6);
                n12 += n3;
            }
        }
    }

    private boolean filterRow(byte[] byArray, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray.length;
        switch (n) {
            case 0: {
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = 0xFF & byArray[n4];
                    ++n4;
                }
                break;
            }
            case 1: {
                int n5 = 0;
                while (n5 < n2) {
                    nArray[n5] = 0xFF & byArray[n5];
                    ++n5;
                }
                while (n5 < n3) {
                    nArray[n5] = 0xFF & byArray[n5] + nArray[n5 - n2];
                    ++n5;
                }
                break;
            }
            case 2: {
                if (nArray2 != null) {
                    int n6 = 0;
                    while (n6 < n3) {
                        nArray[n6] = 0xFF & nArray2[n6] + byArray[n6];
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray[n7] = 0xFF & byArray[n7];
                        ++n7;
                    }
                }
                break;
            }
            case 3: {
                if (nArray2 != null) {
                    int n8;
                    int n9 = 0;
                    while (n9 < n2) {
                        n8 = nArray2[n9];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                    while (n9 < n3) {
                        n8 = nArray2[n9] + nArray[n9 - n2];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        nArray[n10] = 0xFF & byArray[n10];
                        ++n10;
                    }
                    while (n10 < n3) {
                        int n11 = nArray[n10 - n2];
                        nArray[n10] = 0xFF & (n11 >> 1) + byArray[n10];
                        ++n10;
                    }
                }
                break;
            }
            case 4: {
                if (nArray2 != null) {
                    int n12 = 0;
                    while (n12 < n2) {
                        nArray[n12] = 0xFF & nArray2[n12] + byArray[n12];
                        ++n12;
                    }
                    while (n12 < n3) {
                        int n13;
                        int n14 = nArray[n12 - n2];
                        int n15 = nArray2[n12];
                        int n16 = nArray2[n12 - n2];
                        int n17 = n14 + n15 - n16;
                        int n18 = n17 > n14 ? n17 - n14 : n14 - n17;
                        int n19 = n17 > n15 ? n17 - n15 : n15 - n17;
                        int n20 = n13 = n17 > n16 ? n17 - n16 : n16 - n17;
                        int n21 = n18 <= n19 && n18 <= n13 ? n14 : (n19 <= n13 ? n15 : n16);
                        nArray[n12] = 0xFF & n21 + byArray[n12];
                        ++n12;
                    }
                } else {
                    int n22 = 0;
                    while (n22 < n2) {
                        nArray[n22] = 0xFF & byArray[n22];
                        ++n22;
                    }
                    while (n22 < n3) {
                        int n23 = nArray[n22 - n2];
                        nArray[n22] = 0xFF & n23 + byArray[n22];
                        ++n22;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void handlebKGD() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlecHRM() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleChunk() throws IOException {
        if (this.needChunkInfo) {
            this.chunkLength = this.inputStream.readInt();
            this.chunkType = this.inputStream.readInt();
            this.needChunkInfo = false;
        }
        switch (this.chunkType) {
            case 1649100612: {
                this.handlebKGD();
                break;
            }
            case 1665684045: {
                this.handlecHRM();
                break;
            }
            case 1732332865: {
                this.handlegAMA();
                break;
            }
            case 1749635924: {
                this.handlehIST();
                break;
            }
            case 1229209940: {
                this.handleIDAT();
                break;
            }
            case 1229278788: {
                this.handleIEND();
                break;
            }
            case 1229472850: {
                this.handleIHDR();
                break;
            }
            case 1883789683: {
                this.handlepHYs();
                break;
            }
            case 1347179589: {
                this.handlePLTE();
                break;
            }
            case 1933723988: {
                this.handlesBIT();
                break;
            }
            case 1950701684: {
                this.handletEXt();
                break;
            }
            case 1950960965: {
                this.handletIME();
                break;
            }
            case 1951551059: {
                this.handletRNS();
                break;
            }
            case 2052348020: {
                this.handlezTXt();
                break;
            }
            default: {
                System.err.println("unrecognized chunk type " + Integer.toHexString(this.chunkType) + ". skipping");
                this.inputStream.skip(this.chunkLength);
            }
        }
        int n = this.inputStream.readInt();
        this.needChunkInfo = true;
    }

    private void handlegAMA() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlehIST() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIDAT() throws IOException {
        if (!this.infoAvailable) {
            Vector vector;
            if (this.width == -1) {
                this.width = this.dataWidth;
            }
            if (this.height == -1) {
                this.height = this.dataHeight;
            }
            this.setColorModel();
            if (this.interlaceMethod != 0) {
                this.multipass = true;
            }
            PNGImageProducer pNGImageProducer = this;
            synchronized (pNGImageProducer) {
                this.infoAvailable = true;
                vector = (Vector)this.theConsumers.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                this.initConsumer((ImageConsumer)vector.elementAt(n));
                ++n;
            }
        }
        this.readImageData();
        this.sendPixels(0, 0, this.width, this.height);
    }

    private void handleIEND() throws IOException {
        this.complete = true;
    }

    private void handleIHDR() throws IOException {
        if (this.headerFound) {
            throw new IOException("Extraneous IHDR chunk encountered.");
        }
        if (this.chunkLength != 13) {
            throw new IOException("IHDR chunk length wrong: " + this.chunkLength);
        }
        this.dataWidth = this.inputStream.readInt();
        this.dataHeight = this.inputStream.readInt();
        this.depth = this.inputStream.read();
        this.colorType = this.inputStream.read();
        this.compressionMethod = this.inputStream.read();
        this.filterMethod = this.inputStream.read();
        this.interlaceMethod = this.inputStream.read();
    }

    private void handlePLTE() throws IOException {
        if (this.colorType == 3) {
            this.palette = new byte[this.chunkLength];
            this.inputStream.readFully(this.palette);
        } else {
            this.inputStream.skip(this.chunkLength);
        }
    }

    private void handlepHYs() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlesBIT() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletEXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletIME() throws IOException {
        if (this.chunkLength != 7) {
            System.err.println("tIME chunk length incorrect: " + this.chunkLength);
        }
        this.inputStream.skip(this.chunkLength);
    }

    private void handletRNS() throws IOException {
        int n = this.chunkLength;
        if (this.palette == null) {
            throw new IOException("tRNS chunk encountered before pLTE");
        }
        int n2 = this.palette.length;
        switch (this.colorType) {
            case 3: {
                this.transparency = true;
                int n3 = n2 / 3;
                byte[] byArray = new byte[n3];
                this.inputStream.readFully(byArray, 0, this.chunkLength);
                int n4 = -1;
                int n5 = n2;
                while (n5 < n3) {
                    byArray[n5] = n4;
                    ++n5;
                }
                byte[] byArray2 = new byte[n2 + n3];
                int n6 = byArray2.length;
                while (n6 > 0) {
                    byArray2[--n6] = byArray[--n3];
                    byArray2[--n6] = this.palette[--n2];
                    byArray2[--n6] = this.palette[--n2];
                    byArray2[--n6] = this.palette[--n2];
                }
                this.palette = byArray2;
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
    }

    private void handlezTXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleSignature() throws IOException {
        if (this.inputStream.read() != 137 || this.inputStream.read() != 80 || this.inputStream.read() != 78 || this.inputStream.read() != 71 || this.inputStream.read() != 13 || this.inputStream.read() != 10 || this.inputStream.read() != 26 || this.inputStream.read() != 10) {
            throw new IOException("Not a PNG File");
        }
    }

    private void initConsumer(ImageConsumer imageConsumer) {
        if (this.infoAvailable) {
            if (this.isConsumer(imageConsumer)) {
                imageConsumer.setDimensions(this.width, this.height);
            }
            if (this.isConsumer(imageConsumer)) {
                imageConsumer.setProperties(this.properties);
            }
            if (this.isConsumer(imageConsumer)) {
                imageConsumer.setColorModel(this.model);
            }
            if (this.isConsumer(imageConsumer)) {
                imageConsumer.setHints(this.multipass ? 6 : 30);
            }
        }
    }

    private void insertGreyPixels(int[] nArray, int n, int n2) {
        int n3 = nArray[0];
        int[] nArray2 = this.ipixels;
        int n4 = colInc[this.pass];
        int n5 = 0;
        block0 : switch (this.colorType) {
            case 0: {
                switch (this.depth) {
                    case 1: {
                        int n6 = 0;
                        while (n6 < n2) {
                            if (n5 != 0) {
                                --n5;
                            } else {
                                n5 = 7;
                                n3 = nArray[n6 >> 3];
                            }
                            nArray2[n] = n3 >> n5 & 1;
                            ++n6;
                            n += n4;
                        }
                        break block0;
                    }
                    case 2: {
                        int n7 = 0;
                        while (n7 < n2) {
                            if (n5 != 0) {
                                n5 -= 2;
                            } else {
                                n5 = 6;
                                n3 = nArray[n7 >> 2];
                            }
                            nArray2[n] = n3 >> n5 & 3;
                            ++n7;
                            n += n4;
                        }
                        break block0;
                    }
                    case 4: {
                        int n8 = 0;
                        while (n8 < n2) {
                            if (n5 != 0) {
                                n5 = 0;
                            } else {
                                n5 = 4;
                                n3 = nArray[n8 >> 1];
                            }
                            nArray2[n] = n3 >> n5 & 0xF;
                            ++n8;
                            n += n4;
                        }
                        break block0;
                    }
                    case 8: {
                        int n9 = 0;
                        while (n9 < n2) {
                            nArray2[n] = (byte)nArray[n9++];
                            n += n4;
                        }
                        break block0;
                    }
                    case 16: {
                        n2 <<= 1;
                        int n10 = 0;
                        while (n10 < n2) {
                            nArray2[n] = nArray[n10];
                            n10 += 2;
                            n += n4;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (this.depth == 8) {
                    int n11 = 0;
                    while (n11 < n2) {
                        nArray2[n] = nArray[n11++] << 8 | nArray[n11++];
                        n += n4;
                    }
                } else {
                    n2 <<= 1;
                    int n12 = 0;
                    while (n12 < n2) {
                        nArray2[n] = nArray[n12] << 8 | nArray[n12 += 2];
                        n12 += 2;
                        n += n4;
                    }
                }
                break;
            }
        }
    }

    private void insertPalettedPixels(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = nArray[0];
        byte[] byArray = this.bpixels;
        int n5 = colInc[this.pass];
        switch (this.depth) {
            case 1: {
                int n6 = 0;
                while (n6 < n2) {
                    if (n3 != 0) {
                        --n3;
                    } else {
                        n3 = 7;
                        n4 = nArray[n6 >> 3];
                    }
                    byArray[n] = (byte)(n4 >> n3 & 1);
                    ++n6;
                    n += n5;
                }
                break;
            }
            case 2: {
                int n7 = 0;
                while (n7 < n2) {
                    if (n3 != 0) {
                        n3 -= 2;
                    } else {
                        n3 = 6;
                        n4 = nArray[n7 >> 2];
                    }
                    byArray[n] = (byte)(n4 >> n3 & 3);
                    ++n7;
                    n += n5;
                }
                break;
            }
            case 4: {
                int n8 = 0;
                while (n8 < n2) {
                    if (n3 != 0) {
                        n3 = 0;
                    } else {
                        n3 = 4;
                        n4 = nArray[n8 >> 1];
                    }
                    byArray[n] = (byte)(n4 >> n3 & 0xF);
                    ++n8;
                    n += n5;
                }
                break;
            }
            case 8: {
                int n9 = 0;
                while (n9 < n2) {
                    byArray[n] = (byte)nArray[n9];
                    ++n9;
                    n += n5;
                }
                break;
            }
        }
    }

    private void insertPixels(int[] nArray, int n, int n2) {
        switch (this.colorType) {
            case 0: 
            case 4: {
                this.insertGreyPixels(nArray, n, n2);
                break;
            }
            case 2: {
                int n3 = 0;
                int[] nArray2 = this.ipixels;
                int n4 = colInc[this.pass];
                if (this.depth == 8) {
                    n3 = 0;
                    while (n3 < n2) {
                        nArray2[n] = nArray[n3++] << 16 | nArray[n3++] << 8 | nArray[n3++];
                        n += n4;
                    }
                } else {
                    n2 <<= 1;
                    n3 = 0;
                    while (n3 < n2) {
                        nArray2[n] = nArray[n3] << 16 | nArray[n3 += 2] << 8 | nArray[n3 += 2];
                        n3 += 2;
                        n += n4;
                    }
                }
                break;
            }
            case 3: {
                this.insertPalettedPixels(nArray, n, n2);
                break;
            }
            case 6: {
                int n5 = 0;
                int[] nArray3 = this.ipixels;
                int n6 = colInc[this.pass];
                if (this.depth == 8) {
                    n5 = 0;
                    while (n5 < n2) {
                        nArray3[n] = nArray[n5++] << 16 | nArray[n5++] << 8 | nArray[n5++] | nArray[n5++] << 24;
                        n += n6;
                    }
                } else {
                    n2 <<= 1;
                    n5 = 0;
                    while (n5 < n2) {
                        nArray3[n] = nArray[n5] << 16 | nArray[n5 += 2] << 8 | nArray[n5 += 2] | nArray[n5 += 2] << 24;
                        n5 += 2;
                        n += n6;
                    }
                }
                break;
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumers.contains(imageConsumer);
    }

    private void readImageData() throws IOException {
        int n;
        long l = System.currentTimeMillis();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new IDATEnumeration(this));
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new InflaterInputStream(sequenceInputStream, new Inflater())));
        switch (this.colorType) {
            case 0: 
            case 3: {
                n = this.depth;
                break;
            }
            case 2: {
                n = 3 * this.depth;
                break;
            }
            case 4: {
                n = this.depth << 1;
                break;
            }
            case 6: {
                n = this.depth << 2;
                break;
            }
            default: {
                throw new IOException("Unknown color type encountered.");
            }
        }
        int n2 = n + 7 >> 3;
        this.pass = this.multipass ? 1 : 0;
        while (this.pass < 8) {
            int n3 = this.pass;
            int n4 = rowInc[n3];
            int n5 = colInc[n3];
            int n6 = startingCol[n3];
            int n7 = (this.dataWidth - n6 + n5 - 1) / n5;
            int n8 = n7 * n2;
            int n9 = n7 * n >> 3;
            int n10 = startingRow[n3];
            if (this.dataHeight > n10 && n9 != 0) {
                int n11 = n4 * this.dataWidth;
                byte[] byArray = new byte[n9];
                int[] nArray = new int[n9];
                int[] nArray2 = null;
                int[] nArray3 = new int[n9];
                int n12 = n10;
                int n13 = 0;
                int n14 = n10 * this.dataWidth;
                int n15 = n10;
                while (n15 < this.dataHeight) {
                    long l2;
                    n13 += n4;
                    int n16 = dataInputStream.read();
                    dataInputStream.readFully(byArray);
                    if (!this.filterRow(byArray, nArray, nArray2, n16, n2)) {
                        throw new IOException("Unknown filter type: " + n16);
                    }
                    this.insertPixels(nArray, n14 + n6, n8);
                    if (this.multipass && n3 < 6) {
                        this.blockFill(n14);
                    }
                    nArray2 = nArray;
                    nArray = nArray3;
                    nArray3 = nArray2;
                    if (!this.completePasses && (l2 = System.currentTimeMillis()) - l > (long)this.updateDelay) {
                        this.sendPixels(0, n12, this.width, n13);
                        n13 = 0;
                        n12 = n15 + n4;
                        l = l2;
                    }
                    Thread.yield();
                    n15 += n4;
                    n14 += n11;
                }
                if (!this.multipass) break;
                if (this.completePasses || n13 > 0) {
                    this.sendPixels(0, 0, this.width, this.height);
                    l = System.currentTimeMillis();
                }
            }
            ++this.pass;
        }
        while (dataInputStream.read() != -1) {
            System.err.println("Leftover data encountered.");
        }
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.theConsumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.handleSignature();
            while (!this.complete && !this.error) {
                this.handleChunk();
            }
        }
        catch (Exception exception) {
            System.err.println("PNGImageProducer: " + exception);
            exception.printStackTrace(System.err);
            this.error = true;
        }
        PNGImageProducer pNGImageProducer = this;
        synchronized (pNGImageProducer) {
            int n = 0;
            while (n < this.theConsumers.size()) {
                ImageConsumer imageConsumer = (ImageConsumer)this.theConsumers.elementAt(n);
                if (this.error) {
                    imageConsumer.imageComplete(1);
                } else {
                    imageConsumer.imageComplete(3);
                }
                ++n;
            }
        }
    }

    private synchronized void sendPixels(int n, int n2, int n3, int n4) {
        int n5 = this.dataWidth * n2 + n;
        Enumeration enumeration = this.theConsumers.elements();
        while (enumeration.hasMoreElements()) {
            ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
            if (this.pixels == null || !this.isConsumer(imageConsumer)) continue;
            if (this.pixels instanceof byte[]) {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, this.bpixels, n5, this.dataWidth);
                continue;
            }
            imageConsumer.setPixels(n, n2, n3, n4, this.model, this.ipixels, n5, this.dataWidth);
        }
    }

    private void sendPixels(ImageConsumer imageConsumer, int n, int n2, int n3, int n4) {
        int n5 = this.dataWidth * n2 + n;
        if (this.pixels != null && this.isConsumer(imageConsumer)) {
            if (this.pixels instanceof byte[]) {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, this.bpixels, n5, this.dataWidth);
            } else {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, this.ipixels, n5, this.dataWidth);
            }
        }
    }

    private void setColorModel() throws IOException {
        int n = 0;
        switch (this.depth) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 4: {
                n = 15;
                break;
            }
            case 8: 
            case 16: {
                n = 255;
            }
        }
        int n2 = this.width * this.height;
        switch (this.colorType) {
            case 3: {
                if (this.palette == null) {
                    throw new IOException("No palette located");
                }
                this.bpixels = new byte[n2];
                this.pixels = this.bpixels;
                if (this.transparency) {
                    this.model = new IndexColorModel(this.depth, this.palette.length / 4, this.palette, 0, true);
                    break;
                }
                this.model = new IndexColorModel(this.depth, this.palette.length / 3, this.palette, 0, false);
                break;
            }
            case 0: {
                this.ipixels = new int[n2];
                this.pixels = this.ipixels;
                if (this.depth < 8) {
                    this.model = new DirectColorModel(this.depth, n, n, n);
                    break;
                }
                this.model = new DirectColorModel(8, n, n, n);
                break;
            }
            case 2: {
                this.ipixels = new int[n2];
                this.pixels = this.ipixels;
                this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
                break;
            }
            case 4: {
                if (this.depth < 8) {
                    int n3 = n << this.depth;
                    this.model = new DirectColorModel(this.depth * 2, n3, n3, n3, n);
                } else {
                    int n4 = n << 8;
                    this.model = new DirectColorModel(16, n4, n4, n4, n);
                }
                this.ipixels = new int[n2];
                this.pixels = this.ipixels;
                break;
            }
            case 6: {
                this.ipixels = new int[n2];
                this.pixels = this.ipixels;
                this.model = ColorModel.getRGBdefault();
                break;
            }
            default: {
                throw new IOException("Image has unknown color type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.controlThread == null) {
            PNGImageProducer pNGImageProducer = this;
            synchronized (pNGImageProducer) {
                this.controlThread = new Thread(this);
                try {
                    this.controlThread.setPriority(3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.controlThread.start();
            }
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        this.start();
    }
}

