/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.border;

import com.oyoaha.swing.plaf.oyoaha.OyoahaStateRule;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaSlicePool;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class OyoahaImageBorder
extends AbstractBorder
implements UIResource {
    protected OyoahaSlicePool pool;
    protected OyoahaStateRule rule;

    public OyoahaImageBorder(OyoahaSlicePool oyoahaSlicePool, OyoahaStateRule oyoahaStateRule) {
        this.pool = oyoahaSlicePool;
        this.rule = oyoahaStateRule;
    }

    public Insets getBorderInsets(Component component) {
        return this.pool.getBorderInsets();
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        return this.pool.getBorderInsets(insets);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Shape shape;
        int n5 = this.rule.getState(OyoahaUtilities.getStatus(component));
        if (n5 == 1008) {
            return;
        }
        Image[] imageArray = OyoahaUtilities.isOpaque(component) && component.getBackground() != null && !(component.getBackground() instanceof UIResource) ? this.pool.getImages(n5, component.getBackground()) : this.pool.getImages(n5);
        if (imageArray == null) {
            return;
        }
        Insets insets = this.getBorderInsets(component);
        this.drawHorizontal(component, graphics, imageArray[4], imageArray[6], n, n2, n3, n4, insets);
        this.drawVertical(component, graphics, imageArray[5], imageArray[7], n, n2, n3, n4, insets);
        if (imageArray[0] != null) {
            shape = OyoahaUtilities.normalizeClip(graphics, n, n2, insets.left, insets.top);
            graphics.drawImage(imageArray[0], n, n2, null);
            graphics.setClip(shape);
        }
        if (imageArray[1] != null) {
            shape = OyoahaUtilities.normalizeClip(graphics, n, n2 + (n4 - insets.bottom), insets.left, insets.bottom);
            graphics.drawImage(imageArray[1], n, n2 + (n4 - insets.bottom), null);
            graphics.setClip(shape);
        }
        if (imageArray[2] != null) {
            shape = OyoahaUtilities.normalizeClip(graphics, n + (n3 - insets.right), n2 + (n4 - insets.bottom), insets.right, insets.bottom);
            graphics.drawImage(imageArray[2], n + (n3 - insets.right), n2 + (n4 - insets.bottom), null);
            graphics.setClip(shape);
        }
        if (imageArray[3] != null) {
            shape = OyoahaUtilities.normalizeClip(graphics, n + (n3 - insets.right), n2, insets.right, insets.top);
            graphics.drawImage(imageArray[3], n + (n3 - insets.right), n2, null);
            graphics.setClip(shape);
        }
    }

    private void drawHorizontal(Component component, Graphics graphics, Image image, Image image2, int n, int n2, int n3, int n4, Insets insets) {
        int n5;
        int n6;
        Shape shape = OyoahaUtilities.normalizeClip(graphics, n + insets.left, n2, n3 - (insets.left + insets.right), insets.top);
        if (image != null) {
            n6 = image.getWidth(null);
            n5 = 0;
            while (n5 < n3) {
                graphics.drawImage(image, n5, n2, null);
                n5 += n6;
            }
        }
        graphics.setClip(shape);
        n6 = n4 - insets.bottom + n2;
        shape = OyoahaUtilities.normalizeClip(graphics, n + insets.left, n6, n3 - (insets.left + insets.right), insets.bottom);
        if (image2 != null) {
            n5 = image2.getWidth(null);
            int n7 = 0;
            while (n7 < n3) {
                graphics.drawImage(image2, n7, n6, null);
                n7 += n5;
            }
        }
        graphics.setClip(shape);
    }

    private void drawVertical(Component component, Graphics graphics, Image image, Image image2, int n, int n2, int n3, int n4, Insets insets) {
        int n5;
        int n6;
        Shape shape = OyoahaUtilities.normalizeClip(graphics, n, n2 + insets.top, insets.left, n4 - (insets.top + insets.bottom));
        if (image != null) {
            n6 = image.getHeight(null);
            n5 = 0;
            while (n5 < n4) {
                graphics.drawImage(image, n, n5, null);
                n5 += n6;
            }
        }
        graphics.setClip(shape);
        n6 = n3 - insets.right + n;
        shape = OyoahaUtilities.normalizeClip(graphics, n6, n2 + insets.top, insets.right, n4 - (insets.top + insets.bottom));
        if (image2 != null) {
            n5 = image2.getHeight(null);
            int n7 = 0;
            while (n7 < n4) {
                graphics.drawImage(image2, n6, n7, null);
                n7 += n5;
            }
        }
        graphics.setClip(shape);
    }
}

