/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.filechooser;

import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaFileView;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaSortFileArray;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaVectorFolder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class OyoahaDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    public static final int USE_EXTENTION = 0;
    public static final int USE_TYPE = 1;
    public static final int USE_CASESENSITIVE_EXTENTION = 3;
    public static final int USE_NONE = 4;
    public static final int BY_NAME = 0;
    public static final int BY_CASESENSITIVE_NAME = 1;
    public static final int BY_SIZE = 2;
    public static final int BY_DATE = 3;
    protected boolean inverse;
    protected boolean onlyType;
    protected JFileChooser filechooser = null;
    protected OyoahaFileView view = null;
    protected Thread loadThread = null;
    protected int use = 0;
    protected int mode = 0;
    protected int fetchID;
    protected int length;
    protected Object[] cached;

    public OyoahaDirectoryModel(JFileChooser jFileChooser, OyoahaFileView oyoahaFileView) {
        this.filechooser = jFileChooser;
        this.view = oyoahaFileView;
        this.validateFileCache();
    }

    public static String getMode(int n) {
        switch (n) {
            case 1: {
                return "use_type";
            }
            case 3: {
                return "use_casesensitive_extention";
            }
            case 4: {
                return "use_none";
            }
        }
        return "use_extention";
    }

    public static String getSort(int n) {
        switch (n) {
            case 1: {
                return "by_casesensitive_name";
            }
            case 2: {
                return "by_size";
            }
            case 3: {
                return "by_date";
            }
        }
        return "by_name";
    }

    public static int getModeFromString(String string) {
        if ((string = string.toLowerCase()).equals("use_type")) {
            return 1;
        }
        if (string.equalsIgnoreCase("use_casesensitive_extention")) {
            return 3;
        }
        if (string.equalsIgnoreCase("use_none")) {
            return 4;
        }
        return 0;
    }

    public static int geSortFromString(String string) {
        if ((string = string.toLowerCase()).equals("by_casesensitive_name")) {
            return 1;
        }
        if (string.equalsIgnoreCase("by_size")) {
            return 2;
        }
        if (string.equalsIgnoreCase("by_date")) {
            return 3;
        }
        return 0;
    }

    public void inverse() {
        this.inverse = !this.inverse;
        this.validateFileCache();
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
        this.validateFileCache();
    }

    public void setMode(int n) {
        this.mode = n;
        this.validateFileCache();
    }

    public void setUse(int n) {
        this.use = n;
        this.validateFileCache();
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public int getMode() {
        return this.mode;
    }

    public int getUse() {
        return this.use;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
        this.length = 0;
        this.cached = null;
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            this.invalidateFileCache();
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.fireContentsChanged();
        this.invalidateFileCache();
        switch (this.use) {
            case 4: {
                this.loadThread = new OyoahaLoadFilesThread(this.fetchID, file);
                break;
            }
            case 1: {
                this.loadThread = new OyoahaLoadFilesByTypeThread(this.fetchID, file);
                break;
            }
            default: {
                this.loadThread = new OyoahaLoadFilesByExtentionThread(this.fetchID, file);
            }
        }
        this.loadThread.start();
    }

    protected void fireIntervalAdded(int n, int n2) {
        this.fireIntervalAdded(this, n, n2);
    }

    protected void fireContentsChanged() {
        this.fireContentsChanged(this, -1, this.length);
    }

    public int getSize() {
        return this.length;
    }

    public void replace(Object object, Object object2) {
        int n = this.indexOf(object);
        if (n > -1) {
            this.cached[n] = object2;
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        int n = 0;
        while (n < this.length) {
            if (object.equals(this.cached[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Object getElementAt(int n) {
        if (this.cached != null) {
            return this.cached[n];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected final void quickSortListFiles(ListFiles[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var1_1[(var2_2 + var3_3) / 2];
            ** GOTO lbl18
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.ltb(var1_1[var4_4], var6_6)) continue block0;
                    while (var5_5 > var2_2 && this.ltb(var6_6, var1_1[var5_5])) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    var7_7 = var1_1[var4_4];
                    var1_1[var4_4] = var1_1[var5_5];
                    var1_1[var5_5] = var7_7;
                    ++var4_4;
                    --var5_5;
lbl18:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSortListFiles(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSortListFiles(var1_1, var4_4, var3_3);
            }
        }
    }

    protected final boolean ltb(Object object, Object object2) {
        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase()) < 0;
    }

    protected File[] getFilesFromFileSystemView(File file) {
        if (file instanceof OyoahaVectorFolder) {
            return this.view.getChild(file);
        }
        FileSystemView fileSystemView = this.filechooser.getFileSystemView();
        File[] fileArray = fileSystemView.getFiles(file, this.filechooser.isFileHidingEnabled());
        File[] fileArray2 = new File[fileArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (this.filechooser.accept(fileArray[n2])) {
                fileArray2[n++] = fileArray[n2];
            }
            ++n2;
        }
        File[] fileArray3 = new File[n];
        System.arraycopy(fileArray2, 0, fileArray3, 0, n);
        return fileArray3;
    }

    public class ListFiles
    extends DoChangeContents {
        protected String suffix;

        public ListFiles(int n) {
            super(n);
            this.suffix = "";
        }

        public ListFiles(String string) {
            super(10);
            this.suffix = string;
        }

        public ListFiles(String string, int n) {
            super(n);
            this.suffix = string;
        }

        public String toString() {
            return this.suffix;
        }
    }

    public class DoChangeContents
    extends OyoahaSortFileArray
    implements Runnable {
        protected Object lock = new Object();
        protected int fid;

        public DoChangeContents() {
            this.mode = OyoahaDirectoryModel.this.getMode();
            this.inverse = OyoahaDirectoryModel.this.isInverse();
            this.file = new File[10];
        }

        public DoChangeContents(int n) {
            this.mode = OyoahaDirectoryModel.this.getMode();
            this.inverse = OyoahaDirectoryModel.this.isInverse();
            this.file = new File[n];
        }

        protected void setFid(int n) {
            this.fid = n;
        }

        protected synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.file = null;
                this.count = 0;
            }
        }

        public void run() {
            if (OyoahaDirectoryModel.this.fetchID == this.fid) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.count > 0) {
                        this.sort();
                        if (OyoahaDirectoryModel.this.cached == null) {
                            OyoahaDirectoryModel.this.cached = new File[this.count];
                            OyoahaDirectoryModel.this.length = 0;
                        } else if (OyoahaDirectoryModel.this.length + this.count >= OyoahaDirectoryModel.this.cached.length) {
                            File[] fileArray = new File[OyoahaDirectoryModel.this.length + this.count];
                            System.arraycopy(OyoahaDirectoryModel.this.cached, 0, fileArray, 0, OyoahaDirectoryModel.this.length);
                            OyoahaDirectoryModel.this.cached = fileArray;
                        }
                        System.arraycopy(this.file, 0, OyoahaDirectoryModel.this.cached, OyoahaDirectoryModel.this.length, this.count);
                        int n = OyoahaDirectoryModel.this.length;
                        OyoahaDirectoryModel.this.length += this.count;
                        OyoahaDirectoryModel.this.fireIntervalAdded(n, n + this.count - 1);
                    }
                }
            }
        }
    }

    public class OyoahaLoadFilesThread
    extends OyoahaLoadFilesByExtentionThread {
        public OyoahaLoadFilesThread(int n, File file) {
            super(n, file);
        }

        protected String getExtention(File file) {
            return null;
        }
    }

    public class OyoahaLoadFilesByTypeThread
    extends OyoahaLoadFilesByExtentionThread {
        public OyoahaLoadFilesByTypeThread(int n, File file) {
            super(n, file);
        }

        protected String getExtention(File file) {
            return OyoahaDirectoryModel.this.view.getType(file, false);
        }
    }

    public class OyoahaLoadFilesByExtentionThread
    extends Thread {
        protected File currentDirectory = null;
        protected int fid;
        protected ListFiles arrayDirectories;
        protected ListFiles arrayFiles;
        protected int sizeArraySortFiles;
        protected ListFiles[] arraySortFiles;
        protected Hashtable table;

        public OyoahaLoadFilesByExtentionThread(int n, File file) {
            super("Oyoaha L&F File Loading Thread");
            this.fid = n;
            this.currentDirectory = file;
        }

        protected ListFiles getListFiles(String string, int n) {
            if (this.table.containsKey(string)) {
                return (ListFiles)this.table.get(string);
            }
            ListFiles listFiles = new ListFiles(string, n);
            this.table.put(string, listFiles);
            return listFiles;
        }

        protected void addToArraySortFiles(ListFiles listFiles) {
            if (this.sizeArraySortFiles == this.arraySortFiles.length) {
                ListFiles[] listFilesArray = new ListFiles[this.sizeArraySortFiles + 10];
                System.arraycopy(this.arraySortFiles, 0, listFilesArray, 0, this.sizeArraySortFiles);
                this.arraySortFiles = listFilesArray;
            }
            this.arraySortFiles[this.sizeArraySortFiles++] = listFiles;
        }

        protected String getExtention(File file) {
            return OyoahaDirectoryModel.this.view.getExtention(file, OyoahaDirectoryModel.this.use == 3);
        }

        public void run() {
            try {
                Object object;
                File[] fileArray = OyoahaDirectoryModel.this.getFilesFromFileSystemView(this.currentDirectory);
                this.arrayDirectories = new ListFiles(40);
                this.arrayFiles = new ListFiles(fileArray.length);
                this.table = new Hashtable();
                int n = 0;
                while (n < fileArray.length) {
                    boolean bl = OyoahaDirectoryModel.this.filechooser.isTraversable(fileArray[n]);
                    if (bl) {
                        this.arrayDirectories.add(fileArray[n]);
                    } else if (!bl && OyoahaDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                        object = this.getExtention(fileArray[n]);
                        if (object != null && !((String)object).equals("file")) {
                            this.getListFiles((String)object, 20).add(fileArray[n]);
                        } else {
                            this.arrayFiles.add(fileArray[n]);
                        }
                    }
                    ++n;
                }
                this.arraySortFiles = new ListFiles[this.table.size()];
                Enumeration enumeration = this.table.keys();
                while (enumeration.hasMoreElements()) {
                    object = (ListFiles)this.table.get(enumeration.nextElement());
                    this.addToArraySortFiles((ListFiles)object);
                }
                if (this.arraySortFiles != null && this.sizeArraySortFiles > 1) {
                    OyoahaDirectoryModel.this.quickSortListFiles(this.arraySortFiles, 0, this.sizeArraySortFiles - 1);
                }
                if (this.isInterrupted()) {
                    this.cancelRunnables();
                    return;
                }
                if (OyoahaDirectoryModel.this.cached == null) {
                    OyoahaDirectoryModel.this.cached = new Object[fileArray.length];
                    OyoahaDirectoryModel.this.length = 0;
                } else {
                    if (this.isInterrupted()) {
                        this.cancelRunnables();
                        return;
                    }
                    OyoahaDirectoryModel.this.cached = new Object[fileArray.length];
                    OyoahaDirectoryModel.this.length = 0;
                }
                if (this.arrayDirectories.getSize() > 0) {
                    this.arrayDirectories.setFid(this.fid);
                    SwingUtilities.invokeLater(this.arrayDirectories);
                }
                if (this.arraySortFiles != null) {
                    int n2 = 0;
                    while (n2 < this.sizeArraySortFiles) {
                        this.arraySortFiles[n2].setFid(this.fid);
                        SwingUtilities.invokeLater(this.arraySortFiles[n2]);
                        ++n2;
                    }
                }
                if (this.arrayFiles.getSize() > 0) {
                    this.arrayFiles.setFid(this.fid);
                    SwingUtilities.invokeLater(this.arrayFiles);
                }
                if (this.isInterrupted()) {
                    this.cancelRunnables();
                }
            }
            catch (Exception exception) {
                this.cancelRunnables();
            }
        }

        public void cancelRunnables() {
            if (this.arrayDirectories != null) {
                this.arrayDirectories.cancel();
                this.arrayDirectories = null;
            }
            if (this.arraySortFiles != null) {
                int n = 0;
                while (n < this.sizeArraySortFiles) {
                    this.arraySortFiles[n].cancel();
                    this.arraySortFiles[n] = null;
                    ++n;
                }
                this.arraySortFiles = null;
            }
            if (this.arrayFiles != null) {
                this.arrayFiles.cancel();
                this.arrayFiles = null;
            }
        }
    }
}

