/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.filechooser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class OyoahaVectorFolder
extends File {
    protected static final String TEMP_FILENAME = "temp.ovf";
    protected Vector files;
    protected String name;
    protected boolean changed;

    protected OyoahaVectorFolder(String string, String string2) {
        super(string, string2);
        this.load();
    }

    public static void deleteVectorFolder(String string) {
        OyoahaVectorFolder oyoahaVectorFolder = OyoahaVectorFolder.getVirtualFolder(string);
        if (oyoahaVectorFolder.exists()) {
            oyoahaVectorFolder.delete();
        }
    }

    public static OyoahaVectorFolder getVirtualFolder(String string) {
        if (!string.endsWith(".ovf")) {
            string = string + ".ovf";
        }
        return new OyoahaVectorFolder(System.getProperty("user.home"), ".filechooser" + File.separatorChar + string);
    }

    public static OyoahaVectorFolder getTempVirtualFolder() {
        return OyoahaVectorFolder.getVirtualFolder(TEMP_FILENAME);
    }

    public String getUserName() {
        return this.getName().substring(0, this.getName().length() - 4);
    }

    public File[] listFiles() {
        File[] fileArray = new File[this.files.size()];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = (File)this.files.elementAt(n);
            ++n;
        }
        return fileArray;
    }

    public void addOrMoveFile(File file, int n) {
        int n2 = this.files.indexOf(file);
        if (n2 < 0) {
            if (this.files.size() <= n) {
                this.files.removeElementAt(0);
            }
            this.files.addElement(file);
        } else {
            this.files.removeElementAt(n2);
            this.files.addElement(file);
        }
        this.changed = true;
    }

    public void addOrMoveFile(File file) {
        int n = this.files.indexOf(file);
        if (n < 0) {
            this.files.addElement(file);
        } else {
            this.files.removeElementAt(n);
            this.files.addElement(file);
        }
        this.changed = true;
    }

    public void addFile(File file, int n) {
        if (!this.files.contains(file)) {
            if (this.files.size() <= n) {
                this.files.removeElementAt(0);
            }
            this.files.addElement(file);
            this.changed = true;
        }
    }

    public void addFile(File file) {
        if (!this.files.contains(file)) {
            this.files.addElement(file);
            this.changed = true;
        }
    }

    public void removeFile(File file) {
        int n = this.files.indexOf(file);
        if (n > -1) {
            this.files.removeElementAt(n);
            this.changed = true;
        }
    }

    public void dispose() {
        if (this.getName().equals(TEMP_FILENAME)) {
            if (this.exists()) {
                this.delete();
            }
        } else if (this.changed) {
            this.save();
        }
    }

    protected void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this)));
            int n = 0;
            while (n < this.files.size()) {
                printWriter.println(((File)this.files.elementAt(n)).getPath());
                ++n;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changed = false;
    }

    protected void load() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this));
            String string = bufferedReader.readLine();
            while (string != null && string.length() > 0) {
                File file = new File(string);
                if (file.exists()) {
                    this.files.addElement(file);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changed = false;
    }
}

