/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.pool;

import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeScheme;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeChanged;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeListener;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaPool;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaPoolUtilities;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class OyoahaTexturePool
implements OyoahaPool,
OyoahaThemeSchemeListener {
    protected Image enabled;
    protected Image unselected_enabled;
    protected OyoahaThemeScheme scheme;
    protected Dimension cachedSize;

    public OyoahaTexturePool(OyoahaLookAndFeel oyoahaLookAndFeel, Image image) {
        oyoahaLookAndFeel.addOyoahaThemeSchemeListener(this);
        this.scheme = oyoahaLookAndFeel.getOyoahaThemeScheme();
        this.enabled = image;
        this.init();
    }

    public Dimension getSize() {
        if (this.cachedSize == null) {
            int n = this.enabled.getWidth(null);
            int n2 = this.enabled.getHeight(null);
            this.cachedSize = new Dimension(n, n2);
        }
        return this.cachedSize;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public Image getImage(int n) {
        if (this.unselected_enabled != null) {
            return this.unselected_enabled;
        }
        return this.enabled;
    }

    public void updateThemeScheme(OyoahaThemeScheme oyoahaThemeScheme, OyoahaThemeSchemeChanged oyoahaThemeSchemeChanged) {
        this.scheme = oyoahaThemeScheme;
        if (oyoahaThemeSchemeChanged.enabled) {
            this.disposeDirty();
            this.init();
        }
    }

    protected void disposeDirty() {
        if (this.unselected_enabled != null) {
            this.unselected_enabled.flush();
            this.unselected_enabled = null;
        }
    }

    public void dispose() {
        if (this.enabled != null) {
            this.enabled.flush();
            this.enabled = null;
        }
        this.disposeDirty();
    }

    protected void init() {
        if (!this.scheme.isCustomEnabledColor()) {
            return;
        }
        int n = this.enabled.getWidth(null);
        int n2 = this.enabled.getHeight(null);
        int[] nArray = new int[n * n2];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(this.enabled, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unselected_enabled = OyoahaPoolUtilities.getColorizedImage2(nArray, n, n2, this.scheme.getEnabled());
    }
}

