/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaButtonLikeComponent;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaComboBoxEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class OyoahaComboBoxUI
extends MetalComboBoxUI
implements OyoahaButtonLikeComponent {
    private static Icon comboIcon;

    public static ComponentUI createUI(JComponent jComponent) {
        if (comboIcon == null && (comboIcon = UIManager.getIcon("ComboBox.icon")) == null) {
            comboIcon = new MetalComboBoxIcon();
        }
        return new OyoahaComboBoxUI();
    }

    public boolean isBorderPainted(Component component) {
        return true;
    }

    protected ComboBoxEditor createEditor() {
        return new OyoahaComboBoxEditor(this.comboBox.isEnabled());
    }

    protected ComboPopup createPopup() {
        BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
        basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return basicComboPopup;
    }

    protected ListCellRenderer createRenderer() {
        return (ListCellRenderer)UIManager.get("List.cellRenderer");
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.configureArrowButton();
        OyoahaUtilities.installRolloverListener(jComponent);
        OyoahaUtilities.setOpaque(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OyoahaUtilities.uninstallRolloverListener(jComponent);
        OyoahaUtilities.unsetOpaque(jComponent);
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        this.propertyChangeListener = new OyoahaPropertyChangeListener(this.comboBox);
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.keyListener = this.createKeyListener();
        this.focusListener = this.createFocusListener();
        this.popupKeyListener = this.popup.getKeyListener();
        this.popupMouseListener = this.popup.getMouseListener();
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OyoahaUtilities.paintBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        Insets insets = jComponent.getInsets();
        int n = dimension.height - (insets.top + insets.bottom);
        comboIcon.paintIcon(jComponent, graphics, dimension.width - (insets.right + 2 + comboIcon.getIconWidth()), (n - comboIcon.getIconHeight()) / 2 + insets.top);
        if (!this.comboBox.isEditable()) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setFont(this.currentValuePane.getFont());
            boolean bl = true;
            if (component instanceof JComponent) {
                bl = ((JComponent)component).isOpaque();
                ((JComponent)component).setOpaque(false);
            }
            if (!this.comboBox.isEnabled()) {
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                component.setForeground(this.comboBox.getForeground());
            }
            int n2 = dimension.width - (insets.left + insets.right + comboIcon.getIconWidth() + 4);
            this.currentValuePane.paintComponent(graphics, component, jComponent, insets.left, insets.top, n2, dimension.height - (insets.top + insets.bottom));
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(bl);
            }
        }
        if (jComponent.hasFocus()) {
            graphics.setColor(MetalLookAndFeel.getFocusColor());
            graphics.drawLine(insets.left, insets.top, dimension.width - (insets.right + 1), insets.top);
            graphics.drawLine(insets.left, dimension.height - (insets.bottom + 1), dimension.width - (insets.right + 1), dimension.height - (insets.bottom + 1));
        }
    }

    protected void installComponents() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
        this.arrowButton = null;
    }

    protected void uninstallComponents() {
        this.unconfigureArrowButton();
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    protected JButton createArrowButton() {
        return null;
    }

    public void configureArrowButton() {
        this.comboBox.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
        if (this.keyListener != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
    }

    public void unconfigureArrowButton() {
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
    }

    public class OyoahaPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        protected JComboBox comboBox;

        public OyoahaPropertyChangeListener(JComboBox jComboBox) {
            super(OyoahaComboBoxUI.this);
            this.comboBox = jComboBox;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            this.comboBox.setRequestFocusEnabled(true);
        }
    }
}

