/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxModel;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxNode;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxRenderer;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryModel;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaFileView;
import com.oyoaha.swing.plaf.oyoaha.icon.FileRendererIcon;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class OyoahaFileChooserUI
extends BasicFileChooserUI
implements ActionListener {
    protected JPanel centerPanel;
    protected JComboBox directoryComboBox;
    protected OyoahaDirectoryComboBoxModel directoryComboBoxModel;
    protected Action directoryComboBoxAction = new DirectoryComboBoxAction();
    protected FilterComboBoxModel filterComboBoxModel;
    protected JComboBox filterComboBox;
    protected JTextField filenameTextField;
    protected JList list;
    protected JButton approveButton;
    protected JButton cancelButton;
    protected JButton upFolderButton;
    protected JPanel bottomPanel;
    protected static final Dimension hstrut10 = new Dimension(6, 1);
    protected static final Dimension vstrut10 = new Dimension(1, 6);
    protected static final Insets insets = new Insets(0, 3, 0, 3);
    protected static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    protected int lookInLabelMnemonic = 0;
    protected String lookInLabelText = null;
    protected int fileNameLabelMnemonic = 0;
    protected String fileNameLabelText = null;
    protected int filesOfTypeLabelMnemonic = 0;
    protected String filesOfTypeLabelText = null;
    protected String upFolderToolTipText = null;
    protected String upFolderAccessibleName = null;
    protected String homeFolderToolTipText = null;
    protected String homeFolderAccessibleName = null;
    protected String newFolderToolTipText = null;
    protected String newFolderAccessibleName = null;
    protected String listViewButtonToolTipText = null;
    protected String listViewButtonAccessibleName = null;
    protected String detailsViewButtonToolTipText = null;
    protected String detailsViewButtonAccessibleName = null;
    protected PropertyChangeListener propertyChangeListener = null;
    protected AncestorListener ancestorListener = null;
    protected BasicFileChooserUI.AcceptAllFileFilter acceptAllFileFilter = new BasicFileChooserUI.AcceptAllFileFilter(this);
    protected OyoahaDirectoryModel model = null;
    protected FileView fileView;
    protected Action newFolderAction;
    protected Icon sortIcon;
    protected String sortButtonText;
    protected int organizedMode;
    protected int sortedMode;
    protected JPopupMenu popup;
    protected JTextField editCell = null;
    protected int lastIndex = -1;
    protected int currentEditingIndex = -1;
    protected boolean editing = false;
    protected int editX = 20;
    protected Action changeToParentDirectoryAction;
    protected int lastRowPosition;

    public OyoahaFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaFileChooserUI((JFileChooser)jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.popup = null;
    }

    protected void installIcons(JFileChooser jFileChooser) {
        super.installIcons(jFileChooser);
        this.sortIcon = UIManager.getIcon("FileChooser.sortIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.sortButtonText = UIManager.getString("FileChooser.sortButtonText");
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString("FileChooser.lookInLabelText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        super.uninstallIcons(jFileChooser);
        this.sortIcon = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        super.uninstallStrings(jFileChooser);
        this.sortButtonText = null;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.model);
        jFileChooser.removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
    }

    protected boolean getControlButtonsAreShown() {
        return true;
    }

    public void installComponents(JFileChooser jFileChooser) {
        OyoahaFileView oyoahaFileView = this.getOyoahaFileView(jFileChooser);
        Object object = oyoahaFileView.getFileChooserPreference("organize");
        this.organizedMode = object == null ? 0 : OyoahaDirectoryModel.getModeFromString(object.toString());
        object = oyoahaFileView.getFileChooserPreference("sort");
        this.sortedMode = object == null ? 0 : OyoahaDirectoryModel.geSortFromString(object.toString());
        jFileChooser.setLayout(new BoxLayout(jFileChooser, 1));
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jFileChooser.add(jPanel);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JButton jButton = new JButton(this.sortIcon);
        jButton.setToolTipText("Sort options");
        jButton.getAccessibleContext().setAccessibleName("Sort options");
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = OyoahaFileChooserUI.this.getSortPopupMenu();
                JButton jButton = (JButton)actionEvent.getSource();
                jPopupMenu.show(jButton, 0, jButton.getHeight());
            }
        });
        jPanel.add(Box.createRigidArea(hstrut10));
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.directoryComboBox = new JComboBox(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(180, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        jPanel.add(this.directoryComboBox);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.upFolderButton = new JButton(this.upFolderIcon);
        this.upFolderButton.setToolTipText(this.upFolderToolTipText);
        this.upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(0.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        this.upFolderButton.setMargin(shrinkwrap);
        this.upFolderButton.addActionListener(this.getChangeToParentDirectoryAction());
        jPanel.add(this.upFolderButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        JButton jButton2 = new JButton(this.newFolderIcon);
        jButton2.setToolTipText(this.newFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.addActionListener(this.getNewFolderAction());
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        JComponent jComponent = this.createList(jFileChooser);
        this.centerPanel.add((Component)jComponent, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent jComponent2 = jFileChooser.getAccessory();
        if (jComponent2 != null) {
            this.getAccessoryPanel().add(jComponent2);
        }
        jFileChooser.add(this.centerPanel);
        JPanel jPanel2 = this.getBottomPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.fileNameLabelText);
        jLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.filenameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenameTextField.setEditable(true);
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                OyoahaFileChooserUI.this.list.clearSelection();
            }
        });
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.setFileName(jFileChooser.getName(file));
        }
        JLabel jLabel2 = new JLabel(this.filesOfTypeLabelText);
        jLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        jLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return OyoahaFileChooserUI.this.approveButton.getPreferredSize().width > OyoahaFileChooserUI.this.cancelButton.getPreferredSize().width ? OyoahaFileChooserUI.this.approveButton.getPreferredSize() : OyoahaFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return OyoahaFileChooserUI.this.approveButton.getPreferredSize().width > OyoahaFileChooserUI.this.cancelButton.getPreferredSize().width ? OyoahaFileChooserUI.this.approveButton.getPreferredSize() : OyoahaFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        OyoahaFileChooserUI.installComponent(jPanel2, jLabel, 17, 1, insets, 0, 0, 1, 1, 0.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, this.filenameTextField, 10, 2, insets, 1, 0, 1, 1, 1.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, this.approveButton, 13, 1, insets, 2, 0, 1, 1, 0.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, new JPanel(), 10, 2, insets, 0, 1, 2, 1, 1.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, jLabel2, 17, 1, insets, 0, 2, 1, 1, 0.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, this.filterComboBox, 10, 2, insets, 1, 2, 1, 1, 1.0, 0.0);
        OyoahaFileChooserUI.installComponent(jPanel2, this.cancelButton, 13, 1, insets, 2, 2, 1, 1, 0.0, 0.0);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        Dimension dimension = jPanel2.getPreferredSize();
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, dimension.height));
        jFileChooser.add(jPanel2);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        if (this.getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public static final void installComponent(Container container, Component component, int n, int n2, Insets insets, int n3, int n4, int n5, int n6, double d, double d2) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridwidth = n5;
        gridBagConstraints.gridheight = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = n;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OyoahaDirectoryModel oyoahaDirectoryModel;
        String string = ((JComponent)actionEvent.getSource()).getName();
        if (string == null) {
            return;
        }
        if (string.startsWith("use_")) {
            if (string.equals("use_extention")) {
                this.organizedMode = 0;
            } else if (string.equals("use_csextention")) {
                this.organizedMode = 3;
            } else if (string.equals("use_type")) {
                this.organizedMode = 1;
            } else if (string.equals("use_none")) {
                this.organizedMode = 4;
            }
            OyoahaDirectoryModel oyoahaDirectoryModel2 = this.getOyoahaModel();
            if (oyoahaDirectoryModel2 != null) {
                this.list.clearSelection();
                oyoahaDirectoryModel2.setUse(this.organizedMode);
            }
        } else if (string.startsWith("by_")) {
            this.list.clearSelection();
            if (string.equals("by_name")) {
                this.sortedMode = 0;
            } else if (string.equals("by_csname")) {
                this.sortedMode = 1;
            } else if (string.equals("by_date")) {
                this.sortedMode = 3;
            } else if (string.equals("by_size")) {
                this.sortedMode = 2;
            }
            OyoahaDirectoryModel oyoahaDirectoryModel3 = this.getOyoahaModel();
            if (oyoahaDirectoryModel3 != null) {
                this.list.clearSelection();
                oyoahaDirectoryModel3.setMode(this.sortedMode);
            }
        } else if (string.equals("inverse") && (oyoahaDirectoryModel = this.getOyoahaModel()) != null) {
            this.list.clearSelection();
            oyoahaDirectoryModel.inverse();
        }
    }

    protected JPopupMenu getSortPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            JMenu jMenu = new JMenu("organize by...");
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Extention");
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Extention (Case Sensitive)");
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Type");
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("None");
            jRadioButtonMenuItem.setName("use_extention");
            jRadioButtonMenuItem2.setName("use_csextention");
            jRadioButtonMenuItem3.setName("use_type");
            jRadioButtonMenuItem4.setName("use_none");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            buttonGroup.add(jRadioButtonMenuItem3);
            buttonGroup.add(jRadioButtonMenuItem4);
            switch (this.organizedMode) {
                case 3: {
                    jRadioButtonMenuItem2.setSelected(true);
                    break;
                }
                case 1: {
                    jRadioButtonMenuItem3.setSelected(true);
                    break;
                }
                case 4: {
                    jRadioButtonMenuItem4.setSelected(true);
                    break;
                }
                default: {
                    jRadioButtonMenuItem.setSelected(true);
                }
            }
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem2.addActionListener(this);
            jRadioButtonMenuItem3.addActionListener(this);
            jRadioButtonMenuItem4.addActionListener(this);
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem2);
            jMenu.add(jRadioButtonMenuItem3);
            jMenu.add(jRadioButtonMenuItem4);
            this.popup.add(jMenu);
            JMenu jMenu2 = new JMenu("sort by...");
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem("Name");
            JRadioButtonMenuItem jRadioButtonMenuItem6 = new JRadioButtonMenuItem("Name (Case Sensitive)");
            JRadioButtonMenuItem jRadioButtonMenuItem7 = new JRadioButtonMenuItem("Size");
            JRadioButtonMenuItem jRadioButtonMenuItem8 = new JRadioButtonMenuItem("Date");
            jRadioButtonMenuItem5.setName("by_name");
            jRadioButtonMenuItem6.setName("by_csname");
            jRadioButtonMenuItem7.setName("by_size");
            jRadioButtonMenuItem8.setName("by_date");
            buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButtonMenuItem5);
            buttonGroup.add(jRadioButtonMenuItem6);
            buttonGroup.add(jRadioButtonMenuItem7);
            buttonGroup.add(jRadioButtonMenuItem8);
            switch (this.sortedMode) {
                case 1: {
                    jRadioButtonMenuItem6.setSelected(true);
                    break;
                }
                case 3: {
                    jRadioButtonMenuItem8.setSelected(true);
                    break;
                }
                case 2: {
                    jRadioButtonMenuItem7.setSelected(true);
                    break;
                }
                default: {
                    jRadioButtonMenuItem5.setSelected(true);
                }
            }
            jRadioButtonMenuItem5.addActionListener(this);
            jRadioButtonMenuItem6.addActionListener(this);
            jRadioButtonMenuItem7.addActionListener(this);
            jRadioButtonMenuItem8.addActionListener(this);
            jMenu2.add(jRadioButtonMenuItem5);
            jMenu2.add(jRadioButtonMenuItem6);
            jMenu2.add(jRadioButtonMenuItem7);
            jMenu2.add(jRadioButtonMenuItem8);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Inverse sort order");
            jCheckBoxMenuItem.setName("inverse");
            jCheckBoxMenuItem.addActionListener(this);
            jMenu2.add(jCheckBoxMenuItem);
            this.popup.add(jMenu2);
        }
        return this.popup;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void createModel() {
        this.model = new OyoahaDirectoryModel(this.getFileChooser(), this.getOyoahaFileView(this.getFileChooser()));
    }

    public OyoahaDirectoryModel getOyoahaModel() {
        return this.model;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.model);
        this.ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JButton jButton = OyoahaFileChooserUI.this.getApproveButton(OyoahaFileChooserUI.this.getFileChooser());
                if (jButton != null) {
                    jButton.requestFocus();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        jFileChooser.addAncestorListener(this.ancestorListener);
    }

    protected JComponent createList(JFileChooser jFileChooser) {
        this.list = new JList();
        this.list.setCellRenderer(new FileRenderer());
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getOyoahaModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        return jScrollPane;
    }

    protected void setEditIndex(int n) {
        this.lastIndex = n;
    }

    protected void resetEditIndex() {
        this.lastIndex = -1;
    }

    protected void cancelEdit() {
        this.editing = false;
        if (this.editCell != null && this.editCell.isVisible()) {
            if (this.currentEditingIndex >= 0) {
                File file;
                File file2 = (File)this.list.getModel().getElementAt(this.currentEditingIndex);
                String string = this.editCell.getText();
                if (!(string = string.trim()).equals(this.getFileChooser().getName(file2)) && file2.renameTo(file = this.getFileChooser().getFileSystemView().createFileObject(this.getFileChooser().getCurrentDirectory(), string))) {
                    this.getOyoahaModel().replace(file2, file);
                }
            }
            this.currentEditingIndex = -1;
            this.editCell.setVisible(false);
            this.editCell.setText("");
            this.editCell.setBounds(0, 0, 1, 1);
            this.list.remove(this.editCell);
        }
    }

    protected JTextField getEditCell() {
        if (this.editCell == null) {
            this.editCell = new JTextField();
            this.editCell.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(OyoahaUtilities.getColorFromScheme(102), 1), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
            this.editCell.addActionListener(new EditActionListener());
        }
        return this.editCell;
    }

    public void clearIconCache() {
        this.getOyoahaFileView(this.getFileChooser()).clearIconCache();
    }

    public OyoahaFileView getOyoahaFileView(JFileChooser jFileChooser) {
        FileView fileView = this.getFileView(jFileChooser);
        if (!(fileView instanceof OyoahaFileView)) {
            return new OyoahaFileView(jFileChooser);
        }
        return (OyoahaFileView)fileView;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        if (this.fileView == null) {
            this.fileView = new OyoahaFileView(jFileChooser);
        }
        return this.fileView;
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    protected void setFileSelected() {
        File file = this.getFileChooser().getSelectedFile();
        if (file != null && this.getOyoahaModel().contains(file)) {
            this.list.setSelectedIndex(this.getOyoahaModel().indexOf(file));
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        } else {
            this.list.clearSelection();
        }
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.cancelEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        if (file != null) {
            this.setFileName(this.getFileChooser().getName(file));
        } else {
            this.setFileName(null);
        }
        this.setFileSelected();
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        this.cancelEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.list.clearSelection();
        File file = this.getFileChooser().getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.getNewFolderAction().setEnabled(file.canWrite());
            if (file.getParent() == null) {
                this.upFolderButton.setEnabled(false);
            } else {
                this.upFolderButton.setEnabled(true);
            }
        }
    }

    protected void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.cancelEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.list.clearSelection();
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.cancelEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.list.clearSelection();
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
            this.list.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    protected void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    protected void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    protected void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    OyoahaFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    OyoahaFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    OyoahaFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    OyoahaFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    OyoahaFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    OyoahaFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty")) {
                    OyoahaFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    OyoahaFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    OyoahaFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.approveButton.setVisible(false);
        this.cancelButton.setVisible(false);
    }

    protected void addControlButtons() {
        this.approveButton.setVisible(true);
        this.cancelButton.setVisible(true);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        if (this.getOyoahaModel().contains(file)) {
            this.list.ensureIndexIsVisible(this.getOyoahaModel().indexOf(file));
        }
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getOyoahaModel().invalidateFileCache();
        this.getOyoahaModel().validateFileCache();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected OyoahaDirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new OyoahaDirectoryComboBoxRenderer(jFileChooser);
    }

    protected OyoahaDirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return this.getOyoahaFileView(jFileChooser).getFileSystem();
    }

    protected int getDepth(File file) {
        int n = 0;
        while (file.getParent() != null) {
            ++n;
            file = this.getFileChooser().getFileSystemView().createFileObject(file.getParent());
        }
        return n;
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        File file = this.getFileChooser().getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new OyoahaNewFolderAction();
        }
        return this.newFolderAction;
    }

    public Action getChangeToParentDirectoryAction() {
        if (this.changeToParentDirectoryAction == null) {
            this.changeToParentDirectoryAction = new OyoahaChangeToParentDirectoryAction();
        }
        return this.changeToParentDirectoryAction;
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new OyoahaDoubleClickListener(jList);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new OyoahaSelectionListener();
    }

    protected class OyoahaSelectionListener
    implements ListSelectionListener {
        protected OyoahaSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JFileChooser jFileChooser = OyoahaFileChooserUI.this.getFileChooser();
                JList jList = (JList)listSelectionEvent.getSource();
                if (jFileChooser.isMultiSelectionEnabled()) {
                    Object[] objectArray = jList.getSelectedValues();
                    if (objectArray != null) {
                        File[] fileArray = new File[objectArray.length];
                        int n = 0;
                        while (n < objectArray.length) {
                            fileArray[n] = (File)objectArray[n];
                            ++n;
                        }
                        jFileChooser.setSelectedFiles(fileArray);
                    }
                } else {
                    File file = (File)jList.getSelectedValue();
                    if (file != null) {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
    }

    protected class OyoahaEditCell
    implements Runnable {
        protected int index;

        public OyoahaEditCell(int n) {
            this.index = n;
        }

        public void run() {
            try {
                Thread.sleep(100L);
                if (OyoahaFileChooserUI.this.lastIndex == this.index && !OyoahaFileChooserUI.this.editing) {
                    OyoahaFileChooserUI.this.editing = true;
                    Rectangle rectangle = OyoahaFileChooserUI.this.list.getCellBounds(this.index, this.index);
                    Rectangle rectangle2 = OyoahaFileChooserUI.this.list.getVisibleRect();
                    OyoahaFileChooserUI.this.currentEditingIndex = this.index;
                    JTextField jTextField = OyoahaFileChooserUI.this.getEditCell();
                    jTextField.setBounds(0, 0, 1, 1);
                    jTextField.setVisible(true);
                    File file = (File)OyoahaFileChooserUI.this.list.getSelectedValue();
                    jTextField.setText(OyoahaFileChooserUI.this.getFileChooser().getName(file));
                    OyoahaFileChooserUI.this.list.add(jTextField);
                    jTextField.setBounds(OyoahaFileChooserUI.this.editX + rectangle.x, rectangle.y, rectangle.width - OyoahaFileChooserUI.this.editX, rectangle.height);
                    jTextField.selectAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class OyoahaDoubleClickListener
    implements MouseListener {
        protected JList list;

        public OyoahaDoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                OyoahaFileChooserUI.this.resetEditIndex();
                OyoahaFileChooserUI.this.cancelEdit();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = this.list.locationToIndex(mouseEvent.getPoint());
                    if (n >= 0) {
                        File file = (File)this.list.getModel().getElementAt(n);
                        if (OyoahaFileChooserUI.this.getFileChooser().isTraversable(file)) {
                            OyoahaFileChooserUI.this.lastRowPosition = n;
                            this.list.ensureIndexIsVisible(0);
                            this.list.clearSelection();
                            OyoahaFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                        } else {
                            OyoahaFileChooserUI.this.getFileChooser().approveSelection();
                        }
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    int n = this.list.locationToIndex(mouseEvent.getPoint());
                    if (n >= 0 && OyoahaFileChooserUI.this.lastIndex == n && !OyoahaFileChooserUI.this.editing) {
                        Thread thread = new Thread(new OyoahaEditCell(n));
                        thread.start();
                    } else {
                        if (n >= 0) {
                            OyoahaFileChooserUI.this.setEditIndex(n);
                        } else {
                            OyoahaFileChooserUI.this.resetEditIndex();
                        }
                        OyoahaFileChooserUI.this.cancelEdit();
                    }
                } else {
                    OyoahaFileChooserUI.this.resetEditIndex();
                    OyoahaFileChooserUI.this.cancelEdit();
                }
            }
            this.list.repaint();
        }
    }

    protected class OyoahaChangeToParentDirectoryAction
    extends AbstractAction {
        protected OyoahaChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OyoahaFileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    protected class OyoahaNewFolderAction
    extends AbstractAction {
        protected OyoahaNewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = OyoahaFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            OyoahaFileChooserUI.this.list.clearSelection();
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
            }
            catch (IOException iOException) {
                return;
            }
            jFileChooser.rescanCurrentDirectory();
            jFileChooser.ensureFileIsVisible(file2);
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OyoahaFileChooserUI.this.getFileChooser().setCurrentDirectory(((OyoahaDirectoryComboBoxNode)OyoahaFileChooserUI.this.directoryComboBox.getSelectedItem()).getFile());
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = OyoahaFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                OyoahaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = OyoahaFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    OyoahaFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return OyoahaFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return OyoahaFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends OyoahaListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                ((JLabel)component).setText(fileFilter.getDescription());
            }
            return component;
        }
    }

    protected class FileRenderer
    extends OyoahaListCellRenderer {
        protected FileRendererIcon fileRendererIcon;

        public FileRenderer() {
            this.drawsFocusBorderAroundIcon = false;
            this.fileRendererIcon = new FileRendererIcon();
            this.setIcon(this.fileRendererIcon);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color;
            Object object2;
            this.list = jList;
            this.selected = bl;
            this.hasFocus = bl;
            this.isLeftToRight = OyoahaUtilities.isLeftToRight(jList);
            File file = (File)object;
            String string = OyoahaFileChooserUI.this.getFileChooser().getName(file);
            if (OyoahaFileChooserUI.this.sortedMode == 3) {
                object2 = DateFormat.getDateInstance();
                this.setText(((DateFormat)object2).format(new Date(file.lastModified())) + " - " + string.toLowerCase());
            } else if (OyoahaFileChooserUI.this.sortedMode == 2) {
                if (file.isDirectory()) {
                    this.setText(string.toLowerCase());
                } else {
                    long l = file.length();
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    this.setText(numberFormat.format(l) + " - " + string.toLowerCase());
                }
            } else if (OyoahaFileChooserUI.this.sortedMode == 1) {
                this.setText(string);
            } else {
                this.setText(string.toLowerCase());
            }
            object2 = OyoahaFileChooserUI.this.getOyoahaFileView(OyoahaFileChooserUI.this.getFileChooser()).getIcon(file);
            if (object2 == null) {
                object2 = OyoahaFileChooserUI.this.getFileChooser().getIcon(file);
            }
            this.fileRendererIcon.icon = object2;
            if (bl || bl2) {
                OyoahaFileChooserUI.this.editX = this.getBorderStart();
                this.setForeground(jList.getSelectionForeground());
                this.fileRendererIcon.color = null;
            }
            this.fileRendererIcon.color = (color = OyoahaFileChooserUI.this.getOyoahaFileView(OyoahaFileChooserUI.this.getFileChooser()).getColor(file)) != null ? color : null;
            this.setForeground(jList.getForeground());
            this.setOpaque(false);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(UIManager.getBorder("List.selectionBorder"));
            return this;
        }

        public void paint(Graphics graphics) {
            int n;
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else {
                n = this.getLabelStart() - 1;
                if (n < 0) {
                    n = 0;
                }
            }
            Color color = this.selected ? this.list.getSelectionBackground() : this.list.getBackground();
            if (color == null) {
                color = this.getBackground();
            }
            graphics.setColor(color);
            if (this.selected) {
                OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("Tree.Renderer");
                if (this.isLeftToRight) {
                    Shape shape = OyoahaUtilities.normalizeClip(graphics, n, 0, this.getWidth() - 1 - n, this.getHeight());
                    if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                        oyoahaBackgroundObject.paintBackground(graphics, this, n, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                    } else {
                        OyoahaUtilities.paintColorBackground(graphics, this, n, 0, this.getWidth() - 1 - n, this.getHeight(), color, 1004);
                    }
                    graphics.setClip(shape);
                } else {
                    Shape shape = OyoahaUtilities.normalizeClip(graphics, 0, 0, this.getWidth() - 1 - n, this.getHeight());
                    if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                        oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                    } else {
                        OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, this.getWidth() - 1 - n, this.getHeight(), color, 1004);
                    }
                    graphics.setClip(shape);
                }
            }
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            if (OyoahaUtilities.isVersion("1.4")) {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 200;
                return dimension;
            }
            return super.getPreferredSize();
        }
    }

    protected class EditActionListener
    implements ActionListener {
        protected EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OyoahaFileChooserUI.this.cancelEdit();
            OyoahaFileChooserUI.this.list.repaint();
        }
    }
}

