/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class OyoahaInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected int buttonsWidth = 0;
    protected int paletteTitleHeight;
    protected Icon paletteCloseIcon;
    protected boolean isPalette = false;
    protected static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public OyoahaInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
    }

    protected void createButtons() {
        super.createButtons();
        Boolean bl = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        Border border = UIManager.getBorder("InternalFrame.buttonBorder");
        this.iconButton.putClientProperty("paintActive", bl);
        this.iconButton.setBorder(border);
        this.iconButton.getAccessibleContext().setAccessibleName("Iconify");
        this.maxButton.putClientProperty("paintActive", bl);
        this.maxButton.setBorder(border);
        this.maxButton.getAccessibleContext().setAccessibleName("Maximize");
        this.closeButton.putClientProperty("paintActive", bl);
        this.closeButton.setBorder(border);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new OyoahaPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new OyoahaTitlePaneLayout();
    }

    public void paint(Graphics graphics) {
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = this.frame.isSelected();
        OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("InternalFrameTitlePane");
        Color color = UIManager.getColor("Button.background");
        Rectangle rectangle = this.getBounds();
        if (oyoahaBackgroundObject != null && color instanceof UIResource) {
            if (bl) {
                oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, rectangle.width, rectangle.height, 1004);
            } else {
                oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, rectangle.width, rectangle.height, OyoahaUtilities.getStatus(this));
            }
        } else if (bl) {
            OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, rectangle.width, rectangle.height, color, 1004);
        } else {
            OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, rectangle.width, rectangle.height, color, OyoahaUtilities.getStatus(this));
        }
        if (this.frame.getTitle() != null) {
            Font font = graphics.getFont();
            graphics.setFont(UIManager.getFont("InternalFrame.titleFont"));
            if (bl) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            int n2 = (18 - n) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            String string = this.frame.getTitle();
            int n3 = rectangle.width - this.buttonsWidth;
            if (fontMetrics.stringWidth(string) < n3) {
                graphics.drawString(string, 2, n2);
                OyoahaUtilities.paintBump(graphics, this, fontMetrics.stringWidth(string) + 5, 1, rectangle.width - (this.buttonsWidth + fontMetrics.stringWidth(string) + 6), rectangle.height - 2, OyoahaUtilities.getStatus(this), -1, 1);
            } else {
                char[] cArray = string.toCharArray();
                int n4 = 0;
                int n5 = 1;
                while (n4 < n3 && n5 < cArray.length) {
                    n4 = fontMetrics.charsWidth(cArray, 0, n5++);
                }
                graphics.drawChars(cArray, 0, n5 - 1, 2, n2);
            }
            graphics.setFont(font);
        } else {
            OyoahaUtilities.paintBump(graphics, this, 1, 1, rectangle.width - (this.buttonsWidth + 2), rectangle.height - 2, OyoahaUtilities.getStatus(this), -1, 1);
        }
        this.paintChildren(graphics);
    }

    public void paintPalette(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("InternalFrameTitlePane");
        Color color = UIManager.getColor("Button.background");
        Rectangle rectangle = this.getBounds();
        if (oyoahaBackgroundObject != null && color instanceof UIResource) {
            if (this.frame.isSelected()) {
                oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, n, n2, 1004);
            } else {
                oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, n, n2, OyoahaUtilities.getStatus(this));
            }
        } else if (this.frame.isSelected()) {
            OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, n, n2, color, 1004);
        } else {
            OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, n, n2, color, OyoahaUtilities.getStatus(this));
        }
        OyoahaUtilities.paintBump(graphics, this, 1, 1, n - (this.buttonsWidth + 2), n2 - 2, OyoahaUtilities.getStatus(this), -1, 1);
        this.paintChildren(graphics);
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.repaint();
        this.revalidate();
    }

    protected final JInternalFrame getFrame() {
        return this.frame;
    }

    protected final JButton getIconButton() {
        return this.iconButton;
    }

    protected final JButton getCloseButton() {
        return this.closeButton;
    }

    protected final JButton getMaxButton() {
        return this.maxButton;
    }

    protected class OyoahaTitlePaneLayout
    implements LayoutManager {
        protected OyoahaTitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension getPreferredSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            Font font;
            int n3 = 22;
            if (OyoahaInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 19;
            }
            if (OyoahaInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 19;
            }
            if (OyoahaInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 19;
            }
            if ((font = OyoahaInternalFrameTitlePane.this.getFont()) == null) {
                font = UIManager.getFont("InternalFrame.font");
                if (font == null) {
                    font = OyoahaLookAndFeel.getWindowTitleFont();
                    OyoahaInternalFrameTitlePane.this.setFont(font);
                } else {
                    OyoahaInternalFrameTitlePane.this.setFont(font);
                }
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            String string = OyoahaInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n4 < (n = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
            n = fontMetrics.getHeight();
            n += 7;
            Icon icon = OyoahaInternalFrameTitlePane.this.getFrame().getFrameIcon();
            int n6 = 0;
            if (icon != null) {
                n6 = icon.getIconHeight();
            }
            int n7 = Math.max(n, n6 += 5);
            Dimension dimension = new Dimension(n3, n7);
            if (OyoahaInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = OyoahaInternalFrameTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            JButton jButton;
            int n;
            JInternalFrame jInternalFrame = OyoahaInternalFrameTitlePane.this.getFrame();
            boolean bl = OyoahaUtilities.isLeftToRight(jInternalFrame);
            int n2 = OyoahaInternalFrameTitlePane.this.getWidth();
            int n3 = bl ? n2 : 0;
            int n4 = 2;
            JButton jButton2 = OyoahaInternalFrameTitlePane.this.getCloseButton();
            int n5 = jButton2.getIcon().getIconHeight();
            int n6 = jButton2.getIcon().getIconWidth();
            if (jInternalFrame.isClosable()) {
                if (OyoahaInternalFrameTitlePane.this.isPalette) {
                    n = 2;
                    jButton2.setBounds(n3 += bl ? -n - (n6 + 2) : n, n4, n6 + 2, OyoahaInternalFrameTitlePane.this.getHeight() - 4);
                    if (!bl) {
                        n3 += n6 + 2;
                    }
                } else {
                    n = 2;
                    jButton2.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                    if (!bl) {
                        n3 += n6;
                    }
                }
            }
            if (jInternalFrame.isMaximizable() && !OyoahaInternalFrameTitlePane.this.isPalette) {
                jButton = OyoahaInternalFrameTitlePane.this.getMaxButton();
                n = 2;
                jButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            if (jInternalFrame.isIconifiable() && !OyoahaInternalFrameTitlePane.this.isPalette) {
                jButton = OyoahaInternalFrameTitlePane.this.getIconButton();
                n = jInternalFrame.isMaximizable() ? 2 : (jInternalFrame.isClosable() ? 4 : 2);
                jButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            OyoahaInternalFrameTitlePane.this.buttonsWidth = bl ? n2 - n3 : n3;
        }
    }

    protected class OyoahaPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        protected OyoahaPropertyChangeHandler() {
            super(OyoahaInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                OyoahaInternalFrameTitlePane.this.getIconButton().putClientProperty("paintActive", bl);
                OyoahaInternalFrameTitlePane.this.getCloseButton().putClientProperty("paintActive", bl);
                OyoahaInternalFrameTitlePane.this.getMaxButton().putClientProperty("paintActive", bl);
                OyoahaInternalFrameTitlePane.this.repaint();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

