/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class OyoahaListCellRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected boolean selected;
    protected boolean hasFocus;
    protected boolean drawsFocusBorderAroundIcon;
    protected boolean isLeftToRight = true;
    protected JList list;
    protected Border border;

    public OyoahaListCellRenderer() {
        this.setHorizontalAlignment(2);
        Object object = UIManager.get("List.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
        this.border = UIManager.getBorder("List.selectionBorder");
        this.setOpaque(false);
    }

    public int getStatus() {
        if (this.selected) {
            return 1004;
        }
        return 1000;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.list = jList;
        this.selected = bl;
        this.hasFocus = bl2;
        this.isLeftToRight = OyoahaUtilities.isLeftToRight(jList);
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(object == null ? "" : object.toString());
        }
        this.setOpaque(false);
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        this.setBorder(this.border);
        return this;
    }

    protected void setUI(ComponentUI componentUI) {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public void paint(Graphics graphics) {
        if (this.list == null) {
            return;
        }
        Color color = this.selected ? this.list.getSelectionBackground() : this.list.getBackground();
        graphics.setColor(color);
        int n = this.drawsFocusBorderAroundIcon ? 0 : this.getLabelStart();
        if (this.selected) {
            OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("List.Renderer");
            if (this.isLeftToRight) {
                Shape shape = OyoahaUtilities.normalizeClip(graphics, n, 0, this.getWidth() - 1 - n, this.getHeight());
                if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                    oyoahaBackgroundObject.paintBackground(graphics, this, n, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                } else {
                    graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
                }
                graphics.setClip(shape);
            } else {
                Shape shape = OyoahaUtilities.normalizeClip(graphics, 0, 0, this.getWidth() - 1 - n, this.getHeight());
                if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                    oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                } else {
                    graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
                }
                graphics.setClip(shape);
            }
        }
        super.paint(graphics);
    }

    protected int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    protected int getBorderStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() / 2);
        }
        return 0;
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            int n = this.drawsFocusBorderAroundIcon ? 0 : this.getBorderStart();
            if (this.isLeftToRight) {
                border.paintBorder(this, graphics, n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                border.paintBorder(this, graphics, 0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }
}

