/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class OyoahaPaintMenu {
    protected static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle acceleratorRect = new Rectangle();
    protected static Rectangle checkIconRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    protected static Rectangle r = new Rectangle();
    private static OyoahaPaintMenu paintMenu;

    protected OyoahaPaintMenu() {
    }

    public static final OyoahaPaintMenu getOyoahaPaintMenu() {
        if (paintMenu == null) {
            paintMenu = new OyoahaPaintMenu();
        }
        return paintMenu;
    }

    protected void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n, String string, Font font) {
        boolean bl;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string2 = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string3 = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string3 = KeyEvent.getKeyModifiersText(n2);
                string3 = string3 + string;
            }
            string3 = string3 + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        Font font2 = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font2);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(font);
        this.resetRects();
        this.layoutMenuItem((JMenuItem)jComponent, fontMetrics, string2, fontMetrics2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string2 == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(OyoahaPaintMenu.iconRect.x, OyoahaPaintMenu.iconRect.y, OyoahaPaintMenu.iconRect.width, OyoahaPaintMenu.iconRect.height, r);
        boolean bl2 = bl = string3 == null || string3.equals("");
        if (!bl) {
            OyoahaPaintMenu.r.width += OyoahaPaintMenu.acceleratorRect.width;
            OyoahaPaintMenu.r.width += 7 * n;
        }
        if (this.useCheckAndArrow((JMenuItem)jComponent)) {
            OyoahaPaintMenu.r.width += OyoahaPaintMenu.checkIconRect.width;
            OyoahaPaintMenu.r.width += n;
            OyoahaPaintMenu.r.width += n;
            OyoahaPaintMenu.r.width += OyoahaPaintMenu.arrowIconRect.width;
        }
        OyoahaPaintMenu.r.width += 2 * n;
        Insets insets = jMenuItem.getInsets();
        if (insets != null) {
            OyoahaPaintMenu.r.width += insets.left + insets.right;
            OyoahaPaintMenu.r.height += insets.top + insets.bottom;
        }
        if (OyoahaPaintMenu.r.width % 2 == 0) {
            ++OyoahaPaintMenu.r.width;
        }
        if (OyoahaPaintMenu.r.height % 2 == 0) {
            ++OyoahaPaintMenu.r.height;
        }
        return r.getSize();
    }

    protected void drawText(Graphics graphics, JMenuItem jMenuItem, ButtonModel buttonModel, FontMetrics fontMetrics, String string, Color color) {
        if (string != null) {
            View view = (View)jMenuItem.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else if (!buttonModel.isEnabled()) {
                if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                    graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), OyoahaPaintMenu.textRect.x, OyoahaPaintMenu.textRect.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), OyoahaPaintMenu.textRect.x, OyoahaPaintMenu.textRect.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), OyoahaPaintMenu.textRect.x - 1, OyoahaPaintMenu.textRect.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), OyoahaPaintMenu.textRect.x, OyoahaPaintMenu.textRect.y + fontMetrics.getAscent());
            }
        }
    }

    public void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n, String string, Font font, Color color3, Color color4, Color color5) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        JMenuItem jMenuItem2 = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        OyoahaPaintMenu.viewRect.x += insets.left;
        OyoahaPaintMenu.viewRect.y += insets.top;
        OyoahaPaintMenu.viewRect.width -= insets.right + OyoahaPaintMenu.viewRect.x;
        OyoahaPaintMenu.viewRect.height -= insets.bottom + OyoahaPaintMenu.viewRect.y;
        Font font2 = graphics.getFont();
        Font font3 = jComponent.getFont();
        graphics.setFont(font3);
        FontMetrics fontMetrics = graphics.getFontMetrics(font3);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(font);
        Color color6 = graphics.getColor();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n4);
                string2 = string2 + string;
            }
            string2 = string2 + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string3 = this.layoutMenuItem(jMenuItem2, fontMetrics, jMenuItem.getText(), fontMetrics2, string2, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            if (this.useCheckAndArrow(jMenuItem2)) {
                icon.paintIcon(jComponent, graphics, OyoahaPaintMenu.checkIconRect.x, OyoahaPaintMenu.checkIconRect.y);
            }
            graphics.setColor(color6);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                icon3.paintIcon(jComponent, graphics, OyoahaPaintMenu.iconRect.x, OyoahaPaintMenu.iconRect.y);
            }
        }
        this.drawText(graphics, jMenuItem, buttonModel, fontMetrics, string3, color2);
        if (string2 != null && !string2.equals("")) {
            graphics.setFont(font);
            if (!buttonModel.isEnabled()) {
                if (color3 != null) {
                    graphics.setColor(color3);
                    BasicGraphicsUtils.drawString(graphics, string2, 0, OyoahaPaintMenu.acceleratorRect.x, OyoahaPaintMenu.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string2, 0, OyoahaPaintMenu.acceleratorRect.x, OyoahaPaintMenu.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string2, 0, OyoahaPaintMenu.acceleratorRect.x - 1, OyoahaPaintMenu.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color5);
                } else {
                    graphics.setColor(color4);
                }
                BasicGraphicsUtils.drawString(graphics, string2, 0, OyoahaPaintMenu.acceleratorRect.x, OyoahaPaintMenu.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow(jMenuItem2)) {
                icon2.paintIcon(jComponent, graphics, OyoahaPaintMenu.arrowIconRect.x, OyoahaPaintMenu.arrowIconRect.y);
            }
        }
        graphics.setColor(color6);
        graphics.setFont(font2);
    }

    protected String layoutMenuItem(JMenuItem jMenuItem, FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(jMenuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow(jMenuItem)) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (OyoahaUtilities.isLeftToRight(jMenuItem)) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (this.useCheckAndArrow(jMenuItem)) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (this.useCheckAndArrow(jMenuItem)) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow(jMenuItem)) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    protected boolean useCheckAndArrow(JMenuItem jMenuItem) {
        boolean bl = true;
        if (jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }
}

