/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeScheme;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaScrollButton;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class OyoahaScrollBarUI
extends MetalScrollBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaScrollBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OyoahaUtilities.installRolloverListener(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OyoahaUtilities.uninstallRolloverListener(jComponent);
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new OyoahaScrollButton(n, this.scrollBarWidth, this.isFreeStanding, true, true);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new OyoahaScrollButton(n, this.scrollBarWidth, this.isFreeStanding, true, true);
        return this.increaseButton;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OyoahaUtilities.paintBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3 + 4, this.thumbRect.x + this.thumbRect.width + 4);
        int n8 = Math.max(n2 + n4 + 4, this.thumbRect.y + this.thumbRect.height + 4);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5, n8 - n6);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        OyoahaThemeScheme oyoahaThemeScheme = OyoahaUtilities.getScheme();
        if (this.scrollbar.getOrientation() == 1) {
            Shape shape = graphics.getClip();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("ScrollBarTrack");
            Color color = UIManager.getColor("ScrollBar.background");
            if (oyoahaBackgroundObject != null) {
                oyoahaBackgroundObject.paintBackground(graphics, jComponent, rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height - 1, OyoahaUtilities.getStatus(jComponent));
            } else {
                OyoahaUtilities.paintColorBackground(graphics, jComponent, rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height - 1, color, OyoahaUtilities.getStatus(jComponent));
            }
            if (jComponent.isEnabled()) {
                GradientPaint gradientPaint = new GradientPaint(rectangle.x + 3, 0.0f, new Color(0, 0, 0, 0), rectangle.x, 0.0f, new Color(0, 0, 0, 100), false);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRect(rectangle.x, rectangle.y, 3, rectangle.height);
                gradientPaint = new GradientPaint(0.0f, rectangle.y, new Color(0, 0, 0, 100), 0.0f, rectangle.y + 3, new Color(0, 0, 0, 0), false);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, 3);
                graphics.setColor(oyoahaThemeScheme.getBlack());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics.setColor(oyoahaThemeScheme.getWhite());
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            } else {
                graphics.setColor(oyoahaThemeScheme.getGray());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
            graphics.setClip(shape);
        } else {
            Shape shape = graphics.getClip();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("ScrollBarTrack");
            Color color = UIManager.getColor("ScrollBar.background");
            if (oyoahaBackgroundObject != null) {
                oyoahaBackgroundObject.paintBackground(graphics, jComponent, rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height, OyoahaUtilities.getStatus(jComponent));
            } else {
                OyoahaUtilities.paintColorBackground(graphics, jComponent, rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height, color, OyoahaUtilities.getStatus(jComponent));
            }
            if (jComponent.isEnabled()) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, rectangle.y + 3, new Color(0, 0, 0, 0), 0.0f, rectangle.y, new Color(0, 0, 0, 100), false);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, 3);
                gradientPaint = new GradientPaint(rectangle.x, 0.0f, new Color(0, 0, 0, 100), rectangle.x + 3, 0.0f, new Color(0, 0, 0, 0), false);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRect(rectangle.x, rectangle.y, 3, rectangle.height);
                graphics.setColor(oyoahaThemeScheme.getBlack());
                graphics.drawLine(rectangle.x - 1, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
                graphics.setColor(oyoahaThemeScheme.getWhite());
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            } else {
                graphics.setColor(oyoahaThemeScheme.getGray());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
            graphics.setClip(shape);
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            this.quickPaint(graphics, jComponent, rectangle.getBounds(), false);
        } else {
            this.quickPaint(graphics, jComponent, rectangle.getBounds(), true);
        }
    }

    private void quickPaint(Graphics graphics, JComponent jComponent, Rectangle rectangle, boolean bl) {
        Object object;
        OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("ScrollBarThumb");
        Color color = OyoahaUtilities.getBackground(jComponent);
        int n = OyoahaUtilities.getStatus(jComponent);
        if (rectangle.x > 0 || rectangle.y > 0) {
            object = graphics.getClip();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (color instanceof UIResource && oyoahaBackgroundObject != null) {
                oyoahaBackgroundObject.paintBackground(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
            } else {
                OyoahaUtilities.paintColorBackground(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, n);
            }
            graphics.setClip((Shape)object);
        } else if (color instanceof UIResource && oyoahaBackgroundObject != null) {
            oyoahaBackgroundObject.paintBackground(graphics, jComponent, 0, 0, rectangle.width, rectangle.height, n);
        } else {
            OyoahaUtilities.paintColorBackground(graphics, jComponent, 0, 0, rectangle.width, rectangle.height, color, n);
        }
        OyoahaUtilities.paintBump(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height, OyoahaUtilities.getStatus(jComponent), 1, 1);
        object = OyoahaUtilities.getScheme();
        if (OyoahaUtilities.getBoolean("oyoaha3dBorder")) {
            graphics.setColor(((OyoahaThemeScheme)object).getWhite());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
            graphics.setColor(((OyoahaThemeScheme)object).getGray());
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(((OyoahaThemeScheme)object).getBlack());
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        } else {
            graphics.setColor(((OyoahaThemeScheme)object).getBlack());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        if (bl) {
            GradientPaint gradientPaint = new GradientPaint(rectangle.x + rectangle.width, 0.0f, new Color(0, 0, 0, 100), rectangle.x + rectangle.width + 3, 0.0f, new Color(0, 0, 0, 0), false);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(rectangle.x + rectangle.width, rectangle.y, 3, rectangle.height);
        } else {
            GradientPaint gradientPaint = new GradientPaint(0.0f, rectangle.y + rectangle.height, new Color(0, 0, 0, 100), 0.0f, rectangle.y + rectangle.height + 3, new Color(0, 0, 0, 0), false);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(rectangle.x, rectangle.y + rectangle.height, rectangle.width, 3);
        }
    }
}

