/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeScheme;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalSliderUI;

public class OyoahaSliderUI
extends MetalSliderUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaSliderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OyoahaUtilities.installRolloverListener(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OyoahaUtilities.uninstallRolloverListener(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = OyoahaUtilities.getFullRect(jComponent);
        OyoahaUtilities.paintBackground(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height, OyoahaUtilities.getBackground(jComponent), 1000);
        this.paint(graphics, jComponent);
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (OyoahaUtilities.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    public void paintFocus(Graphics graphics) {
        boolean bl = OyoahaUtilities.isLeftToRight(this.slider);
        OyoahaThemeScheme oyoahaThemeScheme = OyoahaUtilities.getScheme();
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
        }
        graphics.setColor(OyoahaUtilities.getColorFromScheme(100));
        if (this.slider.getOrientation() == 0) {
            graphics.drawLine(n, n4 + 2, n3, n4 + 2);
        } else if (!bl) {
            graphics.drawLine(n - 2, n2, n - 2, n4);
        } else {
            graphics.drawLine(n3 + 2, n2, n3 + 2, n4);
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = MetalSliderUI.vertThumbIcon.getIconWidth() + 1;
            dimension.height = MetalSliderUI.vertThumbIcon.getIconHeight();
        } else {
            dimension.width = MetalSliderUI.horizThumbIcon.getIconWidth();
            dimension.height = MetalSliderUI.horizThumbIcon.getIconHeight() + 1;
        }
        return dimension;
    }

    public void paintTrack(Graphics graphics) {
        boolean bl = OyoahaUtilities.isLeftToRight(this.slider);
        OyoahaThemeScheme oyoahaThemeScheme = OyoahaUtilities.getScheme();
        Color color = !this.slider.isEnabled() ? oyoahaThemeScheme.getDisabled() : this.slider.getForeground();
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
        }
        Shape shape = OyoahaUtilities.normalizeClip(graphics, n, n2, n3 - n, n4 - n2);
        OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("SliderTrack");
        Color color2 = this.slider.getBackground();
        if (oyoahaBackgroundObject != null && color2 instanceof UIResource) {
            oyoahaBackgroundObject.paintBackground(graphics, this.slider, n, n2, n3 - n, n4 - n2, OyoahaUtilities.getStatus(this.slider));
        } else {
            OyoahaUtilities.paintColorBackground(graphics, this.slider, n, n2, n3 - n, n4 - n2, color2, OyoahaUtilities.getStatus(this.slider));
        }
        graphics.setClip(shape);
        if (this.slider.isEnabled()) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, n2 + 3, new Color(0, 0, 0, 0), 0.0f, n2, new Color(0, 0, 0, 100), false);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(n, n2, n3 - n, 3);
            gradientPaint = new GradientPaint(n, 0.0f, new Color(0, 0, 0, 100), n + 3, 0.0f, new Color(0, 0, 0, 0), false);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(n, n2, 3, n4 - n2);
            graphics.setColor(oyoahaThemeScheme.getWhite());
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(oyoahaThemeScheme.getBlack());
            graphics.drawLine(n, n2, n3 - 1, n2);
            graphics.drawLine(n, n2, n, n4 - 1);
        } else {
            graphics.setColor(OyoahaUtilities.getColor(1003));
            graphics.drawRect(n, n2, n3 - n - 1, n4 - n2 - 1);
        }
        if (this.filledSlider) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (this.slider.getOrientation() == 0) {
                n5 = this.thumbRect.x + this.thumbRect.width / 2;
                n5 -= this.trackRect.x;
                n6 = n2 + 1;
                n8 = n4 - 1;
                if (!this.drawInverted()) {
                    n7 = n + 1;
                    n9 = n5;
                } else {
                    n7 = n5;
                    n9 = n3 - 1;
                }
            } else {
                n5 = this.thumbRect.y + this.thumbRect.height / 2;
                n5 -= this.trackRect.y;
                n7 = n + 1;
                n9 = n3 - 1;
                if (!this.drawInverted()) {
                    n6 = n5;
                    n8 = n4 - 1;
                } else {
                    n6 = n2 + 1;
                    n8 = n5;
                }
            }
            if (this.slider.isEnabled()) {
                Color color3 = this.slider.getBackground();
                if (color3 instanceof UIResource) {
                    graphics.setColor(OyoahaUtilities.getColor(1004));
                } else {
                    graphics.setColor(color3);
                }
                graphics.fillRect(n7, n6, n9 - n7, n8 - n6);
                graphics.setColor(oyoahaThemeScheme.getWhite());
                graphics.drawLine(n7, n6, n9, n6);
                graphics.drawLine(n7, n6, n7, n8);
                graphics.setColor(oyoahaThemeScheme.getBlack());
                graphics.drawLine(n7, n8, n9, n8);
            } else {
                graphics.setColor(OyoahaUtilities.getColor(1003));
                graphics.fillRect(n7, n6, n9 - n7, n4 - n2);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        component.setEnabled(this.slider.isEnabled());
        super.paintHorizontalLabel(graphics, n, component);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        component.setEnabled(this.slider.isEnabled());
        super.paintVerticalLabel(graphics, n, component);
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(this.slider.isEnabled() ? OyoahaUtilities.getColorFromScheme(102) : OyoahaUtilities.getColorFromScheme(103));
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            graphics.translate(0, rectangle.y);
            int n5 = this.slider.getMinimum();
            int n6 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMinorTickSpacing();
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n5 = this.slider.getMinimum();
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMajorTickSpacing();
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n7 = this.slider.getMinimum();
            int n8 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n9 = 0;
                if (!OyoahaUtilities.isLeftToRight(this.slider)) {
                    n9 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n9, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMinorTickSpacing();
                }
                if (!OyoahaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(-n9, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n7 = this.slider.getMinimum();
                if (!OyoahaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMajorTickSpacing();
                }
                if (!OyoahaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? OyoahaUtilities.getColorFromScheme(102) : OyoahaUtilities.getColorFromScheme(103));
        graphics.drawLine(n, 4, n, 4 + MetalSliderUI.tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? OyoahaUtilities.getColorFromScheme(102) : OyoahaUtilities.getColorFromScheme(103));
        graphics.drawLine(n, 4, n, 4 + (MetalSliderUI.tickLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? OyoahaUtilities.getColorFromScheme(102) : OyoahaUtilities.getColorFromScheme(103));
        if (OyoahaUtilities.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + MetalSliderUI.tickLength / 2, n);
        } else {
            graphics.drawLine(0, n, MetalSliderUI.tickLength / 2, n);
        }
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? OyoahaUtilities.getColorFromScheme(102) : OyoahaUtilities.getColorFromScheme(103));
        if (OyoahaUtilities.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + MetalSliderUI.tickLength, n);
        } else {
            graphics.drawLine(0, n, MetalSliderUI.tickLength, n);
        }
    }
}

