/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class OyoahaTableUI
extends BasicTableUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaTableUI();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OyoahaUtilities.paintBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint(point);
        int n4 = this.table.columnAtPoint(point2);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintCells(graphics, n, n2, n3, n4);
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.table.isEnabled()) {
            graphics.setColor(this.table.getGridColor());
        } else {
            graphics.setColor(OyoahaUtilities.getColorFromScheme(103));
        }
        Rectangle rectangle = this.table.getCellRect(n, n3, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle2.x + rectangle2.width;
            n6 = rectangle.y;
            n5 = n;
            while (n5 <= n2) {
                graphics.drawLine(0, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
                ++n5;
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle2.y + rectangle2.height;
            n5 = rectangle.x;
            int n8 = n3;
            while (n8 <= n4) {
                graphics.drawLine((n5 += tableColumnModel.getColumn(n8).getWidth()) - 1, 0, n5 - 1, n6 - 1);
                ++n8;
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n) == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        int n6 = n;
        while (n6 <= n2) {
            Rectangle rectangle = this.table.getCellRect(n6, n3, false);
            int n7 = n3;
            while (n7 <= n4) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n7);
                int n8 = tableColumn2.getWidth();
                rectangle.width = n8 - n5;
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle, n6, n7);
                }
                rectangle.x += n8;
                ++n7;
            }
            ++n6;
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject(this.table);
        Color color = this.table.getBackground();
        int n7 = OyoahaUtilities.getStatus(this.table);
        if (oyoahaBackgroundObject != null && color instanceof UIResource) {
            oyoahaBackgroundObject.paintBackground(graphics, this.table, rectangle3.x, rectangle3.y, rectangle3.width - 1, rectangle3.height, n7);
        } else {
            OyoahaUtilities.paintColorBackground(graphics, this.table, rectangle3.x, rectangle3.y, rectangle3.width - 1, rectangle3.height, color, n7);
        }
        rectangle3.x += n3;
        if (oyoahaBackgroundObject != null && color instanceof UIResource) {
            oyoahaBackgroundObject.paintBackground(graphics, this.table, rectangle3.x, rectangle3.y, rectangle3.width - 1, rectangle3.height, n7);
        } else {
            OyoahaUtilities.paintColorBackground(graphics, this.table, rectangle3.x, rectangle3.y, rectangle3.width - 1, rectangle3.height, color, n7);
        }
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n5 + rectangle3.width - 1;
            n4 = n8 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n8, n5 - 1, n4);
            graphics.drawLine(n9, n8, n9, n4);
        }
        n5 = n;
        while (n5 <= n2) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (this.table.getShowHorizontalLines()) {
                graphics.setColor(this.table.getGridColor());
                Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
                rectangle5.x += n3;
                n4 = rectangle5.x;
                int n10 = rectangle5.y;
                int n11 = n4 + rectangle5.width - 1;
                int n12 = n10 + rectangle5.height - 1;
                graphics.drawLine(n4, n12, n11, n12);
            }
            ++n5;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            component.setEnabled(this.table.isEnabled());
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }
}

